/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class Utilities {
    private static final IPath ICONS_PATH = new Path("$nl$/icons/full/");
    private static final int VALIDATE_EDIT_PROBLEM = 10004;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void registerAction(IKeyBindingService kbs, IAction a, String id) {
        if (kbs != null) {
            a.setActionDefinitionId(id);
            kbs.registerAction(a);
        }
    }

    public static IWorkbenchPartSite findSite(Control c) {
        while (c != null && !c.isDisposed()) {
            Object data = c.getData();
            if (data instanceof IWorkbenchPart) {
                return ((IWorkbenchPart)data).getSite();
            }
            c = c.getParent();
        }
        return null;
    }

    public static IActionBars findActionBars(Control c) {
        while (c != null && !c.isDisposed()) {
            Object data = c.getData();
            if (data instanceof CompareEditor) {
                return ((CompareEditor)((Object)data)).getActionBars();
            }
            if (data instanceof IViewPart) {
                return ((IViewPart)data).getViewSite().getActionBars();
            }
            c = c.getParent();
        }
        return null;
    }

    public static void setEnableComposite(Composite composite, boolean enable) {
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(enable);
            ++i;
        }
    }

    public static boolean getBoolean(CompareConfiguration cc, String key, boolean dflt) {
        Object value;
        if (cc != null && (value = cc.getProperty(key)) instanceof Boolean) {
            return (Boolean)value;
        }
        return dflt;
    }

    public static void firePropertyChange(ListenerList ll, Object source, String property, Object old, Object newValue) {
        if (ll != null) {
            PropertyChangeEvent event = null;
            Object[] listeners = ll.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IPropertyChangeListener l = (IPropertyChangeListener)listeners[i];
                if (event == null) {
                    event = new PropertyChangeEvent(source, property, old, newValue);
                }
                l.propertyChange(event);
                ++i;
            }
        }
    }

    public static boolean okToUse(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    private static ArrayList internalGetResources(ISelection selection, Class type) {
        ArrayList<IResource> tmp = new ArrayList<IResource>();
        if (selection instanceof IStructuredSelection) {
            Object[] s = ((IStructuredSelection)selection).toArray();
            int i = 0;
            while (i < s.length) {
                IResource resource = null;
                Object o = s[i];
                if (type.isInstance(o)) {
                    resource = (IResource)o;
                } else if (o instanceof ResourceMapping) {
                    try {
                        ResourceTraversal[] travs = ((ResourceMapping)o).getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
                        if (travs != null) {
                            int k = 0;
                            while (k < travs.length) {
                                IResource[] resources = travs[k].getResources();
                                int j = 0;
                                while (j < resources.length) {
                                    if (type.isInstance(resources[j]) && resources[j].isAccessible()) {
                                        tmp.add(resources[j]);
                                    }
                                    ++j;
                                }
                                ++k;
                            }
                        }
                    }
                    catch (CoreException ex) {
                        CompareUIPlugin.log(ex);
                    }
                } else if (o instanceof IAdaptable) {
                    Object adapter;
                    IAdaptable a = (IAdaptable)o;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (type.isInstance(adapter = a.getAdapter((Class)clazz))) {
                        resource = (IResource)adapter;
                    }
                }
                if (resource != null && resource.isAccessible()) {
                    tmp.add(resource);
                }
                ++i;
            }
        }
        return tmp;
    }

    public static IResource[] getResources(ISelection selection) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ArrayList tmp = Utilities.internalGetResources(selection, clazz);
        return tmp.toArray(new IResource[tmp.size()]);
    }

    public static IFile[] getFiles(ISelection selection) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ArrayList tmp = Utilities.internalGetResources(selection, clazz);
        return tmp.toArray(new IFile[tmp.size()]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytes(InputStream in) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            try {
                int c;
                while ((c = in.read()) != -1) {
                    bos.write(c);
                }
            }
            catch (IOException iOException) {
                byte[] byArray = null;
                Object var3_4 = null;
                Utilities.close(in);
                try {
                    bos.close();
                    return byArray;
                }
                catch (IOException iOException2) {}
                return byArray;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            Utilities.close(in);
            try {}
            catch (IOException iOException) {}
            bos.close();
            throw throwable;
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        Utilities.close(in);
        try {}
        catch (IOException iOException) {
            return bos.toByteArray();
        }
        bos.close();
        return bos.toByteArray();
    }

    public static IPath getIconPath(Display display) {
        return ICONS_PATH;
    }

    public static void initAction(IAction a, ResourceBundle bundle, String prefix) {
        String labelKey = "label";
        String tooltipKey = "tooltip";
        String imageKey = "image";
        String descriptionKey = "description";
        if (prefix != null && prefix.length() > 0) {
            labelKey = String.valueOf(prefix) + labelKey;
            tooltipKey = String.valueOf(prefix) + tooltipKey;
            imageKey = String.valueOf(prefix) + imageKey;
            descriptionKey = String.valueOf(prefix) + descriptionKey;
        }
        a.setText(Utilities.getString(bundle, labelKey, labelKey));
        a.setToolTipText(Utilities.getString(bundle, tooltipKey, null));
        a.setDescription(Utilities.getString(bundle, descriptionKey, null));
        String relPath = Utilities.getString(bundle, imageKey, null);
        if (relPath != null && relPath.trim().length() > 0) {
            String ePath;
            String dPath;
            if (relPath.indexOf("/") >= 0) {
                String path = relPath.substring(1);
                dPath = String.valueOf('d') + path;
                ePath = String.valueOf('e') + path;
            } else {
                dPath = "dlcl16/" + relPath;
                ePath = "elcl16/" + relPath;
            }
            ImageDescriptor id = CompareUIPlugin.getImageDescriptor(dPath);
            if (id != null) {
                a.setDisabledImageDescriptor(id);
            }
            if ((id = CompareUIPlugin.getImageDescriptor(ePath)) != null) {
                a.setImageDescriptor(id);
                a.setHoverImageDescriptor(id);
            }
        }
    }

    public static void initToggleAction(IAction a, ResourceBundle bundle, String prefix, boolean checked) {
        String tooltip = null;
        tooltip = checked ? Utilities.getString(bundle, String.valueOf(prefix) + "tooltip.checked", null) : Utilities.getString(bundle, String.valueOf(prefix) + "tooltip.unchecked", null);
        if (tooltip == null) {
            tooltip = Utilities.getString(bundle, String.valueOf(prefix) + "tooltip", null);
        }
        if (tooltip != null) {
            a.setToolTipText(tooltip);
        }
        String description = null;
        description = checked ? Utilities.getString(bundle, String.valueOf(prefix) + "description.checked", null) : Utilities.getString(bundle, String.valueOf(prefix) + "description.unchecked", null);
        if (description == null) {
            description = Utilities.getString(bundle, String.valueOf(prefix) + "description", null);
        }
        if (description != null) {
            a.setDescription(description);
        }
    }

    public static String getString(ResourceBundle bundle, String key, String dfltValue) {
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return dfltValue;
    }

    public static String getFormattedString(ResourceBundle bundle, String key, String arg) {
        if (bundle != null) {
            try {
                return MessageFormat.format(bundle.getString(key), arg);
            }
            catch (MissingResourceException x) {
                CompareUIPlugin.log(x);
            }
        }
        return "!" + key + "!";
    }

    public static String getString(String key) {
        try {
            return CompareUI.getResourceBundle().getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    public static String getFormattedString(String key, String arg) {
        try {
            return MessageFormat.format(CompareUI.getResourceBundle().getString(key), arg);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    public static String getFormattedString(String key, String arg0, String arg1) {
        try {
            return MessageFormat.format(CompareUI.getResourceBundle().getString(key), arg0, arg1);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    public static String getString(ResourceBundle bundle, String key) {
        return Utilities.getString(bundle, key, key);
    }

    public static int getInteger(ResourceBundle bundle, String key, int dfltValue) {
        if (bundle != null) {
            try {
                String s = bundle.getString(key);
                if (s != null) {
                    return Integer.parseInt(s);
                }
            }
            catch (NumberFormatException x) {
                CompareUIPlugin.log(x);
            }
            catch (MissingResourceException x) {
                CompareUIPlugin.log(x);
            }
        }
        return dfltValue;
    }

    public static boolean validateResource(IResource resource, Shell shell, String title) {
        return Utilities.validateResources(new IResource[]{resource}, shell, title);
    }

    public static boolean validateResources(List resources, Shell shell, String title) {
        IResource[] r = resources.toArray(new IResource[resources.size()]);
        return Utilities.validateResources(r, shell, title);
    }

    public static boolean validateResources(IResource[] resources, Shell shell, String title) {
        List readOnlyFiles = Utilities.getReadonlyFiles(resources);
        if (readOnlyFiles.size() == 0) {
            return true;
        }
        Map oldTimeStamps = Utilities.createModificationStampMap(readOnlyFiles);
        IFile[] files = readOnlyFiles.toArray(new IFile[readOnlyFiles.size()]);
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(files, (Object)shell);
        if (!status.isOK()) {
            String message = Utilities.getString("ValidateEdit.error.unable_to_perform");
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
            return false;
        }
        IStatus modified = null;
        Map newTimeStamps = Utilities.createModificationStampMap(readOnlyFiles);
        Iterator iter = oldTimeStamps.keySet().iterator();
        while (iter.hasNext()) {
            Status entry;
            IFile file = (IFile)iter.next();
            if (file.isReadOnly()) {
                entry = new Status(4, CompareUIPlugin.getPluginId(), 10004, Utilities.getFormattedString("ValidateEdit.error.stillReadonly", file.getFullPath().toString()), null);
                modified = Utilities.addStatus(modified, (IStatus)entry);
                continue;
            }
            if (oldTimeStamps.get(file).equals(newTimeStamps.get(file))) continue;
            entry = new Status(4, CompareUIPlugin.getPluginId(), 10004, Utilities.getFormattedString("ValidateEdit.error.fileModified", file.getFullPath().toString()), null);
            modified = Utilities.addStatus(modified, (IStatus)entry);
        }
        if (modified != null) {
            String message = Utilities.getString("ValidateEdit.error.unable_to_perform");
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, modified);
            return false;
        }
        return true;
    }

    private static List getReadonlyFiles(IResource[] resources) {
        ArrayList<IResource> readOnlyFiles = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            ResourceAttributes resourceAttributes = resource.getResourceAttributes();
            if (resource.getType() == 1 && resourceAttributes != null && resourceAttributes.isReadOnly()) {
                readOnlyFiles.add(resource);
            }
            ++i;
        }
        return readOnlyFiles;
    }

    private static Map createModificationStampMap(List files) {
        HashMap<IFile, Long> map = new HashMap<IFile, Long>();
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            IFile file = (IFile)iter.next();
            map.put(file, new Long(file.getModificationStamp()));
        }
        return map;
    }

    private static IStatus addStatus(IStatus status, IStatus entry) {
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add(entry);
            return status;
        }
        MultiStatus result = new MultiStatus(CompareUIPlugin.getPluginId(), 10004, Utilities.getString("ValidateEdit.error.unable_to_perform"), null);
        result.add(status);
        result.add(entry);
        return result;
    }

    /*
     * Exception decompiling
     */
    public static String readString(InputStream is, String encoding) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 113->116)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getCharset(IResource resource) {
        if (resource instanceof IEncodedStorage) {
            try {
                return ((IEncodedStorage)resource).getCharset();
            }
            catch (CoreException ex) {
                CompareUIPlugin.log(ex);
            }
        }
        return ResourcesPlugin.getEncoding();
    }

    public static byte[] getBytes(String s, String encoding) {
        byte[] bytes = null;
        if (s != null) {
            try {
                bytes = s.getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = s.getBytes();
            }
        }
        return bytes;
    }

    public static String readString(IStreamContentAccessor sa) throws CoreException {
        InputStream is = sa.getContents();
        String encoding = null;
        if (sa instanceof IEncodedStreamContentAccessor) {
            encoding = ((IEncodedStreamContentAccessor)sa).getCharset();
        }
        if (encoding == null) {
            encoding = ResourcesPlugin.getEncoding();
        }
        return Utilities.readString(is, encoding);
    }

    public static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static IResource getFirstResource(ISelection selection) {
        IResource[] resources = Utilities.getResources(selection);
        if (resources.length > 0) {
            return resources[0];
        }
        return null;
    }
}

