/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IActivity;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.IInstallConfigurationChangedListener;
import org.eclipse.update.configuration.IProblemHandler;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.SiteEntry;
import org.eclipse.update.internal.core.BaseSiteLocalFactory;
import org.eclipse.update.internal.core.ConfigurationActivity;
import org.eclipse.update.internal.core.ConfigurationPolicy;
import org.eclipse.update.internal.core.ConfiguredSite;
import org.eclipse.update.internal.core.FragmentEntry;
import org.eclipse.update.internal.core.InternalSiteManager;
import org.eclipse.update.internal.core.ListenersList;
import org.eclipse.update.internal.core.LocalSite;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.SiteReconciler;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfigurationActivityModel;
import org.eclipse.update.internal.model.ConfiguredSiteModel;
import org.eclipse.update.internal.model.InstallConfigurationModel;
import org.osgi.framework.Bundle;

public class InstallConfiguration
extends InstallConfigurationModel
implements IInstallConfiguration {
    private static boolean isWindows = System.getProperty("os.name").startsWith("Win");
    private ListenersList listeners = new ListenersList();

    public InstallConfiguration() {
    }

    public InstallConfiguration(IInstallConfiguration config) throws MalformedURLException, CoreException {
        this(config, null, null);
    }

    public InstallConfiguration(IInstallConfiguration config, URL newLocation, String label) throws CoreException, MalformedURLException {
        IConfiguredSite[] csites;
        Date now = new Date();
        this.setCreationDate(now);
        this.setCurrent(false);
        if (newLocation == null) {
            String newFileName = UpdateManagerUtils.getLocalRandomIdentifier("platform.xml", now);
            newLocation = UpdateManagerUtils.getURL(((LocalSite)SiteManager.getLocalSite()).getLocationURL(), newFileName, null);
        }
        this.setLocationURLString(newLocation.toExternalForm());
        if (label == null) {
            label = Utilities.format(now);
        }
        this.setLabel(label);
        if (config != null && (csites = config.getConfiguredSites()) != null) {
            int i = 0;
            while (i < csites.length) {
                ConfiguredSite configSite = new ConfiguredSite(csites[i]);
                this.addConfigurationSiteModel(configSite);
                ++i;
            }
        }
        this.resolve(newLocation, null);
        this.initialized = true;
    }

    public IConfiguredSite[] getConfiguredSites() {
        ConfiguredSiteModel[] result = this.getConfigurationSitesModel();
        if (result.length == 0) {
            return new IConfiguredSite[0];
        }
        return (IConfiguredSite[])result;
    }

    private int getDefaultPolicy() {
        return 1;
    }

    public IConfiguredSite createConfiguredSite(File file) throws CoreException {
        if (!file.getName().equals("eclipse")) {
            file = new File(file, "eclipse");
            file.mkdirs();
        }
        if (this.isDuplicateSite(file)) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallConfiguration_location_exists, (Object[])new String[]{file.getPath()}), null);
        }
        BaseSiteLocalFactory factory = new BaseSiteLocalFactory();
        ISite site = InternalSiteManager.createSite(file);
        ConfiguredSite configSite = (ConfiguredSite)factory.createConfigurationSiteModel((SiteModel)((Object)site), this.getDefaultPolicy());
        if (configSite.isNativelyLinked()) {
            throw Utilities.newCoreException(Messages.InstallConfiguration_AlreadyNativelyLinked, null);
        }
        if (configSite.isProductSite()) {
            throw Utilities.newCoreException(Messages.InstallConfiguration_AlreadyProductSite, null);
        }
        if (site != null) {
            configSite.setPlatformURLString(site.getURL().toExternalForm());
            IPlatformConfiguration runtimeConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
            ConfigurationPolicy configurationPolicy = configSite.getConfigurationPolicy();
            String[] pluginPath = new String[]{};
            if (configurationPolicy.getPolicy() == 0) {
                pluginPath = configurationPolicy.getPluginPath(site);
            }
            IPlatformConfiguration.ISitePolicy sitePolicy = runtimeConfiguration.createSitePolicy(configurationPolicy.getPolicy(), pluginPath);
            IPlatformConfiguration.ISiteEntry siteEntry = runtimeConfiguration.createSiteEntry(site.getURL(), sitePolicy);
            runtimeConfiguration.configureSite(siteEntry);
            configSite.createPrivateSiteMarker();
            ((SiteModel)((Object)site)).setConfiguredSiteModel(configSite);
        }
        this.configure(configSite);
        return configSite;
    }

    public IConfiguredSite createLinkedConfiguredSite(File file) throws CoreException {
        return this.createConfiguredSite(file);
    }

    private void configure(ConfiguredSite linkedSite) throws CoreException {
        ISite site = linkedSite.getSite();
        ISiteFeatureReference[] newFeaturesRef = site.getFeatureReferences();
        int i = 0;
        while (i < newFeaturesRef.length) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                String reconciliationType = "enable (optimistic)";
                UpdateCore.debug("New Linked Site:New Feature: " + newFeaturesRef[i].getURL() + " as " + reconciliationType);
            }
            ConfigurationPolicy policy = linkedSite.getConfigurationPolicy();
            policy.configure(newFeaturesRef[i], true, false);
            ++i;
        }
        SiteReconciler.checkConfiguredFeatures(linkedSite);
    }

    public void addConfiguredSite(IConfiguredSite site) {
        if (!this.isCurrent() && this.isReadOnly()) {
            return;
        }
        ConfigurationActivity activity = new ConfigurationActivity(3);
        activity.setLabel(site.getSite().getURL().toExternalForm());
        activity.setDate(new Date());
        ConfiguredSiteModel configSiteModel = (ConfiguredSiteModel)((Object)site);
        this.addConfigurationSiteModel(configSiteModel);
        configSiteModel.setInstallConfigurationModel(this);
        Object[] configurationListeners = this.listeners.getListeners();
        int i = 0;
        while (i < configurationListeners.length) {
            IInstallConfigurationChangedListener listener = (IInstallConfigurationChangedListener)configurationListeners[i];
            listener.installSiteAdded(site);
            ++i;
        }
        activity.setStatus(0);
        this.addActivity(activity);
    }

    public void addActivity(IActivity activity) {
        this.addActivityModel((ConfigurationActivityModel)((Object)activity));
    }

    public void removeConfiguredSite(IConfiguredSite site) {
        if (!this.isCurrent() && this.isReadOnly()) {
            return;
        }
        if (this.removeConfigurationSiteModel((ConfiguredSiteModel)((Object)site))) {
            Object[] configurationListeners = this.listeners.getListeners();
            int i = 0;
            while (i < configurationListeners.length) {
                IInstallConfigurationChangedListener listener = (IInstallConfigurationChangedListener)configurationListeners[i];
                listener.installSiteRemoved(site);
                ++i;
            }
            ConfigurationActivity activity = new ConfigurationActivity(4);
            activity.setLabel(site.getSite().getURL().toExternalForm());
            activity.setDate(new Date());
            activity.setStatus(0);
            this.addActivity(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstallConfigurationChangedListener(IInstallConfigurationChangedListener listener) {
        ListenersList listenersList = this.listeners;
        synchronized (listenersList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstallConfigurationChangedListener(IInstallConfigurationChangedListener listener) {
        ListenersList listenersList = this.listeners;
        synchronized (listenersList) {
            this.listeners.remove(listener);
        }
    }

    public void remove() {
        if ("file".equalsIgnoreCase(this.getURL().getProtocol())) {
            File file = new File(this.getURL().getFile());
            UpdateManagerUtils.removeFromFileSystem(file);
        }
    }

    public boolean save() throws CoreException {
        IPlatformConfiguration runtimeConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
        ConfiguredSiteModel[] configurationSites = this.getConfigurationSitesModel();
        IPlatformConfiguration.IFeatureEntry[] configuredFeatureEntries = runtimeConfiguration.getConfiguredFeatureEntries();
        int i = 0;
        while (i < configuredFeatureEntries.length) {
            runtimeConfiguration.unconfigureFeatureEntry(configuredFeatureEntries[i]);
            ++i;
        }
        IPlatformConfiguration tempConfig = null;
        try {
            tempConfig = ConfiguratorUtils.getPlatformConfiguration(null);
            IPlatformConfiguration.ISiteEntry[] tmpSites = runtimeConfiguration.getConfiguredSites();
            int i2 = 0;
            while (i2 < tmpSites.length) {
                tempConfig.configureSite(tmpSites[i2]);
                ++i2;
            }
        }
        catch (IOException iOException) {}
        this.checkSites(configurationSites, runtimeConfiguration);
        int i3 = 0;
        while (i3 < configurationSites.length) {
            ConfiguredSite cSite = (ConfiguredSite)configurationSites[i3];
            ConfigurationPolicy configurationPolicy = cSite.getConfigurationPolicy();
            this.savePluginPath(cSite, runtimeConfiguration, tempConfig);
            IFeatureReference[] configuredFeaturesRef = configurationPolicy.getConfiguredFeatures();
            int j = 0;
            while (j < configuredFeaturesRef.length) {
                IFeature feature = null;
                try {
                    feature = configuredFeaturesRef[j].getFeature(null);
                }
                catch (CoreException e) {
                    UpdateCore.warn(null, e);
                }
                this.saveFeatureEntry(cSite, feature, runtimeConfiguration);
                ++j;
            }
            ++i3;
        }
        if (tempConfig != null) {
            IPlatformConfiguration.ISiteEntry[] tmpSites = tempConfig.getConfiguredSites();
            int i4 = 0;
            while (i4 < tmpSites.length) {
                runtimeConfiguration.unconfigureSite(tmpSites[i4]);
                ++i4;
            }
        }
        try {
            runtimeConfiguration.save();
            this.date = new Date(runtimeConfiguration.getChangeStamp());
            if ("file".equalsIgnoreCase(this.getURL().getProtocol())) {
                UpdateCore.log(this);
            }
            this.resetActivities();
            return this.isRestartNeeded(runtimeConfiguration);
        }
        catch (IOException e) {
            CoreException exc = Utilities.newCoreException(NLS.bind((String)Messages.InstallConfiguration_UnableToSavePlatformConfiguration, (Object[])new String[]{runtimeConfiguration.getConfigurationLocation().toExternalForm()}), e);
            UpdateCore.warn("", exc);
            return true;
        }
    }

    private void savePluginPath(ConfiguredSite cSite, IPlatformConfiguration runtimeConfiguration, IPlatformConfiguration tempConfig) throws CoreException {
        ConfigurationPolicy configurationPolicy = cSite.getConfigurationPolicy();
        String[] pluginPath = configurationPolicy.getPluginPath(cSite.getSite());
        IPlatformConfiguration.ISitePolicy sitePolicy = runtimeConfiguration.createSitePolicy(configurationPolicy.getPolicy(), pluginPath);
        URL urlToCheck = null;
        try {
            urlToCheck = new URL(cSite.getPlatformURLString());
        }
        catch (MalformedURLException e) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallConfiguration_UnableToCreateURL, (Object[])new String[]{cSite.getPlatformURLString()}), e);
        }
        catch (ClassCastException e) {
            throw Utilities.newCoreException(Messages.InstallConfiguration_UnableToCast, e);
        }
        IPlatformConfiguration.ISiteEntry siteEntry = runtimeConfiguration.findConfiguredSite(urlToCheck);
        if (siteEntry == null) {
            siteEntry = runtimeConfiguration.createSiteEntry(urlToCheck, sitePolicy);
        } else {
            siteEntry.setSitePolicy(sitePolicy);
            ((SiteEntry)siteEntry).refreshPlugins();
            if (tempConfig != null) {
                tempConfig.unconfigureSite(siteEntry);
            }
        }
        ((SiteEntry)siteEntry).setEnabled(cSite.isEnabled());
        runtimeConfiguration.configureSite(siteEntry, true);
    }

    private void saveFeatureEntry(ConfiguredSite cSite, IFeature feature, IPlatformConfiguration runtimeConfiguration) throws CoreException {
        if (feature == null) {
            return;
        }
        String id = feature.getVersionedIdentifier().getIdentifier();
        IPluginEntry[] entries = feature.getPluginEntries();
        URL url = null;
        IPluginEntry featurePlugin = null;
        int k = 0;
        while (k < entries.length) {
            if (id.equalsIgnoreCase(entries[k].getVersionedIdentifier().getIdentifier())) {
                url = this.getRuntimeConfigurationURL(entries[k], cSite);
                featurePlugin = entries[k];
                break;
            }
            ++k;
        }
        String pluginVersion = null;
        if (featurePlugin != null) {
            pluginVersion = featurePlugin.getVersionedIdentifier().getVersion().toString();
        }
        if (feature.isPrimary()) {
            ArrayList<URL> list = new ArrayList<URL>();
            if (url != null) {
                list.add(url);
            }
            if (featurePlugin != null) {
                URL[] fragments = this.getRuntimeFragmentURLs(featurePlugin);
                list.addAll(Arrays.asList(fragments));
            }
            URL[] roots = list.toArray(new URL[0]);
            String pluginIdentifier = feature.getPrimaryPluginID();
            String version = feature.getVersionedIdentifier().getVersion().toString();
            String application = feature.getApplication();
            FeatureEntry featureEntry = (FeatureEntry)runtimeConfiguration.createFeatureEntry(id, version, pluginIdentifier, pluginVersion, true, application, roots);
            featureEntry.setURL(this.getFeatureRelativeURL(feature));
            SiteEntry siteEntry = (SiteEntry)runtimeConfiguration.findConfiguredSite(cSite.getSite().getURL());
            siteEntry.addFeatureEntry((IPlatformConfiguration.IFeatureEntry)featureEntry);
        } else {
            String version = feature.getVersionedIdentifier().getVersion().toString();
            String pluginIdentifier = feature.getPrimaryPluginID();
            FeatureEntry featureEntry = (FeatureEntry)runtimeConfiguration.createFeatureEntry(id, version, pluginIdentifier, pluginVersion, false, null, null);
            featureEntry.setURL(this.getFeatureRelativeURL(feature));
            SiteEntry siteEntry = (SiteEntry)runtimeConfiguration.findConfiguredSite(cSite.getSite().getURL());
            siteEntry.addFeatureEntry((IPlatformConfiguration.IFeatureEntry)featureEntry);
        }
        IPluginEntry[] platformPlugins = this.getPlatformPlugins(feature, runtimeConfiguration);
        int k2 = 0;
        while (k2 < platformPlugins.length) {
            id = platformPlugins[k2].getVersionedIdentifier().getIdentifier();
            url = this.getRuntimeConfigurationURL(platformPlugins[k2], cSite);
            if (url != null) {
                runtimeConfiguration.setBootstrapPluginLocation(id, url);
            }
            ++k2;
        }
    }

    private void checkSites(ConfiguredSiteModel[] configurationSites, IPlatformConfiguration runtimeConfiguration) throws CoreException {
        int i = 0;
        while (i < configurationSites.length) {
            URL urlToCheck = null;
            try {
                urlToCheck = new URL(configurationSites[i].getPlatformURLString());
            }
            catch (MalformedURLException e) {
                UpdateCore.warn(NLS.bind((String)Messages.InstallConfiguration_UnableToCreateURL, (Object[])new String[]{configurationSites[i].getPlatformURLString()}), e);
            }
            catch (ClassCastException e) {
                UpdateCore.warn(Messages.InstallConfiguration_UnableToCast, e);
            }
            IPlatformConfiguration.ISiteEntry siteEntry = runtimeConfiguration.findConfiguredSite(urlToCheck);
            if (siteEntry == null) {
                UpdateCore.warn(NLS.bind((String)Messages.InstallConfiguration_unableToFindSite, (Object[])new String[]{urlToCheck.toExternalForm(), runtimeConfiguration.getConfigurationLocation().toExternalForm()}));
            }
            ++i;
        }
    }

    public void revertTo(IInstallConfiguration configuration, IProgressMonitor monitor, IProblemHandler handler) throws CoreException, InterruptedException {
        IConfiguredSite[] oldConfigSites = configuration.getConfiguredSites();
        IConfiguredSite[] nowConfigSites = this.getConfiguredSites();
        Hashtable<String, IConfiguredSite> oldSitesMap = new Hashtable<String, IConfiguredSite>(0);
        Hashtable<String, IConfiguredSite> newSitesMap = new Hashtable<String, IConfiguredSite>(0);
        int i = 0;
        while (i < oldConfigSites.length) {
            IConfiguredSite element = oldConfigSites[i];
            oldSitesMap.put(element.getSite().getURL().toExternalForm(), element);
            newSitesMap.put(element.getSite().getURL().toExternalForm(), element);
            ++i;
        }
        if (nowConfigSites != null) {
            String key = null;
            int i2 = 0;
            while (i2 < nowConfigSites.length) {
                key = nowConfigSites[i2].getSite().getURL().toExternalForm();
                IConfiguredSite oldSite = (IConfiguredSite)oldSitesMap.get(key);
                if (oldSite != null) {
                    ((ConfiguredSite)nowConfigSites[i2]).revertTo(oldSite, monitor, handler);
                } else {
                    ISiteFeatureReference[] featuresToUnconfigure = nowConfigSites[i2].getSite().getFeatureReferences();
                    int j = 0;
                    while (j < featuresToUnconfigure.length) {
                        IFeature featureToUnconfigure = null;
                        try {
                            featureToUnconfigure = featuresToUnconfigure[j].getFeature(null);
                        }
                        catch (CoreException e) {
                            UpdateCore.warn(null, e);
                        }
                        if (featureToUnconfigure != null) {
                            nowConfigSites[i2].unconfigure(featureToUnconfigure);
                        }
                        ++j;
                    }
                }
                newSitesMap.put(key, nowConfigSites[i2]);
                ++i2;
            }
            Collection sites = newSitesMap.values();
            if (sites != null && !sites.isEmpty()) {
                ConfiguredSiteModel[] sitesModel = new ConfiguredSiteModel[sites.size()];
                sites.toArray(sitesModel);
                this.setConfigurationSiteModel(sitesModel);
            }
        }
    }

    public IActivity[] getActivities() {
        if (this.getActivityModel().length == 0) {
            return new IActivity[0];
        }
        return (IActivity[])this.getActivityModel();
    }

    private IPluginEntry[] getPlatformPlugins(IFeature feature, IPlatformConfiguration runtimeConfiguration) {
        HashMap<String, IPluginEntry> featurePlatformPlugins = new HashMap<String, IPluginEntry>();
        String[] platformPluginID = runtimeConfiguration.getBootstrapPluginIdentifiers();
        IPluginEntry[] featurePlugins = feature.getPluginEntries();
        int i = 0;
        while (i < platformPluginID.length) {
            String featurePluginId = null;
            int j = 0;
            while (j < featurePlugins.length) {
                featurePluginId = featurePlugins[j].getVersionedIdentifier().getIdentifier();
                if (platformPluginID[i].equals(featurePluginId)) {
                    featurePlatformPlugins.put(platformPluginID[i], featurePlugins[j]);
                }
                ++j;
            }
            ++i;
        }
        Collection values = featurePlatformPlugins.values();
        if (values == null || values.size() == 0) {
            return new IPluginEntry[0];
        }
        IPluginEntry[] result = new IPluginEntry[values.size()];
        Iterator iter = values.iterator();
        int index = 0;
        while (iter.hasNext()) {
            result[index] = (IPluginEntry)iter.next();
            ++index;
        }
        return result;
    }

    private URL getRuntimeConfigurationURL(IPluginEntry entry, ConfiguredSite cSite) throws CoreException {
        String rootString = cSite.getPlatformURLString();
        String pluginPathID = this.getPathID(entry);
        try {
            String fileString;
            ISiteContentProvider siteContentProvider = cSite.getSite().getSiteContentProvider();
            URL pluginEntryfullURL = siteContentProvider.getArchiveReference(pluginPathID);
            if (!rootString.startsWith("platform")) {
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                    UpdateCore.debug("getRuntimeConfiguration Plugin Entry Full URL:" + pluginEntryfullURL + " Platform String:" + rootString + " [NON PLATFORM URL].");
                }
                return pluginEntryfullURL;
            }
            URL pluginEntryRootURL = cSite.getSite().getURL();
            String relativeString = UpdateManagerUtils.getURLAsString(pluginEntryRootURL, pluginEntryfullURL);
            URL result = new URL(new URL(rootString), relativeString);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.debug("getRuntimeConfiguration plugin Entry Full URL:" + pluginEntryfullURL + " Platform String:" + rootString + " Site URL:" + pluginEntryRootURL + " Relative:" + relativeString);
            }
            if (pluginEntryfullURL != null && "file".equals(pluginEntryfullURL.getProtocol()) && !new File(fileString = pluginEntryfullURL.getFile()).exists()) {
                UpdateCore.warn("The URL:" + result + " doesn't point to a valid platform plugin.The URL will not be written in the platform configuration", new Exception());
                return null;
            }
            return result;
        }
        catch (IOException e) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.InstallConfiguration_UnableToCreateURL, (Object[])new String[]{rootString}), e);
        }
    }

    private URL[] getRuntimeFragmentURLs(IPluginEntry entry) throws CoreException {
        VersionedIdentifier vid = entry.getVersionedIdentifier();
        Bundle bundle = Platform.getBundle((String)vid.getIdentifier());
        ArrayList<URL> list = new ArrayList<URL>();
        if (bundle != null && bundle.getState() != 1 && bundle.getState() != 2) {
            FragmentEntry[] fragments = UpdateManagerUtils.getFragments(bundle);
            int i = 0;
            while (fragments != null && i < fragments.length) {
                String location = fragments[i].getLocation();
                try {
                    URL locationURL = new URL(location);
                    locationURL = Platform.asLocalURL((URL)Platform.resolve((URL)locationURL));
                    list.add(this.asInstallRelativeURL(locationURL));
                }
                catch (IOException iOException) {}
                ++i;
            }
        }
        return list.toArray(new URL[0]);
    }

    private String getPathID(IPluginEntry entry) {
        return "plugins/" + entry.getVersionedIdentifier().toString() + ".jar";
    }

    private URL asInstallRelativeURL(URL url) {
        URL install = ConfiguratorUtils.getInstallURL();
        if (install.getProtocol().equals(url.getProtocol()) && install.getProtocol().equals("file")) {
            int ix;
            String urlS;
            String installS = new File(install.getFile()).getAbsolutePath().replace(File.separatorChar, '/');
            if (!installS.endsWith("/")) {
                installS = String.valueOf(installS) + "/";
            }
            if (!(urlS = new File(url.getFile()).getAbsolutePath().replace(File.separatorChar, '/')).endsWith("/")) {
                urlS = String.valueOf(urlS) + "/";
            }
            if ((ix = installS.lastIndexOf("/")) != -1 && urlS.startsWith(installS = installS.substring(0, ix + 1))) {
                try {
                    return new URL("platform:/base/" + urlS.substring(installS.length()));
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        return url;
    }

    private boolean isDuplicateSite(File siteDirectory) {
        URL fileURL;
        IConfiguredSite[] sites = this.getConfiguredSites();
        try {
            fileURL = siteDirectory.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        int i = 0;
        while (i < sites.length) {
            URL url = sites[i].getSite().getURL();
            if (UpdateManagerUtils.sameURL(fileURL, url)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getFeatureRelativeURL(IFeature feature) {
        String siteURL;
        String url = feature.getURL().toExternalForm();
        if (url.startsWith(siteURL = feature.getSite().getURL().toExternalForm())) {
            return url.substring(siteURL.length());
        }
        return url;
    }

    private boolean isRestartNeeded(IPlatformConfiguration runtimeConfig) {
        int i;
        HashSet<String> newPluginsSet = null;
        if (runtimeConfig instanceof PlatformConfiguration) {
            newPluginsSet = ((PlatformConfiguration)runtimeConfig).getPluginPaths();
            if (isWindows) {
                String[] newPluginsSetArray = newPluginsSet.toArray(new String[newPluginsSet.size()]);
                i = 0;
                while (i < newPluginsSetArray.length) {
                    newPluginsSet.add(newPluginsSetArray[i].toLowerCase());
                    ++i;
                }
            }
        } else {
            URL[] newBundlePaths = runtimeConfig.getPluginPath();
            newPluginsSet = new HashSet<String>(newBundlePaths.length);
            i = 0;
            while (i < newBundlePaths.length) {
                String pluginLocation = newBundlePaths[i].getFile();
                newPluginsSet.add(pluginLocation);
                if (isWindows) {
                    newPluginsSet.add(pluginLocation.toLowerCase());
                }
                ++i;
            }
        }
        Bundle[] oldBundles = UpdateCore.getPlugin().getBundleContext().getBundles();
        int offset = "update@".length();
        int i2 = 0;
        while (i2 < oldBundles.length) {
            String oldBundleLocation;
            if (!(oldBundles[i2].getBundleId() == 0L || !(oldBundleLocation = oldBundles[i2].getLocation()).startsWith("update@") || newPluginsSet.contains(oldBundleLocation = oldBundleLocation.substring(offset)) || isWindows && newPluginsSet.contains(oldBundleLocation.toLowerCase()))) {
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                    UpdateCore.debug("Bundle " + oldBundleLocation + " has been removed");
                }
                return true;
            }
            ++i2;
        }
        if (runtimeConfig instanceof PlatformConfiguration) {
            return this.areThereNewVersionOfOldPlugins(((PlatformConfiguration)runtimeConfig).getPlugins(), oldBundles);
        }
        return false;
    }

    private boolean areThereNewVersionOfOldPlugins(PluginEntry[] newConfigurationPlugins, Bundle[] oldConfigurationBundles) {
        int i = 0;
        while (i < oldConfigurationBundles.length) {
            if (oldConfigurationBundles[i].getBundleId() != 0L && this.getNumberOfPlugins(oldConfigurationBundles[i].getSymbolicName(), oldConfigurationBundles) != this.getNumberOfPlugins(oldConfigurationBundles[i].getSymbolicName(), newConfigurationPlugins)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int getNumberOfPlugins(String symbolicName, PluginEntry[] newConfigurationPlugins) {
        int numberOfPlugins = 0;
        int i = 0;
        while (i < newConfigurationPlugins.length) {
            if (symbolicName.equals(newConfigurationPlugins[i].getPluginIdentifier())) {
                ++numberOfPlugins;
            }
            ++i;
        }
        return numberOfPlugins;
    }

    private int getNumberOfPlugins(String symbolicName, Bundle[] oldConfigurationBundles) {
        int numberOfPlugins = 0;
        int i = 0;
        while (i < oldConfigurationBundles.length) {
            if (symbolicName.equals(oldConfigurationBundles[i].getSymbolicName())) {
                ++numberOfPlugins;
            }
            ++i;
        }
        return numberOfPlugins;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InstallConfiguration)) {
            return false;
        }
        InstallConfiguration config = (InstallConfiguration)obj;
        return this.getCreationDate().equals(config.getCreationDate()) && this.getLabel().equals(config.getLabel()) && this.getLocationURLString().equals(config.getLocationURLString());
    }
}

