/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkImage;
import org.eclipse.swt.internal.gtk.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public int pixmap;
    public int mask;
    int surface;
    int surfaceData;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image() {
    }

    public Image(Device device, int width, int height) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, width, height);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, Image srcImage, int flag) {
        int pixmap;
        int gdkGC;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        switch (flag) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.device = device;
        this.type = srcImage.type;
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gdk_drawable_get_size(srcImage.pixmap, w, h);
        int width = w[0];
        int height = h[0];
        if (srcImage.type == 1 && srcImage.mask != 0 || srcImage.transparentPixel != -1) {
            int mask;
            if (srcImage.transparentPixel != -1) {
                srcImage.createMask();
            }
            if ((mask = OS.gdk_pixmap_new(0, width, height, 1)) == 0) {
                SWT.error(2);
            }
            if ((gdkGC = OS.gdk_gc_new(mask)) == 0) {
                SWT.error(2);
            }
            OS.gdk_draw_drawable(mask, gdkGC, srcImage.mask, 0, 0, 0, 0, width, height);
            OS.g_object_unref(gdkGC);
            this.mask = mask;
            if (srcImage.transparentPixel != -1 && srcImage.memGC != null) {
                srcImage.destroyMask();
            }
        }
        if (flag != 1) {
            this.transparentPixel = srcImage.transparentPixel;
            this.alpha = srcImage.alpha;
            if (srcImage.alphaData != null) {
                this.alphaData = new byte[srcImage.alphaData.length];
                System.arraycopy(srcImage.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
        }
        if ((pixmap = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), width, height, -1)) == 0) {
            SWT.error(2);
        }
        if ((gdkGC = OS.gdk_gc_new(pixmap)) == 0) {
            SWT.error(2);
        }
        this.pixmap = pixmap;
        if (flag == 0) {
            OS.gdk_draw_drawable(pixmap, gdkGC, srcImage.pixmap, 0, 0, 0, 0, width, height);
            OS.g_object_unref(gdkGC);
            if (device.tracking) {
                device.new_Object(this);
            }
            return;
        }
        int pixbuf = OS.gdk_pixbuf_new(0, false, 8, width, height);
        if (pixbuf == 0) {
            SWT.error(2);
        }
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(pixbuf, srcImage.pixmap, colormap, 0, 0, 0, 0, width, height);
        int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
        int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
        switch (flag) {
            case 1: {
                Color zeroColor = device.getSystemColor(18);
                RGB zeroRGB = zeroColor.getRGB();
                byte zeroRed = (byte)zeroRGB.red;
                byte zeroGreen = (byte)zeroRGB.green;
                byte zeroBlue = (byte)zeroRGB.blue;
                Color oneColor = device.getSystemColor(22);
                RGB oneRGB = oneColor.getRGB();
                byte oneRed = (byte)oneRGB.red;
                byte oneGreen = (byte)oneRGB.green;
                byte oneBlue = (byte)oneRGB.blue;
                byte[] line = new byte[stride];
                int y = 0;
                while (y < height) {
                    OS.memmove(line, pixels + y * stride, stride);
                    int x = 0;
                    while (x < width) {
                        int offset = x * 3;
                        int red = line[offset] & 0xFF;
                        int green = line[offset + 1] & 0xFF;
                        int blue = line[offset + 2] & 0xFF;
                        int intensity = red * red + green * green + blue * blue;
                        if (intensity < 98304) {
                            line[offset] = zeroRed;
                            line[offset + 1] = zeroGreen;
                            line[offset + 2] = zeroBlue;
                        } else {
                            line[offset] = oneRed;
                            line[offset + 1] = oneGreen;
                            line[offset + 2] = oneBlue;
                        }
                        ++x;
                    }
                    OS.memmove(pixels + y * stride, line, stride);
                    ++y;
                }
                break;
            }
            case 2: {
                byte[] line = new byte[stride];
                int y = 0;
                while (y < height) {
                    OS.memmove(line, pixels + y * stride, stride);
                    int x = 0;
                    while (x < width) {
                        byte intensity;
                        int offset = x * 3;
                        int red = line[offset] & 0xFF;
                        int green = line[offset + 1] & 0xFF;
                        int blue = line[offset + 2] & 0xFF;
                        byte by = intensity = (byte)(red + red + green + green + green + green + green + blue >> 3);
                        line[offset + 2] = by;
                        line[offset + 1] = by;
                        line[offset] = by;
                        ++x;
                    }
                    OS.memmove(pixels + y * stride, line, stride);
                    ++y;
                }
                this.transparentPixel = srcImage.transparentPixel;
                this.alpha = srcImage.alpha;
                if (srcImage.alphaData == null) break;
                this.alphaData = new byte[srcImage.alphaData.length];
                System.arraycopy(srcImage.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
        }
        OS.gdk_pixbuf_render_to_drawable(pixbuf, pixmap, gdkGC, 0, 0, 0, 0, width, height, 1, 0, 0);
        OS.g_object_unref(pixbuf);
        OS.g_object_unref(gdkGC);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, Rectangle bounds) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (bounds == null) {
            SWT.error(4);
        }
        this.init(device, bounds.width, bounds.height);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData data) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, data);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData source, ImageData mask) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            SWT.error(4);
        }
        if (source.width != mask.width || source.height != mask.height) {
            SWT.error(5);
        }
        mask = ImageData.convertMask(mask);
        ImageData image = new ImageData(source.width, source.height, source.depth, source.palette, source.scanlinePad, source.data);
        image.maskPad = mask.scanlinePad;
        image.maskData = mask.data;
        this.init(device, image);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, InputStream stream) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, new ImageData(stream));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, String filename) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (filename == null) {
            SWT.error(4);
        }
        this.device = device;
        try {
            int length = filename.length();
            char[] chars = new char[length];
            filename.getChars(0, length, chars, 0);
            byte[] buffer = Converter.wcsToMbcs(null, chars, true);
            int pixbuf = OS.gdk_pixbuf_new_from_file(buffer, null);
            if (pixbuf != 0) {
                boolean hasAlpha;
                int[] pixmap_return = new int[1];
                OS.gdk_pixbuf_render_pixmap_and_mask(pixbuf, pixmap_return, null, 0);
                this.type = 0;
                this.pixmap = pixmap_return[0];
                if (this.pixmap == 0) {
                    SWT.error(2);
                }
                if (hasAlpha = OS.gdk_pixbuf_get_has_alpha(pixbuf)) {
                    int width = OS.gdk_pixbuf_get_width(pixbuf);
                    int height = OS.gdk_pixbuf_get_height(pixbuf);
                    int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
                    int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
                    byte[] line = new byte[stride];
                    this.alphaData = new byte[width * height];
                    int y = 0;
                    while (y < height) {
                        OS.memmove(line, pixels + y * stride, stride);
                        int x = 0;
                        while (x < width) {
                            this.alphaData[y * width + x] = line[x * 4 + 3];
                            ++x;
                        }
                        ++y;
                    }
                    if (device.useXRender) {
                        this.mask = OS.gdk_pixmap_new(0, width, height, 8);
                        if (this.mask == 0) {
                            SWT.error(2);
                        }
                        GdkImage gdkImage = new GdkImage();
                        int imagePtr = OS.gdk_drawable_get_image(this.mask, 0, 0, width, height);
                        OS.memmove(gdkImage, imagePtr);
                        if (gdkImage.bpl == width) {
                            OS.memmove(gdkImage.mem, this.alphaData, this.alphaData.length);
                        } else {
                            line = new byte[gdkImage.bpl];
                            int y2 = 0;
                            while (y2 < height) {
                                System.arraycopy(this.alphaData, width * y2, line, 0, width);
                                OS.memmove(gdkImage.mem + gdkImage.bpl * y2, line, (int)gdkImage.bpl);
                                ++y2;
                            }
                        }
                        int gc = OS.gdk_gc_new(this.mask);
                        if (gc == 0) {
                            SWT.error(2);
                        }
                        OS.gdk_draw_image(this.mask, gc, imagePtr, 0, 0, 0, 0, width, height);
                        OS.g_object_unref(imagePtr);
                        OS.g_object_unref(gc);
                    }
                }
                OS.g_object_unref(pixbuf);
                return;
            }
        }
        catch (SWTException sWTException) {}
        this.init(device, new ImageData(filename));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    void createMask() {
        if (this.mask != 0) {
            return;
        }
        this.mask = this.createMask(this.getImageData(), false);
        if (this.mask == 0) {
            SWT.error(2);
        }
    }

    int createMask(ImageData image, boolean copy) {
        ImageData mask = image.getTransparencyMask();
        byte[] data = mask.data;
        byte[] maskData = copy ? new byte[data.length] : data;
        int i = 0;
        while (i < maskData.length) {
            byte s = data[i];
            maskData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
            ++i;
        }
        maskData = ImageData.convertPad(maskData, mask.width, mask.height, mask.depth, mask.scanlinePad, 1);
        return OS.gdk_bitmap_create_from_data(0, maskData, mask.width, mask.height);
    }

    void createSurface() {
        if (this.surface != 0) {
            return;
        }
        if (this.transparentPixel != -1) {
            this.createMask();
        }
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gdk_drawable_get_size(this.pixmap, w, h);
        int width = w[0];
        int height = h[0];
        if (this.mask != 0 || this.alpha != -1 || this.alphaData != null) {
            int pixbuf = OS.gdk_pixbuf_new(0, true, 8, width, height);
            if (pixbuf == 0) {
                SWT.error(2);
            }
            int colormap = OS.gdk_colormap_get_system();
            OS.gdk_pixbuf_get_from_drawable(pixbuf, this.pixmap, colormap, 0, 0, 0, 0, width, height);
            int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
            int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
            byte[] line = new byte[stride];
            if (this.mask != 0 && OS.gdk_drawable_get_depth(this.mask) == 1) {
                int maskPixbuf = OS.gdk_pixbuf_new(0, false, 8, width, height);
                if (maskPixbuf == 0) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(maskPixbuf, this.mask, 0, 0, 0, 0, 0, width, height);
                int maskStride = OS.gdk_pixbuf_get_rowstride(maskPixbuf);
                int maskPixels = OS.gdk_pixbuf_get_pixels(maskPixbuf);
                byte[] maskLine = new byte[maskStride];
                int offset = pixels;
                int maskOffset = maskPixels;
                int y = 0;
                while (y < height) {
                    OS.memmove(line, offset, stride);
                    OS.memmove(maskLine, maskOffset, maskStride);
                    int x = 0;
                    int offset1 = 0;
                    while (x < width) {
                        if (maskLine[x * 3] == 0) {
                            line[offset1 + 3] = 0;
                        }
                        byte temp = line[offset1];
                        line[offset1] = line[offset1 + 2];
                        line[offset1 + 2] = temp;
                        ++x;
                        offset1 += 4;
                    }
                    OS.memmove(offset, line, stride);
                    offset += stride;
                    maskOffset += maskStride;
                    ++y;
                }
                OS.g_object_unref(maskPixbuf);
            } else if (this.alpha != -1) {
                int offset = pixels;
                int y = 0;
                while (y < height) {
                    OS.memmove(line, offset, stride);
                    int x = 0;
                    int offset1 = 0;
                    while (x < width) {
                        line[offset1 + 3] = (byte)this.alpha;
                        int r = (line[offset1 + 0] & 0xFF) * this.alpha + 128;
                        r = r + (r >> 8) >> 8;
                        int g = (line[offset1 + 1] & 0xFF) * this.alpha + 128;
                        g = g + (g >> 8) >> 8;
                        int b = (line[offset1 + 2] & 0xFF) * this.alpha + 128;
                        b = b + (b >> 8) >> 8;
                        line[offset1 + 0] = (byte)b;
                        line[offset1 + 1] = (byte)g;
                        line[offset1 + 2] = (byte)r;
                        ++x;
                        offset1 += 4;
                    }
                    OS.memmove(offset, line, stride);
                    offset += stride;
                    ++y;
                }
            } else if (this.alphaData != null) {
                int offset = pixels;
                int y = 0;
                while (y < h[0]) {
                    OS.memmove(line, offset, stride);
                    int x = 0;
                    int offset1 = 0;
                    while (x < width) {
                        int alpha = this.alphaData[y * w[0] + x] & 0xFF;
                        line[offset1 + 3] = (byte)alpha;
                        int r = (line[offset1 + 0] & 0xFF) * alpha + 128;
                        r = r + (r >> 8) >> 8;
                        int g = (line[offset1 + 1] & 0xFF) * alpha + 128;
                        g = g + (g >> 8) >> 8;
                        int b = (line[offset1 + 2] & 0xFF) * alpha + 128;
                        b = b + (b >> 8) >> 8;
                        line[offset1 + 0] = (byte)b;
                        line[offset1 + 1] = (byte)g;
                        line[offset1 + 2] = (byte)r;
                        ++x;
                        offset1 += 4;
                    }
                    OS.memmove(offset, line, stride);
                    offset += stride;
                    ++y;
                }
            } else {
                int offset = pixels;
                int y = 0;
                while (y < h[0]) {
                    OS.memmove(line, offset, stride);
                    int x = 0;
                    int offset1 = 0;
                    while (x < width) {
                        line[offset1 + 3] = -1;
                        byte temp = line[offset1];
                        line[offset1] = line[offset1 + 2];
                        line[offset1 + 2] = temp;
                        ++x;
                        offset1 += 4;
                    }
                    OS.memmove(offset, line, stride);
                    offset += stride;
                    ++y;
                }
            }
            this.surfaceData = OS.g_malloc(stride * height);
            OS.memmove(this.surfaceData, pixels, stride * height);
            this.surface = Cairo.cairo_image_surface_create_for_data(this.surfaceData, 0, width, height, stride);
            OS.g_object_unref(pixbuf);
        } else {
            int xDisplay = OS.GDK_DISPLAY();
            int xDrawable = OS.GDK_PIXMAP_XID(this.pixmap);
            int xVisual = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
            this.surface = Cairo.cairo_xlib_surface_create(xDisplay, xDrawable, xVisual, width, height);
        }
        if (this.transparentPixel != -1 && this.memGC != null) {
            this.destroyMask();
        }
    }

    void destroyMask() {
        if (this.mask == 0) {
            return;
        }
        OS.g_object_unref(this.mask);
        this.mask = 0;
    }

    public void dispose() {
        if (this.pixmap == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.pixmap != 0) {
            OS.g_object_unref(this.pixmap);
        }
        if (this.mask != 0) {
            OS.g_object_unref(this.mask);
        }
        if (this.surface != 0) {
            Cairo.cairo_surface_destroy(this.surface);
        }
        if (this.surfaceData != 0) {
            OS.g_free(this.surfaceData);
        }
        this.mask = 0;
        this.pixmap = 0;
        this.surface = 0;
        this.surfaceData = 0;
        this.memGC = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.pixmap == image.pixmap;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        return null;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gdk_drawable_get_size(this.pixmap, w, h);
        this.width = w[0];
        this.height = h[0];
        return new Rectangle(0, 0, this.width, this.height);
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gdk_drawable_get_size(this.pixmap, w, h);
        int width = w[0];
        int height = h[0];
        int pixbuf = OS.gdk_pixbuf_new(0, false, 8, width, height);
        if (pixbuf == 0) {
            SWT.error(2);
        }
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_pixbuf_get_from_drawable(pixbuf, this.pixmap, colormap, 0, 0, 0, 0, width, height);
        int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
        int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
        byte[] srcData = new byte[stride * height];
        OS.memmove(srcData, pixels, srcData.length);
        OS.g_object_unref(pixbuf);
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        ImageData data = new ImageData(width, height, 24, palette);
        data.data = srcData;
        data.bytesPerLine = stride;
        if (this.transparentPixel == -1 && this.type == 1 && this.mask != 0) {
            int gdkImagePtr = OS.gdk_drawable_get_image(this.mask, 0, 0, width, height);
            if (gdkImagePtr == 0) {
                SWT.error(2);
            }
            GdkImage gdkImage = new GdkImage();
            OS.memmove(gdkImage, gdkImagePtr);
            byte[] maskData = new byte[gdkImage.bpl * gdkImage.height];
            OS.memmove(maskData, gdkImage.mem, maskData.length);
            OS.g_object_unref(gdkImagePtr);
            int maskPad = 1;
            while (maskPad < 128) {
                int bpl = ((width + 7) / 8 + (maskPad - 1)) / maskPad * maskPad;
                if (gdkImage.bpl == bpl) break;
                ++maskPad;
            }
            data.maskPad = 2;
            maskData = ImageData.convertPad(maskData, width, height, 1, maskPad, data.maskPad);
            if (gdkImage.byte_order == 0) {
                int i = 0;
                while (i < maskData.length) {
                    byte b = maskData[i];
                    maskData[i] = (byte)((b & 1) << 7 | (b & 2) << 5 | (b & 4) << 3 | (b & 8) << 1 | (b & 0x10) >> 1 | (b & 0x20) >> 3 | (b & 0x40) >> 5 | (b & 0x80) >> 7);
                    ++i;
                }
            }
            data.maskData = maskData;
        }
        data.transparentPixel = this.transparentPixel;
        data.alpha = this.alpha;
        if (this.alpha == -1 && this.alphaData != null) {
            data.alphaData = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, data.alphaData, 0, this.alphaData.length);
        }
        return data;
    }

    public static Image gtk_new(Device device, int type, int pixmap, int mask) {
        if (device == null) {
            device = Device.getDevice();
        }
        Image image = new Image();
        image.type = type;
        image.pixmap = pixmap;
        image.mask = mask;
        image.device = device;
        return image;
    }

    public int hashCode() {
        return this.pixmap;
    }

    void init(Device device, int width, int height) {
        if (width <= 0 || height <= 0) {
            SWT.error(5);
        }
        this.device = device;
        this.type = 0;
        this.pixmap = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), width, height, -1);
        if (this.pixmap == 0) {
            SWT.error(2);
        }
        GdkColor white = new GdkColor();
        white.red = (short)-1;
        white.green = (short)-1;
        white.blue = (short)-1;
        int colormap = OS.gdk_colormap_get_system();
        OS.gdk_colormap_alloc_color(colormap, white, true, true);
        int gdkGC = OS.gdk_gc_new(this.pixmap);
        OS.gdk_gc_set_foreground(gdkGC, white);
        OS.gdk_draw_rectangle(this.pixmap, gdkGC, 1, 0, 0, width, height);
        OS.g_object_unref(gdkGC);
        OS.gdk_colormap_free_colors(colormap, white, 1);
    }

    void init(Device device, ImageData image) {
        boolean isIcon;
        int gdkGC;
        int pixbuf;
        if (image == null) {
            SWT.error(4);
        }
        this.device = device;
        int width = image.width;
        int height = image.height;
        PaletteData palette = image.palette;
        if ((image.depth != 1 && image.depth != 2 && image.depth != 4 && image.depth != 8 || palette.isDirect) && image.depth != 8 && (image.depth != 16 && image.depth != 24 && image.depth != 32 || !palette.isDirect)) {
            SWT.error(38);
        }
        if ((pixbuf = OS.gdk_pixbuf_new(0, false, 8, width, height)) == 0) {
            SWT.error(2);
        }
        int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
        int data = OS.gdk_pixbuf_get_pixels(pixbuf);
        byte[] buffer = image.data;
        if (!palette.isDirect || image.depth != 24 || stride != image.bytesPerLine || palette.redMask != 0xFF0000 || palette.greenMask != 65280 || palette.blueMask != 255) {
            buffer = new byte[stride * height];
            if (palette.isDirect) {
                ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), 0, 0, width, height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, buffer, 24, stride, 1, 0, 0, width, height, 0xFF0000, 65280, 255, false, false);
            } else {
                RGB[] rgbs = palette.getRGBs();
                int length = rgbs.length;
                byte[] srcReds = new byte[length];
                byte[] srcGreens = new byte[length];
                byte[] srcBlues = new byte[length];
                int i = 0;
                while (i < rgbs.length) {
                    RGB rgb = rgbs[i];
                    if (rgb != null) {
                        srcReds[i] = (byte)rgb.red;
                        srcGreens[i] = (byte)rgb.green;
                        srcBlues[i] = (byte)rgb.blue;
                    }
                    ++i;
                }
                ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), 0, 0, width, height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, buffer, 24, stride, 1, 0, 0, width, height, 0xFF0000, 65280, 255, false, false);
            }
        }
        OS.memmove(data, buffer, stride * height);
        int pixmap = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), width, height, -1);
        if (pixmap == 0) {
            SWT.error(2);
        }
        if ((gdkGC = OS.gdk_gc_new(pixmap)) == 0) {
            SWT.error(2);
        }
        OS.gdk_pixbuf_render_to_drawable(pixbuf, pixmap, gdkGC, 0, 0, 0, 0, width, height, 1, 0, 0);
        OS.g_object_unref(gdkGC);
        OS.g_object_unref(pixbuf);
        boolean bl = isIcon = image.getTransparencyType() == 2;
        if (isIcon || image.transparentPixel != -1) {
            int mask;
            if (image.transparentPixel != -1) {
                RGB rgb = null;
                if (palette.isDirect) {
                    rgb = palette.getRGB(image.transparentPixel);
                } else if (image.transparentPixel < palette.colors.length) {
                    rgb = palette.getRGB(image.transparentPixel);
                }
                if (rgb != null) {
                    this.transparentPixel = rgb.red << 16 | rgb.green << 8 | rgb.blue;
                }
            }
            if ((mask = this.createMask(image, isIcon)) == 0) {
                SWT.error(2);
            }
            this.mask = mask;
            this.type = isIcon ? 1 : 0;
        } else {
            this.type = 0;
            this.mask = 0;
            this.alpha = image.alpha;
            if (image.alpha == -1 && image.alphaData != null) {
                this.alphaData = new byte[image.alphaData.length];
                System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
            if (device.useXRender && (this.alpha != -1 || this.alphaData != null)) {
                this.mask = OS.gdk_pixmap_new(0, this.alpha != -1 ? 1 : width, this.alpha != -1 ? 1 : height, 8);
                if (this.mask == 0) {
                    SWT.error(2);
                }
                int gc = OS.gdk_gc_new(this.mask);
                if (this.alpha != -1) {
                    GdkColor color = new GdkColor();
                    color.pixel = (this.alpha & 0xFF) << 8 | this.alpha & 0xFF;
                    OS.gdk_gc_set_foreground(gc, color);
                    OS.gdk_draw_rectangle(this.mask, gc, 1, 0, 0, 1, 1);
                } else {
                    int imagePtr = OS.gdk_drawable_get_image(this.mask, 0, 0, width, height);
                    GdkImage gdkImage = new GdkImage();
                    OS.memmove(gdkImage, imagePtr);
                    if (gdkImage.bpl == width) {
                        OS.memmove(gdkImage.mem, this.alphaData, this.alphaData.length);
                    } else {
                        byte[] line = new byte[gdkImage.bpl];
                        int y = 0;
                        while (y < height) {
                            System.arraycopy(this.alphaData, width * y, line, 0, width);
                            OS.memmove(gdkImage.mem + gdkImage.bpl * y, line, (int)gdkImage.bpl);
                            ++y;
                        }
                    }
                    OS.gdk_draw_image(this.mask, gc, imagePtr, 0, 0, 0, 0, width, height);
                    OS.g_object_unref(imagePtr);
                }
                OS.g_object_unref(gc);
            }
        }
        this.pixmap = pixmap;
    }

    public int internal_new_GC(GCData data) {
        if (this.pixmap == 0) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        int gdkGC = OS.gdk_gc_new(this.pixmap);
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this.device;
            data.drawable = this.pixmap;
            data.background = this.device.COLOR_WHITE.handle;
            data.foreground = this.device.COLOR_BLACK.handle;
            data.font = this.device.systemFont.handle;
            data.image = this;
        }
        return gdkGC;
    }

    public void internal_dispose_GC(int gdkGC, GCData data) {
        OS.g_object_unref(gdkGC);
    }

    public boolean isDisposed() {
        return this.pixmap == 0;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.pixmap + "}";
    }
}

