/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.properties.tabbed.internal.view;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.tabbed.ITabItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.ui.views.properties.tabbed.internal.l10n.TabbedPropertyMessages;
import org.eclipse.ui.views.properties.tabbed.internal.view.TabbedPropertyComposite;

public class TabbedPropertyList
extends Composite {
    private static final ListElement[] ELEMENTS_EMPTY = new ListElement[0];
    protected static final int NONE = -1;
    protected static final int INDENT = 7;
    private boolean focus = false;
    private ListElement[] elements;
    private int selectedElementIndex = -1;
    private int topVisibleIndex = -1;
    private int bottomVisibleIndex = -1;
    private TopNavigationElement topNavigationElement;
    private BottomNavigationElement bottomNavigationElement;
    private int widestLabelIndex = -1;
    private int tabsThatFitInComposite = -1;
    private Color hoverBackground;
    private Color defaultBackground;
    private Color defaultForeground;
    private Color activeBackground;
    private Color border;
    private Color darkShadow;
    private Color textColor;
    private TabbedPropertySheetWidgetFactory factory;

    public TabbedPropertyList(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super(parent, 524288);
        this.factory = factory;
        this.removeAll();
        this.setLayout((Layout)new FormLayout());
        this.initColours();
        this.initAccessible();
        this.topNavigationElement = new TopNavigationElement(this);
        this.bottomNavigationElement = new BottomNavigationElement(this);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TabbedPropertyList.this.focus = true;
                int i = TabbedPropertyList.this.getSelectionIndex();
                if (i >= 0) {
                    TabbedPropertyList.this.elements[i].redraw();
                }
            }

            public void focusLost(FocusEvent e) {
                TabbedPropertyList.this.focus = false;
                int i = TabbedPropertyList.this.getSelectionIndex();
                if (i >= 0) {
                    TabbedPropertyList.this.elements[i].redraw();
                }
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TabbedPropertyList.this.computeTopAndBottomTab();
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 32 || e.detail == 64) {
                    int nMax = TabbedPropertyList.this.elements.length - 1;
                    int nCurrent = TabbedPropertyList.this.getSelectionIndex();
                    if (e.detail == 32) {
                        --nCurrent;
                        nCurrent = Math.max(0, nCurrent);
                    } else if (e.detail == 64) {
                        ++nCurrent;
                        nCurrent = Math.min(nCurrent, nMax);
                    }
                    TabbedPropertyList.this.select(nCurrent, true);
                    TabbedPropertyList.this.redraw();
                } else {
                    e.doit = true;
                }
            }
        });
    }

    protected void computeTabsThatFitInComposite() {
        this.tabsThatFitInComposite = Math.round((this.getSize().y - 22) / this.getTabHeight());
        if (this.tabsThatFitInComposite <= 0) {
            this.tabsThatFitInComposite = 1;
        }
    }

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.elements.length) {
            return this.elements[index];
        }
        return null;
    }

    public int getSelectionIndex() {
        return this.selectedElementIndex;
    }

    public void removeAll() {
        if (this.elements != null) {
            int i = 0;
            while (i < this.elements.length) {
                this.elements[i].dispose();
                ++i;
            }
        }
        this.elements = ELEMENTS_EMPTY;
        this.selectedElementIndex = -1;
        this.widestLabelIndex = -1;
        this.topVisibleIndex = -1;
        this.bottomVisibleIndex = -1;
    }

    public void setElements(Object[] children) {
        if (this.elements != ELEMENTS_EMPTY) {
            this.removeAll();
        }
        this.elements = new ListElement[children.length];
        if (children.length == 0) {
            this.widestLabelIndex = -1;
        } else {
            this.widestLabelIndex = 0;
            int i = 0;
            while (i < children.length) {
                this.elements[i] = new ListElement(this, (ITabItem)children[i], i);
                this.elements[i].setVisible(false);
                this.elements[i].setLayoutData(null);
                if (i != this.widestLabelIndex) {
                    String label = ((ITabItem)children[i]).getText();
                    if (this.getTextDimension((String)label).x > this.getTextDimension((String)((ITabItem)children[this.widestLabelIndex]).getText()).x) {
                        this.widestLabelIndex = i;
                    }
                }
                ++i;
            }
        }
        this.computeTopAndBottomTab();
    }

    public void select(int index, boolean reveal) {
        if (this.getSelectionIndex() == index) {
            return;
        }
        if (index >= 0 && index < this.elements.length) {
            int lastSelected = this.getSelectionIndex();
            this.elements[index].setSelected(true);
            this.selectedElementIndex = index;
            if (lastSelected != -1) {
                this.elements[lastSelected].setSelected(false);
                if (this.getSelectionIndex() != this.elements.length - 1) {
                    this.elements[this.getSelectionIndex() + 1].setSelected(false);
                }
            }
            this.topNavigationElement.redraw();
            this.bottomNavigationElement.redraw();
            if (this.selectedElementIndex < this.topVisibleIndex || this.selectedElementIndex > this.bottomVisibleIndex) {
                this.computeTopAndBottomTab();
            }
        }
        this.notifyListeners(13, new Event());
    }

    public void deselectAll() {
        if (this.getSelectionIndex() != -1) {
            this.elements[this.getSelectionIndex()].setSelected(false);
            this.selectedElementIndex = -1;
        }
    }

    private int getIndex(ListElement element) {
        return element.index;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point result = super.computeSize(hHint, wHint, changed);
        if (this.widestLabelIndex == -1) {
            String properties_not_available = TabbedPropertyMessages.TabbedPropertyList_properties_not_available;
            result.x = this.getTextDimension((String)properties_not_available).x + 7;
        } else {
            int width = this.getTextDimension((String)this.elements[this.widestLabelIndex].getText()).x;
            result.x = width + 32;
        }
        return result;
    }

    private Point getTextDimension(String text) {
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(this.getFont());
        Point point = gc.textExtent(text);
        ++point.x;
        gc.dispose();
        shell.dispose();
        return point;
    }

    private void initColours() {
        this.defaultBackground = Display.getCurrent().getSystemColor(22);
        RGB rgb = this.defaultBackground.getRGB();
        rgb.blue = Math.min(255, Math.round((float)rgb.blue * 1.05f));
        rgb.red = Math.min(255, Math.round((float)rgb.red * 1.05f));
        rgb.green = Math.min(255, Math.round((float)rgb.green * 1.05f));
        this.hoverBackground = this.factory.getColors().createColor("TabbedPropertyList.hoverBackground", rgb);
        this.defaultForeground = Display.getCurrent().getSystemColor(21);
        this.activeBackground = Display.getCurrent().getSystemColor(25);
        this.border = Display.getCurrent().getSystemColor(18);
        this.darkShadow = Display.getCurrent().getSystemColor(17);
        this.textColor = Display.getCurrent().getSystemColor(21);
    }

    public void dispose() {
        this.hoverBackground.dispose();
        this.defaultBackground.dispose();
        this.defaultForeground.dispose();
        this.activeBackground.dispose();
        this.border.dispose();
        this.darkShadow.dispose();
        this.textColor.dispose();
        super.dispose();
    }

    private int getTabHeight() {
        int tabHeight = this.getTextDimension((String)"").y + 7;
        if (this.tabsThatFitInComposite == 1) {
            int ret = this.getBounds().height - 20;
            return ret > tabHeight ? tabHeight : (ret < 5 ? 5 : ret);
        }
        return tabHeight;
    }

    private boolean isDownScrollRequired() {
        return this.elements.length > this.tabsThatFitInComposite && this.bottomVisibleIndex != this.elements.length - 1;
    }

    private boolean isUpScrollRequired() {
        return this.elements.length > this.tabsThatFitInComposite && this.topVisibleIndex != 0;
    }

    private void computeTopAndBottomTab() {
        this.computeTabsThatFitInComposite();
        if (this.elements.length == 0) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = 0;
        } else if (this.tabsThatFitInComposite >= this.elements.length) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = this.elements.length - 1;
        } else if (this.getSelectionIndex() == -1) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = this.tabsThatFitInComposite - 1;
        } else if (this.getSelectionIndex() + this.tabsThatFitInComposite > this.elements.length) {
            this.bottomVisibleIndex = this.elements.length - 1;
            this.topVisibleIndex = this.bottomVisibleIndex - this.tabsThatFitInComposite + 1;
        } else {
            this.topVisibleIndex = this.selectedElementIndex;
            this.bottomVisibleIndex = this.selectedElementIndex + this.tabsThatFitInComposite - 1;
        }
        this.layoutTabs();
    }

    private void layoutTabs() {
        FormData formData;
        if (this.tabsThatFitInComposite == -1 || this.elements.length == 0) {
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.height = this.getTabHeight();
            this.topNavigationElement.setLayoutData(formData);
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)this.topNavigationElement, 0);
            formData.bottom = new FormAttachment(100, 0);
            this.bottomNavigationElement.setLayoutData(formData);
        } else {
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.height = 10;
            this.topNavigationElement.setLayoutData(formData);
            Canvas nextElement = this.topNavigationElement;
            int i = 0;
            while (i < this.elements.length) {
                if (i < this.topVisibleIndex || i > this.bottomVisibleIndex) {
                    this.elements[i].setLayoutData(null);
                    this.elements[i].setVisible(false);
                } else {
                    formData = new FormData();
                    formData.height = this.getTabHeight();
                    formData.left = new FormAttachment(0, 0);
                    formData.right = new FormAttachment(100, 0);
                    formData.top = new FormAttachment((Control)nextElement, 0);
                    nextElement = this.elements[i];
                    this.elements[i].setLayoutData(formData);
                    this.elements[i].setVisible(true);
                }
                ++i;
            }
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)nextElement, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.height = 10;
            this.bottomNavigationElement.setLayoutData(formData);
        }
        Composite grandparent = this.getParent().getParent();
        grandparent.layout(true);
        this.layout(true);
    }

    private void initAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (TabbedPropertyList.this.getSelectionIndex() != -1) {
                    e.result = TabbedPropertyList.this.elements[TabbedPropertyList.this.getSelectionIndex()].getText();
                }
            }

            public void getHelp(AccessibleEvent e) {
                if (TabbedPropertyList.this.getSelectionIndex() != -1) {
                    e.result = TabbedPropertyList.this.elements[TabbedPropertyList.this.getSelectionIndex()].getText();
                }
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = TabbedPropertyList.this.toControl(new Point(e.x, e.y));
                e.childID = TabbedPropertyList.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                if (TabbedPropertyList.this.getSelectionIndex() != -1) {
                    Rectangle location = TabbedPropertyList.this.elements[TabbedPropertyList.this.getSelectionIndex()].getBounds();
                    Point pt = TabbedPropertyList.this.toDisplay(new Point(location.x, location.y));
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = location.width;
                    e.height = location.height;
                }
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 37;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x300006;
            }
        });
        this.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TabbedPropertyList.this.isFocusControl()) {
                    accessible.setFocus(-1);
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                accessible.setFocus(-1);
            }
        });
    }

    static /* synthetic */ int access$0(TabbedPropertyList tabbedPropertyList, ListElement listElement) {
        return tabbedPropertyList.getIndex(listElement);
    }

    static /* synthetic */ int access$9(TabbedPropertyList tabbedPropertyList) {
        return tabbedPropertyList.bottomVisibleIndex;
    }

    static /* synthetic */ void access$10(TabbedPropertyList tabbedPropertyList, int n) {
        tabbedPropertyList.bottomVisibleIndex = n;
    }

    static /* synthetic */ int access$11(TabbedPropertyList tabbedPropertyList) {
        return tabbedPropertyList.topVisibleIndex;
    }

    static /* synthetic */ void access$12(TabbedPropertyList tabbedPropertyList, int n) {
        tabbedPropertyList.topVisibleIndex = n;
    }

    static /* synthetic */ void access$13(TabbedPropertyList tabbedPropertyList) {
        tabbedPropertyList.layoutTabs();
    }

    static /* synthetic */ TopNavigationElement access$14(TabbedPropertyList tabbedPropertyList) {
        return tabbedPropertyList.topNavigationElement;
    }

    static /* synthetic */ BottomNavigationElement access$15(TabbedPropertyList tabbedPropertyList) {
        return tabbedPropertyList.bottomNavigationElement;
    }

    public class ListElement
    extends Canvas {
        private ITabItem tab;
        private int index;
        private boolean selected;
        private boolean hover;

        public ListElement(Composite parent, ITabItem tab, int index) {
            super(parent, 524288);
            this.tab = tab;
            this.hover = false;
            this.selected = false;
            this.index = index;
            this.addPaintListener(new PaintListener(this){
                final /* synthetic */ ListElement this$1;
                {
                    this.this$1 = listElement;
                }

                public void paintControl(PaintEvent e) {
                    ListElement.access$0(this.this$1, e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ ListElement this$1;
                {
                    this.this$1 = listElement;
                }

                public void mouseUp(MouseEvent e) {
                    if (!ListElement.access$1(this.this$1)) {
                        ListElement.access$5(this.this$1).select(TabbedPropertyList.access$0(ListElement.access$5(this.this$1), this.this$1), true);
                        Composite tabbedPropertyComposite = this.this$1.getParent();
                        while (!(tabbedPropertyComposite instanceof TabbedPropertyComposite)) {
                            tabbedPropertyComposite = tabbedPropertyComposite.getParent();
                        }
                        tabbedPropertyComposite.setFocus();
                    }
                }
            });
            this.addMouseMoveListener(new MouseMoveListener(this){
                final /* synthetic */ ListElement this$1;
                {
                    this.this$1 = listElement;
                }

                public void mouseMove(MouseEvent e) {
                    if (!ListElement.access$2(this.this$1)) {
                        ListElement.access$3(this.this$1, true);
                        this.this$1.redraw();
                    }
                }
            });
            this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(this){
                final /* synthetic */ ListElement this$1;
                {
                    this.this$1 = listElement;
                }

                public void mouseExit(MouseEvent e) {
                    ListElement.access$3(this.this$1, false);
                    this.this$1.redraw();
                }
            });
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            this.redraw();
        }

        private void paint(PaintEvent e) {
            e.gc.setBackground(TabbedPropertyList.this.defaultBackground);
            e.gc.setForeground(TabbedPropertyList.this.defaultForeground);
            Rectangle bounds = this.getBounds();
            e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
            if (this.selected) {
                e.gc.setBackground(TabbedPropertyList.this.activeBackground);
            } else if (this.hover) {
                e.gc.setBackground(TabbedPropertyList.this.hoverBackground);
            } else {
                e.gc.setBackground(TabbedPropertyList.this.defaultBackground);
            }
            if (this.selected) {
                e.gc.fillRectangle(4, 0, bounds.width, bounds.height);
                e.gc.fillRectangle(3, 1, 3, bounds.height);
            } else if (this.hover) {
                e.gc.fillRectangle(2, 0, bounds.width - 4, bounds.height);
            }
            if (this.selected) {
                e.gc.setForeground(TabbedPropertyList.this.border);
                e.gc.drawLine(4, 0, bounds.width - 1, 0);
                e.gc.drawPoint(3, 1);
                e.gc.drawPoint(3, bounds.height - 1);
                e.gc.drawLine(2, 2, 2, bounds.height - 2);
            } else {
                e.gc.setForeground(TabbedPropertyList.this.border);
                if (TabbedPropertyList.this.getSelectionIndex() != -1 && TabbedPropertyList.this.getSelectionIndex() + 1 == this.index) {
                    e.gc.drawLine(4, 0, bounds.width - 1, 0);
                } else {
                    e.gc.drawLine(2, 0, bounds.width - 3, 0);
                }
                e.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
            }
            int textIndent = 7;
            FontMetrics fm = e.gc.getFontMetrics();
            int height = fm.getHeight();
            int textMiddle = (bounds.height - height) / 2;
            if (this.selected && this.tab.getImage() != null && !this.tab.getImage().isDisposed()) {
                e.gc.drawImage(this.tab.getImage(), textIndent - 2, textMiddle);
                textIndent = textIndent + 16 + 2;
            } else if (this.tab.isIndented()) {
                e.gc.drawRectangle(20, textMiddle + 6, 1, 1);
                textIndent = textIndent + 16 + 4;
            }
            e.gc.setForeground(TabbedPropertyList.this.textColor);
            e.gc.drawText(this.tab.getText(), textIndent, textMiddle);
            if (((TabbedPropertyList)this.getParent()).focus && this.selected) {
                Point point = e.gc.textExtent(this.tab.getText());
                e.gc.drawLine(textIndent, bounds.height - 4, textIndent + point.x, bounds.height - 4);
            }
        }

        public String getText() {
            return this.tab.getText();
        }

        public String toString() {
            return this.tab.getText();
        }

        static /* synthetic */ void access$0(ListElement listElement, PaintEvent paintEvent) {
            listElement.paint(paintEvent);
        }

        static /* synthetic */ boolean access$1(ListElement listElement) {
            return listElement.selected;
        }

        static /* synthetic */ boolean access$2(ListElement listElement) {
            return listElement.hover;
        }

        static /* synthetic */ void access$3(ListElement listElement, boolean bl) {
            listElement.hover = bl;
        }

        static /* synthetic */ TabbedPropertyList access$5(ListElement listElement) {
            return listElement.TabbedPropertyList.this;
        }
    }

    public class TopNavigationElement
    extends Canvas {
        public TopNavigationElement(Composite parent) {
            super(parent, 524288);
            this.addPaintListener(new PaintListener(this){
                final /* synthetic */ TopNavigationElement this$1;
                {
                    this.this$1 = topNavigationElement;
                }

                public void paintControl(PaintEvent e) {
                    TopNavigationElement.access$0(this.this$1, e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ TopNavigationElement this$1;
                {
                    this.this$1 = topNavigationElement;
                }

                public void mouseUp(MouseEvent e) {
                    if (TabbedPropertyList.access$8(TopNavigationElement.access$1(this.this$1))) {
                        TabbedPropertyList tabbedPropertyList = TopNavigationElement.access$1(this.this$1);
                        TabbedPropertyList.access$10(tabbedPropertyList, TabbedPropertyList.access$9(tabbedPropertyList) - 1);
                        if (TabbedPropertyList.access$11(TopNavigationElement.access$1(this.this$1)) != 0) {
                            TabbedPropertyList tabbedPropertyList2 = TopNavigationElement.access$1(this.this$1);
                            TabbedPropertyList.access$12(tabbedPropertyList2, TabbedPropertyList.access$11(tabbedPropertyList2) - 1);
                        }
                        TabbedPropertyList.access$13(TopNavigationElement.access$1(this.this$1));
                        TabbedPropertyList.access$14(TopNavigationElement.access$1(this.this$1)).redraw();
                        TabbedPropertyList.access$15(TopNavigationElement.access$1(this.this$1)).redraw();
                    }
                }
            });
        }

        private void paint(PaintEvent e) {
            e.gc.setBackground(TabbedPropertyList.this.defaultBackground);
            e.gc.setForeground(TabbedPropertyList.this.defaultForeground);
            Rectangle bounds = this.getBounds();
            if (TabbedPropertyList.this.elements.length != 0) {
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                e.gc.setForeground(TabbedPropertyList.this.border);
                e.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
            } else {
                e.gc.setBackground(TabbedPropertyList.this.activeBackground);
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                int textIndent = 7;
                FontMetrics fm = e.gc.getFontMetrics();
                int height = fm.getHeight();
                int textMiddle = (bounds.height - height) / 2;
                e.gc.setForeground(TabbedPropertyList.this.textColor);
                String properties_not_available = TabbedPropertyMessages.TabbedPropertyList_properties_not_available;
                e.gc.drawText(properties_not_available, textIndent, textMiddle);
            }
            if (TabbedPropertyList.this.isUpScrollRequired()) {
                e.gc.setForeground(TabbedPropertyList.this.darkShadow);
                int middle = bounds.width / 2;
                e.gc.drawLine(middle + 1, 3, middle + 5, 7);
                e.gc.drawLine(middle, 3, middle - 4, 7);
                e.gc.drawLine(middle - 4, 8, middle + 5, 8);
                e.gc.setForeground(TabbedPropertyList.this.activeBackground);
                e.gc.drawLine(middle, 4, middle + 1, 4);
                e.gc.drawLine(middle - 1, 5, middle + 2, 5);
                e.gc.drawLine(middle - 2, 6, middle + 3, 6);
                e.gc.drawLine(middle - 3, 7, middle + 4, 7);
            }
        }

        static /* synthetic */ void access$0(TopNavigationElement topNavigationElement, PaintEvent paintEvent) {
            topNavigationElement.paint(paintEvent);
        }

        static /* synthetic */ TabbedPropertyList access$1(TopNavigationElement topNavigationElement) {
            return topNavigationElement.TabbedPropertyList.this;
        }
    }

    public class BottomNavigationElement
    extends Canvas {
        public BottomNavigationElement(Composite parent) {
            super(parent, 524288);
            this.addPaintListener(new PaintListener(this){
                final /* synthetic */ BottomNavigationElement this$1;
                {
                    this.this$1 = bottomNavigationElement;
                }

                public void paintControl(PaintEvent e) {
                    BottomNavigationElement.access$0(this.this$1, e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ BottomNavigationElement this$1;
                {
                    this.this$1 = bottomNavigationElement;
                }

                public void mouseUp(MouseEvent e) {
                    if (TabbedPropertyList.access$18(BottomNavigationElement.access$1(this.this$1))) {
                        TabbedPropertyList tabbedPropertyList = BottomNavigationElement.access$1(this.this$1);
                        TabbedPropertyList.access$12(tabbedPropertyList, TabbedPropertyList.access$11(tabbedPropertyList) + 1);
                        if (TabbedPropertyList.access$9(BottomNavigationElement.access$1(this.this$1)) != TabbedPropertyList.access$16(BottomNavigationElement.access$1(this.this$1)).length - 1) {
                            TabbedPropertyList tabbedPropertyList2 = BottomNavigationElement.access$1(this.this$1);
                            TabbedPropertyList.access$10(tabbedPropertyList2, TabbedPropertyList.access$9(tabbedPropertyList2) + 1);
                        }
                        TabbedPropertyList.access$13(BottomNavigationElement.access$1(this.this$1));
                        TabbedPropertyList.access$14(BottomNavigationElement.access$1(this.this$1)).redraw();
                        TabbedPropertyList.access$15(BottomNavigationElement.access$1(this.this$1)).redraw();
                    }
                }
            });
        }

        private void paint(PaintEvent e) {
            e.gc.setBackground(TabbedPropertyList.this.defaultBackground);
            e.gc.setForeground(TabbedPropertyList.this.defaultForeground);
            Rectangle bounds = this.getBounds();
            if (TabbedPropertyList.this.elements.length != 0) {
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                e.gc.setForeground(TabbedPropertyList.this.border);
                e.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
                if (TabbedPropertyList.this.getSelectionIndex() != -1 && TabbedPropertyList.this.elements.length != 0 && TabbedPropertyList.this.getSelectionIndex() == TabbedPropertyList.this.elements.length - 1) {
                    e.gc.drawLine(4, 0, bounds.width - 1, 0);
                } else {
                    e.gc.drawLine(2, 0, bounds.width - 1, 0);
                }
            } else {
                e.gc.setBackground(TabbedPropertyList.this.activeBackground);
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
            }
            if (TabbedPropertyList.this.isDownScrollRequired()) {
                e.gc.setForeground(TabbedPropertyList.this.darkShadow);
                int middle = bounds.width / 2;
                int bottom = bounds.height - 2;
                e.gc.drawLine(middle + 1, bottom, middle + 5, bottom - 4);
                e.gc.drawLine(middle, bottom, middle - 4, bottom - 4);
                e.gc.drawLine(middle - 4, bottom - 5, middle + 5, bottom - 5);
                e.gc.setForeground(TabbedPropertyList.this.activeBackground);
                e.gc.drawLine(middle, bottom - 1, middle + 1, bottom - 1);
                e.gc.drawLine(middle - 1, bottom - 2, middle + 2, bottom - 2);
                e.gc.drawLine(middle - 2, bottom - 3, middle + 3, bottom - 3);
                e.gc.drawLine(middle - 3, bottom - 4, middle + 4, bottom - 4);
            }
        }

        static /* synthetic */ void access$0(BottomNavigationElement bottomNavigationElement, PaintEvent paintEvent) {
            bottomNavigationElement.paint(paintEvent);
        }

        static /* synthetic */ TabbedPropertyList access$1(BottomNavigationElement bottomNavigationElement) {
            return bottomNavigationElement.TabbedPropertyList.this;
        }
    }
}

