/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import org.eclipse.jdt.internal.junit.model.TestRoot;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jface.util.Assert;

public abstract class TestElement {
    private final TestSuiteElement fParent;
    private final String fId;
    private final String fTestName;

    public TestElement(TestSuiteElement parent, String id, String testName) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)testName);
        this.fParent = parent;
        this.fId = id;
        this.fTestName = testName;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public TestSuiteElement getParent() {
        return this.fParent;
    }

    public String getId() {
        return this.fId;
    }

    public String getTestName() {
        return this.fTestName;
    }

    public String getClassName() {
        return this.extractClassName(this.getTestName());
    }

    private String extractClassName(String testNameString) {
        int index = testNameString.indexOf(40);
        if (index < 0) {
            return testNameString;
        }
        testNameString = testNameString.substring(index + 1);
        return testNameString.substring(0, testNameString.indexOf(41));
    }

    public abstract Status getStatus();

    public TestRoot getRoot() {
        return this.getParent().getRoot();
    }

    public String toString() {
        return String.valueOf(this.getTestName()) + ": " + this.getStatus();
    }

    public static final class Status {
        public static final Status RUNNING = new Status("RUNNING", 0, 3);
        public static final Status ERROR = new Status("ERROR", 1, 1);
        public static final Status FAILURE = new Status("FAILURE", 2, 2);
        public static final Status OK = new Status("OK", 3, 0);
        public static final Status NOT_RUN = new Status("NOT_RUN", 4, 4);
        private static final Status[] OLD_CODE = new Status[]{OK, ERROR, FAILURE};
        private final String fName;
        private final int fPriority;
        private final int fOldCode;

        private Status(String name, int priority, int oldCode) {
            this.fName = name;
            this.fPriority = priority;
            this.fOldCode = oldCode;
        }

        public int getPriority() {
            return this.fPriority;
        }

        public int getOldCode() {
            return this.fOldCode;
        }

        public String toString() {
            return this.fName;
        }

        public static Status convert(int oldStatus) {
            return OLD_CODE[oldStatus];
        }

        public boolean isFailure() {
            return this == FAILURE || this == ERROR;
        }
    }
}

