/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.OpenEditorAction;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenTestAction
extends OpenEditorAction {
    private String fMethodName;
    private ISourceRange fRange;

    public OpenTestAction(TestRunnerViewPart testRunner, String className, String method) {
        this(testRunner, className, method, true);
    }

    public OpenTestAction(TestRunnerViewPart testRunner, String className) {
        this(testRunner, className, null);
    }

    public OpenTestAction(TestRunnerViewPart testRunner, String className, String method, boolean activate) {
        super(testRunner, className, activate);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.junit.open_test_action_context");
        this.fMethodName = method;
    }

    protected IJavaElement findElement(IJavaProject project, String className) throws JavaModelException {
        IType type = project.findType(className);
        if (type == null) {
            return null;
        }
        if (this.fMethodName == null) {
            return type;
        }
        IMethod method = this.findMethod(type);
        if (method == null) {
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
            IType[] types = typeHierarchy.getAllSuperclasses(type);
            int i = 0;
            while (i < types.length) {
                method = this.findMethod(types[i]);
                if (method != null) break;
                ++i;
            }
        }
        if (method == null) {
            String title = JUnitMessages.OpenTestAction_error_title;
            String message = Messages.format(JUnitMessages.OpenTestAction_error_methodNoFound, this.fMethodName);
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return type;
        }
        this.fRange = method.getNameRange();
        return method;
    }

    IMethod findMethod(IType type) {
        IStatus status = JavaConventions.validateMethodName((String)this.fMethodName);
        if (!status.isOK()) {
            return null;
        }
        IMethod method = type.getMethod(this.fMethodName, new String[0]);
        if (method != null && method.exists()) {
            return method;
        }
        return null;
    }

    protected void reveal(ITextEditor textEditor) {
        if (this.fRange != null) {
            textEditor.selectAndReveal(this.fRange.getOffset(), this.fRange.getLength());
        }
    }

    public boolean isEnabled() {
        try {
            return this.getLaunchedProject().findType(this.getClassName()) != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

