/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IIndex;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.index.Index;
import org.eclipse.help.internal.index.IndexEntry;
import org.eclipse.help.internal.index.IndexFile;
import org.eclipse.help.internal.index.IndexFileParser;
import org.eclipse.help.internal.model.ITocElement;

public class IndexBuilder {
    private Collection contributedIndexFiles;
    private Collection unprocessedIndexFiles = new ArrayList();
    private Index index = new Index();
    private IndexEntry current;
    private Stack entries = new Stack();
    private ITocElement[] tocs = HelpPlugin.getTocManager().getTocs(Platform.getNL());

    public void build(Collection contributedIndexFiles) {
        this.contributedIndexFiles = contributedIndexFiles;
        this.unprocessedIndexFiles.addAll(this.contributedIndexFiles);
        while (!this.unprocessedIndexFiles.isEmpty()) {
            IndexFile indexFile = (IndexFile)this.unprocessedIndexFiles.iterator().next();
            indexFile.build(this);
        }
    }

    public void buildIndexFile(IndexFile file) {
        this.unprocessedIndexFiles.remove(file);
        IndexFileParser parser = new IndexFileParser(this);
        parser.parse(file);
    }

    protected void addIndexEntry(String keyword) {
        Index currIndex = this.current == null ? this.index : this.current;
        IndexEntry newEntry = currIndex.addEntry(keyword);
        if (this.current != null) {
            this.entries.push(this.current);
        }
        this.current = newEntry;
    }

    protected void exitIndexEntry() {
        this.current = this.entries.empty() ? null : (IndexEntry)this.entries.pop();
    }

    protected void addTopic(String label, String href, String location) {
        boolean emptyLocation;
        boolean emptyLabel = label == null || label.length() == 0;
        boolean bl = emptyLocation = location == null || location.length() == 0;
        if (emptyLabel || emptyLocation) {
            int i = 0;
            while (i < this.tocs.length) {
                ITopic topic = this.tocs[i].getTopic(href);
                if (topic != null) {
                    if (emptyLabel) {
                        label = topic.getLabel();
                        emptyLabel = false;
                    }
                    if (emptyLocation) {
                        location = this.tocs[i].getLabel();
                        emptyLocation = false;
                    }
                }
                ++i;
            }
        }
        if (emptyLocation) {
            location = "";
        }
        if (emptyLabel) {
            label = "";
        }
        if (this.current != null) {
            this.current.addTopic(label, href, location);
        }
    }

    protected IIndex getBuiltIndex() {
        return this.index;
    }
}

