/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.xhtml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.util.ResourceLocator;
import org.eclipse.help.internal.xhtml.BundleUtil;
import org.eclipse.help.internal.xhtml.DOMUtil;
import org.eclipse.help.internal.xhtml.UAContentParser;
import org.eclipse.help.internal.xhtml.UAInclude;
import org.eclipse.help.internal.xhtml.UATopicExtension;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UAContentMergeProcessor {
    protected static final String CONTENT_EXTENSION = "org.eclipse.help.contentExtension";
    protected static IExtensionRegistry registry = Platform.getExtensionRegistry();
    protected static IConfigurationElement[] contentExtensionElements = UAContentMergeProcessor.getContentExtensions();
    private Hashtable unresolvedConfigExt = new Hashtable();
    private String pluginID = null;
    private String file = null;
    private Document document = null;
    private String locale = null;

    protected UAContentMergeProcessor(String pluginID, String file, Document document, String locale) {
        this.pluginID = pluginID;
        this.file = file;
        this.document = document;
        this.locale = locale;
    }

    public Document resolveIncludes() {
        NodeList includes = this.document.getElementsByTagNameNS("*", "include");
        Node[] nodes = UAContentMergeProcessor.getArray(includes);
        int i = 0;
        while (i < nodes.length) {
            Element includeElement = (Element)nodes[i];
            UAInclude include = new UAInclude(includeElement);
            Element targetElement = this.findIncludeTarget(include);
            if (targetElement == null) {
                String message = "Could not resolve following include:  ";
                HelpPlugin.logWarning(message);
                return null;
            }
            Node targetNode = this.document.importNode(targetElement, true);
            includeElement.getParentNode().replaceChild(targetNode, includeElement);
            ++i;
        }
        return this.document;
    }

    private Element findIncludeTarget(UAInclude include) {
        ArrayList pathPrefix;
        String path = include.getPath();
        int index = path.indexOf("/");
        if (index < 0) {
            return null;
        }
        String pluginID = path.substring(0, index);
        int lastIndex = path.lastIndexOf("/");
        String pluginRelativePath = path.substring(index + 1, lastIndex);
        String include_id = path.substring(lastIndex + 1, path.length());
        Bundle bundle = Platform.getBundle((String)pluginID);
        URL flatFileURL = ResourceLocator.find(bundle, (IPath)new Path(pluginRelativePath), pathPrefix = ResourceLocator.getPathPrefix(this.locale));
        if (flatFileURL != null) {
            try {
                InputStream inputStream = flatFileURL.openStream();
                UAContentParser parser = new UAContentParser(inputStream);
                Document dom = parser.getDocument();
                return DOMUtil.getElementById(dom, include_id, "*");
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public static Node[] getArray(NodeList nodeList) {
        Node[] nodes = new Node[nodeList.getLength()];
        int i = 0;
        while (i < nodeList.getLength()) {
            nodes[i] = nodeList.item(i);
            ++i;
        }
        return nodes;
    }

    protected static IConfigurationElement[] getContentExtensions() {
        IConfigurationElement[] contentExtensionElements = registry.getConfigurationElementsFor(CONTENT_EXTENSION);
        return contentExtensionElements;
    }

    public Document resolveContentExtensions() {
        int i = 0;
        while (i < contentExtensionElements.length) {
            this.resolveContentExtension(contentExtensionElements[i]);
            ++i;
        }
        return this.document;
    }

    private void resolveContentExtension(IConfigurationElement contentExtElement) {
        Document contentExtensionDom = this.loadContentExtension(contentExtElement);
        if (contentExtensionDom == null) {
            return;
        }
        this.resolveContentExtension(contentExtensionDom, contentExtElement);
    }

    private void resolveContentExtension(Document contentExtensionDom, IConfigurationElement contentExtElement) {
        Element[] topicReplaces;
        Bundle bundle = BundleUtil.getBundleFromConfigurationElement(contentExtElement);
        Element[] topicExtensions = DOMUtil.getElementsByTagName(contentExtensionDom, "topicExtension");
        if (topicExtensions != null) {
            int i = 0;
            while (i < topicExtensions.length) {
                this.doResolveContentExtension(topicExtensions[i], bundle);
                ++i;
            }
        }
        if ((topicReplaces = DOMUtil.getElementsByTagName(contentExtensionDom, "topicReplace")) != null) {
            int i = 0;
            while (i < topicReplaces.length) {
                this.doResolveContentReplace(topicReplaces[i], bundle);
                ++i;
            }
        }
    }

    private void doResolveContentExtension(Element topicExtension, Bundle bundle) {
        UATopicExtension topicExtensionModel = new UATopicExtension(topicExtension, bundle);
        boolean isExtensionToCurrentPage = this.resolveTopicExtension(topicExtensionModel);
        if (isExtensionToCurrentPage) {
            if (topicExtension.hasAttribute("failed")) {
                if (!this.unresolvedConfigExt.containsKey(topicExtension)) {
                    this.unresolvedConfigExt.put(topicExtension, bundle);
                }
            } else {
                this.unresolvedConfigExt.remove(topicExtension);
                this.tryResolvingExtensions();
            }
        }
    }

    private void tryResolvingExtensions() {
        Enumeration keys = this.unresolvedConfigExt.keys();
        while (keys.hasMoreElements()) {
            Element topicExtensionElement = (Element)keys.nextElement();
            this.doResolveContentExtension(topicExtensionElement, (Bundle)this.unresolvedConfigExt.get(topicExtensionElement));
        }
    }

    private boolean resolveTopicExtension(UATopicExtension topicExtension) {
        Element anchorElement = this.findAnchor(topicExtension, this.locale);
        if (anchorElement == null) {
            return topicExtension.getElement().hasAttribute("failed");
        }
        Element[] elements = topicExtension.getElements();
        int i = 0;
        while (i < elements.length) {
            Node targetNode = this.document.importNode(elements[i], true);
            anchorElement.getParentNode().insertBefore(targetNode, anchorElement);
            ++i;
        }
        return true;
    }

    private Element findAnchor(UATopicExtension topicExtension, String locale) {
        String path = topicExtension.getPath();
        int index = path.indexOf("/");
        if (index < 0) {
            return null;
        }
        String pluginID = path.substring(0, index);
        int lastIndex = path.lastIndexOf("/");
        String pluginRelativePath = path.substring(index + 1, lastIndex);
        String anchor_id = path.substring(lastIndex + 1, path.length());
        if (this.pluginID.equals(pluginID) && this.file.equals(pluginRelativePath)) {
            Element anchor = DOMUtil.getElementById(this.document, anchor_id, "*");
            if (anchor == null) {
                topicExtension.getElement().setAttribute("failed", "true");
            }
            return anchor;
        }
        return null;
    }

    protected Document loadContentExtension(IConfigurationElement cfgElement) {
        String content = cfgElement.getAttribute("file");
        content = BundleUtil.getResourceLocation(content, cfgElement);
        Document document = new UAContentParser(content).getDocument();
        return document;
    }

    private void doResolveContentReplace(Element topicReplace, Bundle bundle) {
        UATopicExtension topicReplaceModel = new UATopicExtension(topicReplace, bundle);
        boolean isExtensionToCurrentPage = this.resolveTopicReplace(topicReplaceModel);
        if (isExtensionToCurrentPage) {
            if (topicReplace.hasAttribute("failed")) {
                if (!this.unresolvedConfigExt.containsKey(topicReplace)) {
                    this.unresolvedConfigExt.put(topicReplace, bundle);
                }
            } else {
                this.unresolvedConfigExt.remove(topicReplace);
            }
        }
    }

    private boolean resolveTopicReplace(UATopicExtension topicReplace) {
        Element replaceElement = this.findReplaceElementById(topicReplace, this.locale);
        if (replaceElement == null) {
            return topicReplace.getElement().hasAttribute("failed");
        }
        Element[] elements = topicReplace.getElements();
        int i = 0;
        while (i < elements.length) {
            Node targetNode = this.document.importNode(elements[i], true);
            replaceElement.getParentNode().insertBefore(targetNode, replaceElement);
            ++i;
        }
        replaceElement.getParentNode().removeChild(replaceElement);
        return true;
    }

    private Element findReplaceElementById(UATopicExtension topicReplace, String locale) {
        String path = topicReplace.getPath();
        int index = path.indexOf("/");
        if (index < 0) {
            return null;
        }
        String pluginID = path.substring(0, index);
        int lastIndex = path.lastIndexOf("/");
        String pluginRelativePath = path.substring(index + 1, lastIndex);
        String element_id = path.substring(lastIndex + 1, path.length());
        if (this.pluginID.equals(pluginID) && this.file.equals(pluginRelativePath)) {
            Element elementToReplace = DOMUtil.getElementById(this.document, element_id, "*");
            if (elementToReplace == null) {
                topicReplace.getElement().setAttribute("failed", "true");
            }
            return elementToReplace;
        }
        return null;
    }
}

