/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.dialogs.IFileStoreFilter;

public class FileFolderSelectionDialog
extends ElementTreeSelectionDialog {
    public FileFolderSelectionDialog(Shell parent, boolean multiSelect, int type) {
        super(parent, (ILabelProvider)new FileLabelProvider(), (ITreeContentProvider)new FileContentProvider((type & 1) != 0));
        this.setSorter(new FileViewerSorter());
        this.setValidator(new FileSelectionValidator(multiSelect, (type & 2) != 0));
    }

    private static class FileLabelProvider
    extends LabelProvider {
        private static final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        private static final Image IMG_FILE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");

        FileLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IFileStore) {
                IFileStore curr = (IFileStore)element;
                if (curr.fetchInfo().isDirectory()) {
                    return IMG_FOLDER;
                }
                return IMG_FILE;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IFileStore) {
                return ((IFileStore)element).getName();
            }
            return super.getText(element);
        }
    }

    private static class FileContentProvider
    implements ITreeContentProvider {
        private static final Object[] EMPTY = new Object[0];
        private IFileStoreFilter fileFilter;

        public FileContentProvider(boolean showFiles) {
            this.fileFilter = new IFileStoreFilter(this, showFiles){
                final /* synthetic */ FileContentProvider this$1;
                private final /* synthetic */ boolean val$showFiles;
                {
                    this.this$1 = fileContentProvider;
                    this.val$showFiles = bl;
                }

                public boolean accept(IFileStore file) {
                    return file.fetchInfo().isDirectory() || this.val$showFiles;
                }
            };
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children;
            if (parentElement instanceof IFileStore && (children = IDEResourceInfoUtils.listFileStores((IFileStore)parentElement, this.fileFilter, (IProgressMonitor)new NullProgressMonitor())) != null) {
                return children;
            }
            return EMPTY;
        }

        public Object getParent(Object element) {
            if (element instanceof IFileStore) {
                return ((IFileStore)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class FileViewerSorter
    extends ViewerSorter {
        FileViewerSorter() {
        }

        public int category(Object element) {
            if (element instanceof IFileStore && !((IFileStore)element).fetchInfo().isDirectory()) {
                return 1;
            }
            return 0;
        }
    }

    private static class FileSelectionValidator
    implements ISelectionStatusValidator {
        private boolean multiSelect;
        private boolean acceptFolders;

        public FileSelectionValidator(boolean multiSelect, boolean acceptFolders) {
            this.multiSelect = multiSelect;
            this.acceptFolders = acceptFolders;
        }

        public IStatus validate(Object[] selection) {
            int nSelected = selection.length;
            String pluginId = "org.eclipse.ui.ide";
            if (nSelected == 0 || nSelected > 1 && !this.multiSelect) {
                return new Status(4, pluginId, 4, "", null);
            }
            int i = 0;
            while (i < selection.length) {
                Object curr = selection[i];
                if (curr instanceof IFileStore) {
                    IFileStore file = (IFileStore)curr;
                    if (!this.acceptFolders && file.fetchInfo().isDirectory()) {
                        return new Status(4, pluginId, 4, "", null);
                    }
                }
                ++i;
            }
            return Status.OK_STATUS;
        }
    }
}

