/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IResourceActionFilter;
import org.eclipse.ui.actions.SimpleWildcardTester;
import org.eclipse.ui.model.WorkbenchAdapter;

public abstract class WorkbenchResource
extends WorkbenchAdapter
implements IResourceActionFilter {
    static /* synthetic */ Class class$0;

    protected abstract ImageDescriptor getBaseImage(IResource var1);

    public ImageDescriptor getImageDescriptor(Object o) {
        IResource resource = this.getResource(o);
        return resource == null ? null : this.getBaseImage(resource);
    }

    public String getLabel(Object o) {
        IResource resource = this.getResource(o);
        return resource == null ? null : resource.getName();
    }

    public Object getParent(Object o) {
        IResource resource = this.getResource(o);
        return resource == null ? null : resource.getParent();
    }

    protected IResource getResource(Object o) {
        if (o instanceof IResource) {
            return (IResource)o;
        }
        if (o instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (!(target instanceof IResource)) {
            return false;
        }
        IResource res = (IResource)target;
        if (name.equals("name")) {
            return SimpleWildcardTester.testWildcardIgnoreCase((String)value, (String)res.getName());
        }
        if (name.equals("path")) {
            return SimpleWildcardTester.testWildcardIgnoreCase((String)value, (String)res.getFullPath().toString());
        }
        if (name.equals("extension")) {
            return SimpleWildcardTester.testWildcardIgnoreCase((String)value, (String)res.getFileExtension());
        }
        if (name.equals("readOnly")) {
            return res.isReadOnly() == value.equalsIgnoreCase("true");
        }
        if (name.equals("projectNature")) {
            try {
                IProject proj = res.getProject();
                return proj.isAccessible() && proj.hasNature(value);
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        if (name.equals("persistentProperty")) {
            return this.testProperty(res, true, false, value);
        }
        if (name.equals("projectPersistentProperty")) {
            return this.testProperty(res, true, true, value);
        }
        if (name.equals("sessionProperty")) {
            return this.testProperty(res, false, false, value);
        }
        if (name.equals("projectSessionProperty")) {
            return this.testProperty(res, false, true, value);
        }
        if (name.equals("contentTypeId")) {
            return this.testContentTypeProperty(res, value);
        }
        return false;
    }

    private final boolean testContentTypeProperty(IResource resource, String contentTypeId) {
        String expectedValue = contentTypeId.trim();
        if (!(resource instanceof IFile)) {
            return false;
        }
        IFile file = (IFile)resource;
        String actualValue = null;
        try {
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription != null) {
                IContentType contentType = contentDescription.getContentType();
                actualValue = contentType.getId();
            }
        }
        catch (CoreException coreException) {}
        return expectedValue == null || expectedValue.equals(actualValue);
    }

    private boolean testProperty(IResource resource, boolean persistentFlag, boolean projectFlag, String value) {
        String expectedVal;
        String propertyName;
        int i = value.indexOf(61);
        if (i != -1) {
            propertyName = value.substring(0, i).trim();
            expectedVal = value.substring(i + 1).trim();
        } else {
            propertyName = value.trim();
            expectedVal = null;
        }
        try {
            IResource resToCheck;
            int dot = propertyName.lastIndexOf(46);
            QualifiedName key = dot != -1 ? new QualifiedName(propertyName.substring(0, dot), propertyName.substring(dot + 1)) : new QualifiedName(null, propertyName);
            Object object = resToCheck = projectFlag ? resource.getProject() : resource;
            if (resToCheck == null) {
                return false;
            }
            if (persistentFlag) {
                String actualVal = resToCheck.getPersistentProperty(key);
                if (actualVal == null) {
                    return false;
                }
                return expectedVal == null || expectedVal.equals(actualVal);
            }
            Object actualVal = resToCheck.getSessionProperty(key);
            if (actualVal == null) {
                return false;
            }
            return expectedVal == null || expectedVal.equals(actualVal.toString());
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

