/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.internal.ide.undo.AbstractWorkspaceOperation;
import org.eclipse.ui.internal.ide.undo.MarkerDescription;

public abstract class AbstractMarkersOperation
extends AbstractWorkspaceOperation {
    MarkerDescription[] markerDescriptions;
    IMarker[] markers;
    Map[] attributes;

    AbstractMarkersOperation(IMarker[] markers, MarkerDescription[] markerDescriptions, Map[] attributes, String name, String errorTitle) {
        super(name, errorTitle);
        this.markers = markers;
        this.attributes = attributes;
        this.markerDescriptions = markerDescriptions;
        this.updateTargetResources(markers);
    }

    protected void deleteMarkers(int work, IProgressMonitor monitor) throws CoreException {
        if (this.markers == null || this.markers.length == 0) {
            monitor.worked(work);
            return;
        }
        int markerWork = work / this.markers.length;
        this.markerDescriptions = new MarkerDescription[this.markers.length];
        int i = 0;
        while (i < this.markers.length) {
            this.markerDescriptions[i] = new MarkerDescription(this.markers[i]);
            this.markers[i].delete();
            monitor.worked(markerWork);
            ++i;
        }
        this.markers = new IMarker[0];
    }

    protected void createMarkers(int work, IProgressMonitor monitor) throws CoreException {
        if (this.markerDescriptions == null || this.markerDescriptions.length == 0) {
            monitor.worked(work);
            return;
        }
        int markerWork = work / this.markerDescriptions.length;
        this.markers = new IMarker[this.markerDescriptions.length];
        int i = 0;
        while (i < this.markerDescriptions.length) {
            this.markers[i] = this.markerDescriptions[i].createMarker();
            monitor.worked(markerWork);
            ++i;
        }
    }

    protected void updateMarkers(int work, IProgressMonitor monitor) throws CoreException {
        if (this.attributes == null || this.markers == null || this.attributes.length != this.markers.length || this.markers.length == 0) {
            monitor.worked(work);
            return;
        }
        int markerWork = work / this.markers.length;
        int i = 0;
        while (i < this.markers.length) {
            Map oldAttributes = this.markers[i].getAttributes();
            int increment = markerWork / this.attributes[i].size();
            HashMap replacedAttributes = new HashMap();
            Iterator iter = this.attributes[i].keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object val = this.attributes[i].get(key);
                this.markers[i].setAttribute(key, val);
                replacedAttributes.put(key, oldAttributes.get(key));
                monitor.worked(increment);
            }
            this.attributes[i] = replacedAttributes;
            ++i;
        }
    }

    private void updateTargetResources(IMarker[] markers) {
        if (markers != null) {
            IResource[] resources = new IResource[markers.length];
            int i = 0;
            while (i < markers.length) {
                resources[i] = markers[i].getResource();
                ++i;
            }
        }
        this.setTargetResources(this.resources);
    }
}

