/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.preferences.ViewPreferencesAction;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.views.markers.internal.FiltersAction;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerTreeContentProvider;
import org.eclipse.ui.views.markers.internal.TableSortAction;
import org.eclipse.ui.views.markers.internal.TableSortDialog;
import org.eclipse.ui.views.markers.internal.TableSorter;
import org.eclipse.ui.views.markers.internal.TableView;
import org.eclipse.ui.views.markers.internal.TableViewLabelProvider;
import org.eclipse.ui.views.markers.internal.Util;

public abstract class TableView
extends ViewPart {
    private static final String TAG_COLUMN_WIDTH = "columnWidth";
    private static final String TAG_VERTICAL_POSITION = "verticalPosition";
    private static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    private TreeViewer viewer;
    private IMemento memento;
    private IAction sortAction;
    private IAction filtersAction;
    private IAction preferencesAction;
    private MarkerTreeContentProvider contentProvider;
    static /* synthetic */ Class class$0;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    protected abstract void viewerSelectionChanged(IStructuredSelection var1);

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(this.createTree(parent));
        this.createColumns(this.viewer.getTree());
        this.contentProvider = new MarkerTreeContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableViewLabelProvider(this.getAllFields()));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                TableView.this.viewerSelectionChanged(selection);
            }
        });
        this.viewer.setSorter(this.buildSorter());
        this.createActions();
        this.viewer.setInput(this.createViewerInput());
        Scrollable scrollable = (Scrollable)this.viewer.getControl();
        ScrollBar bar = scrollable.getVerticalBar();
        if (bar != null) {
            bar.setSelection(this.restoreVerticalScrollBarPosition(this.memento));
        }
        if ((bar = scrollable.getHorizontalBar()) != null) {
            bar.setSelection(this.restoreHorizontalScrollBarPosition(this.memento));
        }
        MenuManager mgr = this.initContextMenu();
        Menu menu = mgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mgr, (ISelectionProvider)this.getViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.initMenu(actionBars.getMenuManager());
        this.initToolBar(actionBars.getToolBarManager());
        this.registerGlobalActions(this.getViewSite().getActionBars());
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                TableView.this.handleOpenEvent(event);
            }
        });
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TableView.this.handleKeyPressed(e);
            }
        });
    }

    abstract Object createViewerInput();

    void setSorter(TableSorter sorter2) {
        TableSorter newSorter = new TableSorter(sorter2);
        this.viewer.setSorter((ViewerSorter)newSorter);
        newSorter.saveState(this.getDialogSettings());
        this.viewer.refresh();
    }

    protected Tree createTree(Composite parent) {
        Tree tree = new Tree(parent, 66306);
        tree.setLinesVisible(true);
        return tree;
    }

    public ColumnPixelData[] getSavedColumnData() {
        ColumnPixelData[] defaultData = this.getDefaultColumnLayouts();
        ColumnPixelData[] result = new ColumnPixelData[defaultData.length];
        int i = 0;
        while (i < defaultData.length) {
            Integer widthInt;
            int width = defaultData[i].width;
            ColumnPixelData defaultPixelData = defaultData[i];
            if (defaultPixelData.resizable && this.memento != null && (widthInt = this.memento.getInteger(TAG_COLUMN_WIDTH + i)) != null && widthInt > 0) {
                width = widthInt;
            }
            result[i] = new ColumnPixelData(width, defaultPixelData.resizable, defaultPixelData.addTrim);
            ++i;
        }
        return result;
    }

    public ColumnPixelData[] getColumnData() {
        ColumnPixelData[] defaultData = this.getSavedColumnData();
        Tree tree = this.getTree();
        if (tree != null && (tree.isDisposed() || tree.getBounds().width == 0)) {
            tree = null;
        }
        TreeColumn[] column = null;
        if (tree != null) {
            column = tree.getColumns();
        }
        ColumnPixelData[] result = new ColumnPixelData[defaultData.length];
        int i = 0;
        while (i < defaultData.length) {
            TreeColumn col;
            ColumnPixelData defaultPixelData = defaultData[i];
            int width = defaultData[i].width;
            if (column != null && i < column.length && (col = column[i]).getWidth() > 0) {
                width = col.getWidth();
            }
            result[i] = new ColumnPixelData(width, defaultPixelData.resizable, defaultPixelData.addTrim);
            ++i;
        }
        return result;
    }

    protected void createColumns(Tree tree) {
        TableLayout layout = new TableLayout();
        tree.setLayout((Layout)layout);
        tree.setHeaderVisible(true);
        IField[] fields = this.getAllFields();
        ColumnPixelData[] columnWidths = this.getSavedColumnData();
        int i = 0;
        while (i < fields.length) {
            layout.addColumnData((ColumnLayoutData)columnWidths[i]);
            TreeColumn tc = new TreeColumn(tree, 0, i);
            tc.setText(fields[i].getColumnHeaderText());
            tc.setImage(fields[i].getColumnHeaderImage());
            tc.setResizable(columnWidths[i].resizable);
            tc.addSelectionListener(this.getHeaderListener());
            tc.setData((Object)fields[i]);
            ++i;
        }
    }

    protected void createActions() {
        if (this.getSortDialog() != null) {
            this.sortAction = new TableSortAction(this, this.getSortDialog());
        }
    }

    protected MenuManager initContextMenu() {
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TableView.this.getViewer().cancelEditing();
                TableView.this.fillContextMenu(mgr);
            }
        });
        return mgr;
    }

    protected abstract void initToolBar(IToolBarManager var1);

    protected void initMenu(IMenuManager menu) {
        if (this.sortAction != null) {
            menu.add(this.sortAction);
        }
        this.addDropDownContributions(menu);
        if (this.filtersAction != null) {
            menu.add(this.filtersAction);
        }
        if (this.preferencesAction != null) {
            menu.add(this.preferencesAction);
        }
    }

    void addDropDownContributions(IMenuManager menu) {
    }

    protected abstract void registerGlobalActions(IActionBars var1);

    protected abstract void fillContextMenu(IMenuManager var1);

    public void setFocus() {
        TreeViewer viewer = this.getViewer();
        if (viewer != null && !viewer.getControl().isDisposed()) {
            viewer.getControl().setFocus();
        }
    }

    protected ViewerSorter buildSorter() {
        IField[] sortingFields = this.getSortingFields();
        int[] priorities = new int[sortingFields.length];
        int[] directions = new int[sortingFields.length];
        int i = 0;
        while (i < sortingFields.length) {
            priorities[i] = i;
            ++i;
        }
        Arrays.fill(directions, 1);
        TableSorter sorter = new TableSorter(sortingFields, priorities, directions);
        sorter.restoreState(this.getDialogSettings());
        return sorter;
    }

    protected abstract IField[] getSortingFields();

    protected abstract IField[] getAllFields();

    protected abstract IDialogSettings getDialogSettings();

    protected TreeViewer getViewer() {
        return this.viewer;
    }

    protected Tree getTree() {
        return this.getViewer().getTree();
    }

    protected SelectionListener getHeaderListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IField field = (IField)e.widget.getData();
                try {
                    TableView.this.getProgressService().busyCursorWhile(new IRunnableWithProgress(this, field){
                        final /* synthetic */ 5 this$1;
                        private final /* synthetic */ IField val$field;
                        {
                            this.this$1 = var1_1;
                            this.val$field = iField;
                        }

                        public void run(IProgressMonitor monitor) {
                            TableSorter sorter = 5.access$0(this.this$1).getTableSorter();
                            monitor.beginTask(MarkerMessages.sortDialog_title, 100);
                            monitor.worked(10);
                            if (this.val$field.equals(sorter.getTopField())) {
                                sorter.reverseTopPriority();
                            } else {
                                sorter.setTopPriority(this.val$field);
                            }
                            monitor.worked(15);
                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(this){
                                final /* synthetic */ 6 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                public void run() {
                                    TableView.access$0(5.access$0(6.access$0(this.this$2))).refresh();
                                }
                            });
                            monitor.done();
                        }

                        static /* synthetic */ 5 access$0(6 var0) {
                            return var0.this$1;
                        }
                    });
                }
                catch (InvocationTargetException e1) {
                    IDEWorkbenchPlugin.getDefault().getLog().log(Util.errorStatus(e1));
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }

            static /* synthetic */ TableView access$0(5 var0) {
                return var0.TableView.this;
            }
        };
    }

    protected ColumnPixelData[] getDefaultColumnLayouts() {
        IField[] fields = this.getAllFields();
        ColumnPixelData[] datas = new ColumnPixelData[fields.length];
        int i = 0;
        while (i < fields.length) {
            int width = this.getWidth(fields[i]);
            boolean resizable = width > 0;
            datas[i] = new ColumnPixelData(width, resizable, resizable);
            ++i;
        }
        return datas;
    }

    private int getWidth(IField field) {
        if (!field.isShowing()) {
            return 0;
        }
        return field.getPreferredWidth();
    }

    protected TableSortDialog getSortDialog() {
        return new TableSortDialog((IShellProvider)this.getSite(), this.getTableSorter());
    }

    TableSorter getTableSorter() {
        return (TableSorter)this.viewer.getSorter();
    }

    protected abstract void handleKeyPressed(KeyEvent var1);

    protected abstract void handleOpenEvent(OpenEvent var1);

    public void saveState(IMemento memento) {
        super.saveState(memento);
        ColumnPixelData[] data = this.getColumnData();
        int i = 0;
        while (i < data.length) {
            ColumnPixelData data2 = data[i];
            memento.putInteger(TAG_COLUMN_WIDTH + i, data2.width);
            ++i;
        }
        Scrollable scrollable = (Scrollable)this.viewer.getControl();
        ScrollBar bar = scrollable.getVerticalBar();
        int position = bar != null ? bar.getSelection() : 0;
        memento.putInteger(TAG_VERTICAL_POSITION, position);
        bar = scrollable.getHorizontalBar();
        position = bar != null ? bar.getSelection() : 0;
        memento.putInteger(TAG_HORIZONTAL_POSITION, position);
    }

    private int restoreVerticalScrollBarPosition(IMemento memento) {
        if (memento == null) {
            return 0;
        }
        Integer position = memento.getInteger(TAG_VERTICAL_POSITION);
        return position == null ? 0 : position;
    }

    private int restoreHorizontalScrollBarPosition(IMemento memento) {
        if (memento == null) {
            return 0;
        }
        Integer position = memento.getInteger(TAG_HORIZONTAL_POSITION);
        return position == null ? 0 : position;
    }

    protected IWorkbenchSiteProgressService getProgressService() {
        Object siteService;
        IWorkbenchSiteProgressService service = null;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((siteService = iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
            service = (IWorkbenchSiteProgressService)siteService;
        }
        return service;
    }

    void setFilterAction(FiltersAction action) {
        this.filtersAction = action;
    }

    IAction getFilterAction() {
        return this.filtersAction;
    }

    IAction getPreferencesAction() {
        return this.preferencesAction;
    }

    void setPreferencesAction(ViewPreferencesAction preferencesAction) {
        this.preferencesAction = preferencesAction;
    }

    MarkerTreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public Object getViewerInput() {
        return this.getViewer().getInput();
    }

    static /* synthetic */ TreeViewer access$0(TableView tableView) {
        return tableView.viewer;
    }
}

