/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.browser.Trace;
import org.eclipse.ui.internal.browser.WebBrowserUIPlugin;
import org.osgi.framework.Bundle;

public class ImageResource {
    private static ImageRegistry imageRegistry;
    private static Map imageDescriptors;
    private static URL ICON_BASE_URL;
    private static Image[] busyImages;
    private static final String URL_CLCL = "clcl16/";
    private static final String URL_ELCL = "elcl16/";
    private static final String URL_DLCL = "dlcl16/";
    private static final String URL_OBJ = "obj16/";
    public static final String IMG_CLCL_NAV_BACKWARD = "IMG_CLCL_NAV_BACKWARD";
    public static final String IMG_CLCL_NAV_FORWARD = "IMG_CLCL_NAV_FORWARD";
    public static final String IMG_CLCL_NAV_STOP = "IMG_CLCL_NAV_STOP";
    public static final String IMG_CLCL_NAV_REFRESH = "IMG_CLCL_NAV_REFRESH";
    public static final String IMG_CLCL_NAV_GO = "IMG_CLCL_NAV_GO";
    public static final String IMG_CLCL_NAV_HOME = "IMG_CLCL_NAV_HOME";
    public static final String IMG_CLCL_NAV_PRINT = "IMG_CLCL_NAV_PRINT";
    public static final String IMG_ELCL_NAV_BACKWARD = "IMG_ELCL_NAV_BACKWARD";
    public static final String IMG_ELCL_NAV_FORWARD = "IMG_ELCL_NAV_FORWARD";
    public static final String IMG_ELCL_NAV_STOP = "IMG_ELCL_NAV_STOP";
    public static final String IMG_ELCL_NAV_REFRESH = "IMG_ELCL_NAV_REFRESH";
    public static final String IMG_ELCL_NAV_GO = "IMG_ELCL_NAV_GO";
    public static final String IMG_ELCL_NAV_HOME = "IMG_ELCL_NAV_HOME";
    public static final String IMG_ELCL_NAV_PRINT = "IMG_ELCL_NAV_PRINT";
    public static final String IMG_DLCL_NAV_BACKWARD = "IMG_DLCL_NAV_BACKWARD";
    public static final String IMG_DLCL_NAV_FORWARD = "IMG_DLCL_NAV_FORWARD";
    public static final String IMG_DLCL_NAV_STOP = "IMG_DLCL_NAV_STOP";
    public static final String IMG_DLCL_NAV_REFRESH = "IMG_DLCL_NAV_REFRESH";
    public static final String IMG_DLCL_NAV_GO = "IMG_DLCL_NAV_GO";
    public static final String IMG_DLCL_NAV_HOME = "IMG_DLCL_NAV_HOME";
    public static final String IMG_DLCL_NAV_PRINT = "IMG_DLCL_NAV_PRINT";
    public static final String IMG_INTERNAL_BROWSER = "internalBrowser";
    public static final String IMG_EXTERNAL_BROWSER = "externalBrowser";
    public static final String IMG_SYSTEM_BROWSER = "systemBrowser";

    static {
        try {
            String pathSuffix = "icons/";
            ICON_BASE_URL = FileLocator.find((Bundle)WebBrowserUIPlugin.getInstance().getBundle(), (IPath)new Path(pathSuffix), null);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not set icon base URL", e);
        }
    }

    private ImageResource() {
    }

    public static Image[] getBusyImages() {
        return busyImages;
    }

    public static Image getImage(String key) {
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        return imageRegistry.get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        return (ImageDescriptor)imageDescriptors.get(key);
    }

    protected static void initializeImageRegistry() {
        imageRegistry = new ImageRegistry();
        imageDescriptors = new HashMap();
        ImageResource.registerImage(IMG_ELCL_NAV_BACKWARD, "elcl16/nav_backward.gif");
        ImageResource.registerImage(IMG_ELCL_NAV_FORWARD, "elcl16/nav_forward.gif");
        ImageResource.registerImage(IMG_ELCL_NAV_STOP, "elcl16/nav_stop.gif");
        ImageResource.registerImage(IMG_ELCL_NAV_REFRESH, "elcl16/nav_refresh.gif");
        ImageResource.registerImage(IMG_ELCL_NAV_GO, "elcl16/nav_go.gif");
        ImageResource.registerImage(IMG_ELCL_NAV_HOME, "elcl16/nav_home.gif");
        ImageResource.registerImage(IMG_ELCL_NAV_PRINT, "elcl16/nav_print.gif");
        ImageResource.registerImage(IMG_CLCL_NAV_BACKWARD, "clcl16/nav_backward.gif");
        ImageResource.registerImage(IMG_CLCL_NAV_FORWARD, "clcl16/nav_forward.gif");
        ImageResource.registerImage(IMG_CLCL_NAV_STOP, "clcl16/nav_stop.gif");
        ImageResource.registerImage(IMG_CLCL_NAV_REFRESH, "clcl16/nav_refresh.gif");
        ImageResource.registerImage(IMG_CLCL_NAV_GO, "clcl16/nav_go.gif");
        ImageResource.registerImage(IMG_CLCL_NAV_HOME, "clcl16/nav_home.gif");
        ImageResource.registerImage(IMG_CLCL_NAV_PRINT, "clcl16/nav_print.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_BACKWARD, "dlcl16/nav_backward.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_FORWARD, "dlcl16/nav_forward.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_STOP, "dlcl16/nav_stop.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_REFRESH, "dlcl16/nav_refresh.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_GO, "dlcl16/nav_go.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_HOME, "dlcl16/nav_home.gif");
        ImageResource.registerImage(IMG_DLCL_NAV_PRINT, "dlcl16/nav_print.gif");
        ImageResource.registerImage(IMG_INTERNAL_BROWSER, "obj16/internal_browser.gif");
        ImageResource.registerImage(IMG_EXTERNAL_BROWSER, "obj16/external_browser.gif");
        busyImages = new Image[13];
        int i = 0;
        while (i < 13) {
            ImageResource.registerImage("busy" + i, "obj16/busy/" + (i + 1) + ".gif");
            ImageResource.busyImages[i] = ImageResource.getImage("busy" + i);
            ++i;
        }
    }

    private static void registerImage(String key, String partialURL) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, partialURL));
            imageRegistry.put(key, id);
            imageDescriptors.put(key, id);
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Error registering image " + key + " from " + partialURL, e);
        }
    }
}

