/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filebuffers.FileBuffersPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public final class FileBuffers {
    private FileBuffers() {
    }

    public static ITextFileBufferManager getTextFileBufferManager() {
        FileBuffersPlugin plugin = FileBuffersPlugin.getDefault();
        return plugin != null ? plugin.getFileBufferManager() : null;
    }

    public static IFile getWorkspaceFileAtLocation(IPath location) {
        IWorkspaceRoot workspaceRoot;
        IFile file;
        IPath normalized = FileBuffers.normalizeLocation(location);
        if (normalized.segmentCount() >= 2 && (file = (workspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).getFile(normalized)) != null && file.exists()) {
            return file;
        }
        return null;
    }

    public static IPath normalizeLocation(IPath pathOrLocation) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (workspaceRoot.exists(pathOrLocation)) {
            return pathOrLocation.makeAbsolute();
        }
        IFile file = workspaceRoot.getFileForLocation(pathOrLocation);
        if (file != null && file.exists()) {
            return file.getFullPath();
        }
        return pathOrLocation.makeAbsolute();
    }

    public static IFileStore getFileStoreAtLocation(IPath location) {
        if (location == null) {
            return null;
        }
        IFile file = FileBuffers.getWorkspaceFileAtLocation(location);
        try {
            if (file != null) {
                URI uri = file.getLocationURI();
                if (uri == null) {
                    return null;
                }
                return EFS.getStore((URI)uri);
            }
        }
        catch (CoreException coreException) {}
        return EFS.getLocalFileSystem().getStore(location);
    }

    public static File getSystemFileAtLocation(IPath location) {
        IFileStore store = FileBuffers.getFileStoreAtLocation(location);
        if (store != null) {
            try {
                return store.toLocalFile(0, null);
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }
}

