/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh2;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IServerConnection;
import org.eclipse.team.internal.ccvs.core.connection.CVSAuthenticationException;
import org.eclipse.team.internal.ccvs.ssh.SSHServerConnection;
import org.eclipse.team.internal.ccvs.ssh2.CVSSSH2Messages;
import org.eclipse.team.internal.ccvs.ssh2.JSchSession;
import org.eclipse.team.internal.core.streams.PollingInputStream;
import org.eclipse.team.internal.core.streams.PollingOutputStream;
import org.eclipse.team.internal.core.streams.TimeoutInputStream;
import org.eclipse.team.internal.core.streams.TimeoutOutputStream;

public class CVSSSH2ServerConnection
implements IServerConnection {
    private static final String COMMAND = "cvs server";
    private ICVSRepositoryLocation location;
    private String password;
    private InputStream inputStream;
    private OutputStream outputStream;
    private JSchSession session;
    private Channel channel;
    private IServerConnection ssh1;

    protected CVSSSH2ServerConnection(ICVSRepositoryLocation location, String password) {
        this.location = location;
        this.password = password;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        if (this.ssh1 != null) {
            this.ssh1.close();
            this.ssh1 = null;
            return;
        }
        try {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException v0) {}
            }
            var1_3 = null;
            ** GOTO lbl22
        }
        catch (Throwable var2_1) {
            var1_2 = null;
            try {
                block15: {
                    block16: {
                        if (this.outputStream == null) break block16;
                        try {
                            this.outputStream.close();
lbl22:
                            // 1 sources

                            ** try [egrp 2[TRYBLOCK] [4 : 50->71)] { 
lbl23:
                            // 1 sources

                            if (this.outputStream != null) {
                                ** try [egrp 3[TRYBLOCK] [3 : 57->67)] { 
lbl25:
                                // 1 sources

                                this.outputStream.close();
                            }
                            break block15;
                        }
                        catch (IOException v1) {}
                    }
                    v2 = null;
                    ** GOTO lbl38
lbl32:
                    // 1 sources

                    catch (IOException v3) {}
                }
                v4 = null;
                ** GOTO lbl44
            }
            catch (Throwable var4_4) {
                v2 = null;
lbl38:
                // 2 sources

                var3_6 = v2;
                if (this.channel == null) throw var2_1;
                this.channel.disconnect();
                throw var2_1;
            }
        }
lbl42:
        // 1 sources

        catch (Throwable var4_5) {
            v4 = null;
lbl44:
            // 2 sources

            var3_7 = v4;
            if (this.channel == null) return;
            this.channel.disconnect();
            return;
        }
    }

    public InputStream getInputStream() {
        if (this.ssh1 != null) {
            return this.ssh1.getInputStream();
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        if (this.ssh1 != null) {
            return this.ssh1.getOutputStream();
        }
        return this.outputStream;
    }

    public void open(IProgressMonitor monitor) throws IOException, CVSAuthenticationException {
        if (this.ssh1 != null) {
            this.ssh1.open(monitor);
            return;
        }
        monitor.subTask(NLS.bind((String)CVSSSH2Messages.CVSSSH2ServerConnection_open, (Object[])new String[]{this.location.getHost()}));
        monitor.worked(1);
        this.internalOpen(monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void internalOpen(IProgressMonitor monitor) throws IOException, CVSAuthenticationException {
        try {
            int timeout;
            OutputStream channel_out = null;
            InputStream channel_in = null;
            boolean firstTime = true;
            boolean tryAgain = false;
            while (true) {
                if (!firstTime && !tryAgain) {
                    timeout = this.location.getTimeout();
                }
                tryAgain = false;
                this.session = JSchSession.getSession(this.location, this.location.getUsername(), this.password, this.location.getHost(), this.location.getPort(), monitor);
                this.channel = this.session.getSession().openChannel("exec");
                ((ChannelExec)this.channel).setCommand(COMMAND);
                channel_out = this.channel.getOutputStream();
                channel_in = this.channel.getInputStream();
                try {
                    this.channel.connect();
                }
                catch (JSchException ee) {
                    Object var7_13;
                    try {
                        if (firstTime && (this.isSessionDownError(ee) || this.isChannelNotOpenError(ee))) {
                            tryAgain = true;
                        }
                        if (!tryAgain) {
                            throw ee;
                        }
                    }
                    catch (Throwable throwable) {
                        var7_13 = null;
                        this.session.dispose();
                        throw throwable;
                    }
                    {
                        var7_13 = null;
                        this.session.dispose();
                    }
                }
                firstTime = false;
            }
            this.inputStream = new PollingInputStream((InputStream)new TimeoutInputStream((InputStream)new FilterInputStream(channel_in){

                public void close() throws IOException {
                }
            }, 8192, 1000L, -1L, true), timeout > 0 ? timeout : 1, monitor);
            this.outputStream = new PollingOutputStream((OutputStream)new TimeoutOutputStream((OutputStream)new FilterOutputStream(channel_out){

                public void close() throws IOException {
                }
            }, 8192, 1000L, 1000L), timeout > 0 ? timeout : 1, monitor);
            return;
        }
        catch (JSchException e) {
            if (this.isSSH2Unsupported(e)) {
                this.ssh1 = new SSHServerConnection(this.location, this.password);
                if (this.ssh1 == null) {
                    throw new SSH2IOException(e.toString(), e);
                }
                this.ssh1.open(monitor);
                return;
            }
            String message = e.getMessage();
            if (JSchSession.isAuthenticationFailure(e)) {
                throw new CVSAuthenticationException(CVSSSH2Messages.CVSSSH2ServerConnection_0, 2, (Exception)((Object)e));
            }
            if (!message.startsWith("Session.connect: ")) throw new SSH2IOException(message, e);
            int start = message.indexOf(": ") + 1;
            if (start == -1) throw new SSH2IOException(message, e);
            int end = message.indexOf(": ", start);
            if (end == -1) throw new SSH2IOException(message, e);
            String exception = message.substring(start, end).trim();
            if (exception.indexOf("NoRouteToHostException") != -1) {
                message = NLS.bind((String)CVSSSH2Messages.CVSSSH2ServerConnection_1, (Object[])new String[]{this.location.getHost()});
                throw new NoRouteToHostException(message);
            }
            if (exception.indexOf("java.net.UnknownHostException") != -1) {
                throw new UnknownHostException(this.location.getHost());
            }
            message = message.substring(end + 1).trim();
            throw new SSH2IOException(message, e);
        }
    }

    private boolean isChannelNotOpenError(JSchException ee) {
        return ee.getMessage().indexOf("channel is not opened") != -1;
    }

    private boolean isSessionDownError(JSchException ee) {
        return ee.getMessage().equals("session is down");
    }

    private boolean isSSH2Unsupported(JSchException e) {
        return e.toString().indexOf("invalid server's version string") != -1;
    }

    private final class SSH2IOException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private final JSchException e;

        SSH2IOException(String s, JSchException e) {
            super(s);
            this.e = e;
        }

        public Throwable getCause() {
            return this.e;
        }
    }
}

