/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Assert;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.internal.editors.text.JavaFileStorage;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class JavaFileEditorInput
implements IPathEditorInput,
IStorageEditorInput,
ILocationProvider {
    private IFileStore fFileStore;
    private WorkbenchAdapter fWorkbenchAdapter = new WorkbenchAdapter();
    private IStorage fStorage;
    private IPath fPath;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JavaFileEditorInput(IFileStore fileStore) {
        Assert.isNotNull((Object)fileStore);
        Assert.isTrue((boolean)"file".equals(fileStore.getFileSystem().getScheme()));
        this.fFileStore = fileStore;
        this.fWorkbenchAdapter = new WorkbenchAdapter();
    }

    public boolean exists() {
        return this.fFileStore.fetchInfo().exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fFileStore.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fFileStore.toString();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.editors.text.ILocationProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter)) {
            return this.fWorkbenchAdapter;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IPath getPath(Object element) {
        if (element instanceof JavaFileEditorInput) {
            return ((JavaFileEditorInput)element).getPath();
        }
        return null;
    }

    public IPath getPath() {
        if (this.fPath == null) {
            this.fPath = new Path(this.fFileStore.toURI().getPath());
        }
        return this.fPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JavaFileEditorInput) {
            JavaFileEditorInput input = (JavaFileEditorInput)o;
            return this.fFileStore.equals(input.fFileStore);
        }
        if (o instanceof IPathEditorInput) {
            IPathEditorInput input = (IPathEditorInput)o;
            return this.getPath().equals((Object)input.getPath());
        }
        return false;
    }

    public int hashCode() {
        return this.fFileStore.hashCode();
    }

    public IStorage getStorage() throws CoreException {
        if (this.fStorage == null) {
            this.fStorage = new JavaFileStorage(this.fFileStore);
        }
        return this.fStorage;
    }

    private class WorkbenchAdapter
    implements IWorkbenchAdapter {
        WorkbenchAdapter() {
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return ((JavaFileEditorInput)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }
    }
}

