/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.diff.provider;

import org.eclipse.core.runtime.IPath;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.internal.core.Messages;

public abstract class Diff
implements IDiff {
    public static final int KIND_MASK = 255;
    private final IPath path;
    private final int status;

    protected Diff(IPath path, int status) {
        this.path = path;
        this.status = status;
    }

    public IPath getPath() {
        return this.path;
    }

    public int getKind() {
        return this.getStatus() & 0xFF;
    }

    public final int getStatus() {
        return this.status;
    }

    public String toDiffString() {
        int kind = this.getKind();
        String label = "";
        if (kind == 0) {
            label = Messages.RemoteSyncElement_insync;
        } else {
            switch (kind) {
                case 4: {
                    label = Messages.RemoteSyncElement_change;
                    break;
                }
                case 1: {
                    label = Messages.RemoteSyncElement_addition;
                    break;
                }
                case 2: {
                    label = Messages.RemoteSyncElement_deletion;
                }
            }
        }
        return label;
    }
}

