/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.diff.provider;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.diff.provider.Diff;
import org.eclipse.team.internal.core.Messages;

public class ThreeWayDiff
extends Diff
implements IThreeWayDiff {
    private final ITwoWayDiff localChange;
    private final ITwoWayDiff remoteChange;

    public ThreeWayDiff(ITwoWayDiff localChange, ITwoWayDiff remoteChange) {
        super(ThreeWayDiff.calculatePath(localChange, remoteChange), ThreeWayDiff.calculateKind(localChange, remoteChange) | ThreeWayDiff.calculateDirection(localChange, remoteChange));
        this.localChange = localChange;
        this.remoteChange = remoteChange;
    }

    private static IPath calculatePath(ITwoWayDiff localChange, ITwoWayDiff remoteChange) {
        if (localChange != null && remoteChange != null) {
            Assert.isTrue((boolean)localChange.getPath().equals((Object)remoteChange.getPath()));
        }
        if (localChange != null) {
            return localChange.getPath();
        }
        if (remoteChange != null) {
            return remoteChange.getPath();
        }
        Assert.isLegal((boolean)false, (String)"Either or local or remote change must be supplied");
        return null;
    }

    private static int calculateDirection(ITwoWayDiff localChange, ITwoWayDiff remoteChange) {
        int direction = 0;
        if (localChange != null && localChange.getKind() != 0) {
            direction |= 0x100;
        }
        if (remoteChange != null && remoteChange.getKind() != 0) {
            direction |= 0x200;
        }
        return direction;
    }

    private static int calculateKind(ITwoWayDiff localChange, ITwoWayDiff remoteChange) {
        int localKind = 0;
        if (localChange != null) {
            localKind = localChange.getKind();
        }
        int remoteKind = 0;
        if (remoteChange != null) {
            remoteKind = remoteChange.getKind();
        }
        if (localKind == 0 || localKind == remoteKind) {
            return remoteKind;
        }
        if (remoteKind == 0) {
            return localKind;
        }
        return 4;
    }

    public ITwoWayDiff getLocalChange() {
        return this.localChange;
    }

    public ITwoWayDiff getRemoteChange() {
        return this.remoteChange;
    }

    public int getDirection() {
        return this.getStatus() & 0x300;
    }

    public String toDiffString() {
        int kind = this.getKind();
        String label = "";
        if (kind == 0) {
            label = super.toDiffString();
        } else {
            switch (this.getDirection()) {
                case 768: {
                    label = Messages.RemoteSyncElement_conflicting;
                    break;
                }
                case 256: {
                    label = Messages.RemoteSyncElement_outgoing;
                    break;
                }
                case 512: {
                    label = Messages.RemoteSyncElement_incoming;
                }
            }
            label = NLS.bind((String)Messages.concatStrings, (Object[])new String[]{label, super.toDiffString()});
        }
        return label;
    }
}

