/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.subscribers;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeContext;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.core.subscribers.SubscriberDiffTreeEventHandler;

public abstract class SubscriberMergeContext
extends MergeContext {
    private Subscriber subscriber;
    private SubscriberDiffTreeEventHandler handler;
    private final ISynchronizationScopeManager manager;

    protected SubscriberMergeContext(Subscriber subscriber, ISynchronizationScopeManager manager) {
        super(manager, SubscriberMergeContext.getType(subscriber), new ResourceDiffTree());
        this.subscriber = subscriber;
        this.manager = manager;
    }

    private static int getType(Subscriber subscriber) {
        return subscriber.getResourceComparator().isThreeWay() ? 3 : 2;
    }

    protected void initialize() {
        this.handler = new SubscriberDiffTreeEventHandler(this.subscriber, this.manager, (ResourceDiffTree)this.getDiffTree());
        this.handler.setJobFamily(this);
        this.handler.start();
    }

    public void refresh(ResourceTraversal[] traversals, int flags, IProgressMonitor monitor) throws CoreException {
        this.subscriber.refresh(traversals, monitor);
    }

    public void dispose() {
        this.handler.shutdown();
        super.dispose();
    }

    protected SyncInfo getSyncInfo(IResource resource) throws CoreException {
        return this.handler.getSubscriber().getSyncInfo(resource);
    }

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    protected void runInBackground(IWorkspaceRunnable runnable) {
        this.handler.run(runnable, false);
    }
}

