/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.core.subscribers.ChangeSet;

public abstract class DiffChangeSet
extends ChangeSet {
    private final ResourceDiffTree tree = new ResourceDiffTree();

    public DiffChangeSet() {
    }

    public DiffChangeSet(String name) {
        super(name);
    }

    public IResourceDiffTree getDiffTree() {
        return this.tree;
    }

    protected ResourceDiffTree internalGetDiffTree() {
        return this.tree;
    }

    public IResource[] getResources() {
        return this.tree.getAffectedResources();
    }

    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    public boolean contains(IResource local) {
        return this.tree.getDiff(local) != null;
    }

    public void add(IDiff diff) {
        if (this.isValidChange(diff)) {
            this.tree.add(diff);
        }
    }

    protected boolean isValidChange(IDiff diff) {
        return diff != null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(IDiff[] diffs) {
        try {
            this.tree.beginInput();
            int i = 0;
            while (i < diffs.length) {
                IDiff diff = diffs[i];
                this.add(diff);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.tree.endInput(null);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.tree.endInput(null);
    }

    public void remove(IResource resource) {
        if (this.contains(resource)) {
            this.tree.remove(resource);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rootRemoved(IResource resource, int depth) {
        IDiff[] diffs = this.tree.getDiffs(resource, depth);
        if (diffs.length <= 0) return;
        try {
            this.tree.beginInput();
            int i = 0;
            while (i < diffs.length) {
                IDiff diff = diffs[i];
                IResource r = this.tree.getResource(diff);
                if (r != null) {
                    this.tree.remove(r);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.tree.endInput(null);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.tree.endInput(null);
    }

    public boolean contains(IPath path) {
        return this.getDiffTree().getDiff(path) != null;
    }
}

