/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class HashtableOfInt {
    private int[] keyTable;
    private int[] valueTable;
    private static final float GROWTH_FACTOR = 1.33f;
    private int elementSize = 0;
    private int threshold;

    public HashtableOfInt() {
        this(13);
    }

    public HashtableOfInt(int size) {
        this.threshold = size;
        int extraRoom = (int)((float)size * 1.33f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        this.keyTable = new int[extraRoom];
        this.valueTable = new int[extraRoom];
    }

    public boolean containsKey(int key) {
        int currentKey;
        int index = key % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != 0) {
            if (currentKey == key) {
                return true;
            }
            index = (index + 1) % this.keyTable.length;
        }
        return false;
    }

    public int get(int key) {
        int currentKey;
        int index = key % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != 0) {
            if (currentKey == key) {
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        return Integer.MIN_VALUE;
    }

    public int removeKey(int key) {
        int currentKey;
        int index = key % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != 0) {
            if (currentKey == key) {
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        return Integer.MIN_VALUE;
    }

    public int put(int key, int value) {
        int currentKey;
        int index = key % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != 0) {
            if (currentKey == key) {
                this.valueTable[index] = value;
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return value;
    }

    private void rehash() {
        HashtableOfInt newHashtable = new HashtableOfInt((int)((float)this.elementSize * 1.33f));
        int i = this.keyTable.length;
        while (--i >= 0) {
            int currentKey = this.keyTable[i];
            if (currentKey == 0) continue;
            newHashtable.put(currentKey, this.valueTable[i]);
        }
        this.keyTable = newHashtable.keyTable;
        this.valueTable = newHashtable.valueTable;
        this.threshold = newHashtable.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String s = "";
        int i = 0;
        int length = this.valueTable.length;
        while (i < length) {
            int object = this.valueTable[i];
            if (object != Integer.MIN_VALUE) {
                s = String.valueOf(s) + this.keyTable[i] + " -> " + object + "\n";
            }
            ++i;
        }
        return s;
    }

    public void save(DataOutputStream out) throws IOException {
        out.writeInt(this.elementSize);
        int tableSize = this.keyTable.length;
        out.writeInt(tableSize);
        out.writeInt(this.threshold);
        out.write(this.IntToByte(this.keyTable));
        out.write(this.IntToByte(this.valueTable));
    }

    public void load(DataInputStream in) throws IOException {
        this.elementSize = in.readInt();
        int tableSize = in.readInt();
        this.threshold = in.readInt();
        byte[] inBuffer = new byte[tableSize * 4];
        in.readFully(inBuffer);
        this.keyTable = this.ByteToInt(inBuffer);
        in.readFully(inBuffer);
        this.valueTable = this.ByteToInt(inBuffer);
    }

    private byte[] IntToByte(int[] intArray) {
        int intSize = intArray.length;
        byte[] byteArray = new byte[4 * intSize];
        int bytePos = 0;
        int i = 0;
        while (i < intSize) {
            int intValue = intArray[i];
            byteArray[bytePos] = (byte)(intValue & 0xFF);
            byteArray[bytePos + 1] = (byte)(intValue >>> 8 & 0xFF);
            byteArray[bytePos + 2] = (byte)(intValue >>> 16 & 0xFF);
            byteArray[bytePos + 3] = (byte)(intValue >>> 24 & 0xFF);
            bytePos += 4;
            ++i;
        }
        return byteArray;
    }

    private int[] ByteToInt(byte[] byteArray) {
        int intSize = byteArray.length / 4;
        int[] intArray = new int[intSize];
        int bytePos = 0;
        int intPos = 0;
        while (intPos < intSize) {
            int result = byteArray[bytePos] & 0xFF;
            result |= (byteArray[bytePos + 1] & 0xFF) << 8;
            result |= (byteArray[bytePos + 2] & 0xFF) << 16;
            intArray[intPos] = result |= (byteArray[bytePos + 3] & 0xFF) << 24;
            bytePos += 4;
            ++intPos;
        }
        return intArray;
    }
}

