/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.actions.CommonActionProviderDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentRegistryReader;
import org.eclipse.ui.navigator.INavigatorContentService;

public class CommonActionDescriptorManager {
    private static final CommonActionProviderDescriptor[] NO_DESCRIPTORS = new CommonActionProviderDescriptor[0];
    private static final CommonActionDescriptorManager INSTANCE = new CommonActionDescriptorManager();
    private final Map dependentDescriptors = new HashMap();
    private final Map rootDescriptors = new HashMap();

    private CommonActionDescriptorManager() {
        new ActionProviderRegistry().readRegistry();
    }

    public static CommonActionDescriptorManager getInstance() {
        return INSTANCE;
    }

    protected void addActionDescriptor(CommonActionProviderDescriptor aDescriptor) {
        if (this.rootDescriptors.containsKey(aDescriptor.getId()) || this.dependentDescriptors.containsKey(aDescriptor.getId())) {
            NavigatorPlugin.logError(0, "The id \"" + aDescriptor.getId() + "\" is used for two different actionProviders", null);
            return;
        }
        if (aDescriptor.getDependsOnId() == null) {
            this.rootDescriptors.put(aDescriptor.getId(), aDescriptor);
        } else {
            this.dependentDescriptors.put(aDescriptor.getId(), aDescriptor);
        }
    }

    protected void computeOrdering() {
        ArrayList unresolvedDependentDescriptors = new ArrayList(this.dependentDescriptors.values());
        Iterator iter = this.dependentDescriptors.values().iterator();
        while (iter.hasNext()) {
            CommonActionProviderDescriptor dependentDescriptor = (CommonActionProviderDescriptor)iter.next();
            CommonActionProviderDescriptor requiredDescriptor = (CommonActionProviderDescriptor)this.rootDescriptors.get(dependentDescriptor.getDependsOnId());
            if (requiredDescriptor == null) {
                requiredDescriptor = (CommonActionProviderDescriptor)this.dependentDescriptors.get(dependentDescriptor.getDependsOnId());
            }
            if (requiredDescriptor == null) continue;
            requiredDescriptor.addDependentDescriptor(dependentDescriptor);
            unresolvedDependentDescriptors.remove(dependentDescriptor);
        }
        this.dependentDescriptors.clear();
        if (!unresolvedDependentDescriptors.isEmpty()) {
            StringBuffer errorMessage = new StringBuffer("There were unresolved dependencies for action provider extensions to a Common Navigator.\nVerify that the \"dependsOn\" attribute for each <actionProvider /> element is valid.");
            CommonActionProviderDescriptor[] unresolvedDescriptors = unresolvedDependentDescriptors.toArray(new CommonActionProviderDescriptor[unresolvedDependentDescriptors.size()]);
            int i = 0;
            while (i < unresolvedDescriptors.length) {
                errorMessage.append("\nUnresolved dependency specified for actionProvider: ").append(unresolvedDescriptors[i].getId());
                ++i;
            }
            NavigatorPlugin.log(2, 0, errorMessage.toString(), null);
        }
        unresolvedDependentDescriptors.clear();
    }

    public CommonActionProviderDescriptor[] findRelevantActionDescriptors(INavigatorContentService aContentService, ActionContext aContext) {
        Object structuredSelection = null;
        structuredSelection = aContext.getSelection() instanceof IStructuredSelection ? (IStructuredSelection)aContext.getSelection() : StructuredSelection.EMPTY;
        CommonActionProviderDescriptor actionDescriptor = null;
        ArrayList providers = new ArrayList();
        Iterator providerItr = this.rootDescriptors.values().iterator();
        while (providerItr.hasNext()) {
            actionDescriptor = (CommonActionProviderDescriptor)providerItr.next();
            this.addProviderIfRelevant(aContentService, (IStructuredSelection)structuredSelection, actionDescriptor, providers);
        }
        if (providers.size() > 0) {
            return providers.toArray(new CommonActionProviderDescriptor[providers.size()]);
        }
        return NO_DESCRIPTORS;
    }

    private void addProviderIfRelevant(INavigatorContentService aContentService, IStructuredSelection structuredSelection, CommonActionProviderDescriptor actionDescriptor, List providers) {
        if (this.isVisible(aContentService, actionDescriptor) && actionDescriptor.isEnabledFor(structuredSelection)) {
            providers.add(actionDescriptor);
            if (actionDescriptor.hasDependentDescriptors()) {
                Iterator iter = actionDescriptor.dependentDescriptors();
                while (iter.hasNext()) {
                    this.addProviderIfRelevant(aContentService, structuredSelection, (CommonActionProviderDescriptor)iter.next(), providers);
                }
            }
        }
    }

    private boolean isVisible(INavigatorContentService aContentService, CommonActionProviderDescriptor descriptor) {
        if (descriptor.isNested()) {
            return aContentService.isActive(descriptor.getId()) && aContentService.isVisible(descriptor.getId());
        }
        return aContentService.getViewerDescriptor().isVisibleActionExtension(descriptor.getId());
    }

    private class ActionProviderRegistry
    extends NavigatorContentRegistryReader {
        ActionProviderRegistry() {
        }

        public void readRegistry() {
            super.readRegistry();
            CommonActionDescriptorManager.this.computeOrdering();
        }

        protected boolean readElement(IConfigurationElement anElement) {
            if ("actionProvider".equals(anElement.getName())) {
                CommonActionDescriptorManager.this.addActionDescriptor(new CommonActionProviderDescriptor(anElement));
                return true;
            }
            if ("navigatorContent".equals(anElement.getName())) {
                IConfigurationElement[] actionProviders = anElement.getChildren("actionProvider");
                if (actionProviders.length == 0) {
                    return true;
                }
                IConfigurationElement defaultEnablement = null;
                IConfigurationElement[] enablement = anElement.getChildren("enablement");
                if (enablement.length == 0) {
                    enablement = anElement.getChildren("possibleChildren");
                }
                if (enablement.length == 1) {
                    defaultEnablement = enablement[0];
                }
                int i = 0;
                while (i < actionProviders.length) {
                    CommonActionDescriptorManager.this.addActionDescriptor(new CommonActionProviderDescriptor(actionProviders[i], defaultEnablement, anElement.getAttribute("id"), true));
                    ++i;
                }
                return true;
            }
            return super.readElement(anElement);
        }
    }
}

