/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.LinkHelperDescriptor;
import org.eclipse.ui.internal.navigator.extensions.RegistryReader;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;

public class LinkHelperRegistry
extends RegistryReader {
    private static final ILinkHelper[] NO_LINK_HELPERS = new ILinkHelper[0];
    private List descriptors;
    private INavigatorContentService contentService;

    public LinkHelperRegistry(INavigatorContentService aContentService) {
        super(NavigatorPlugin.PLUGIN_ID, "linkHelper");
        this.contentService = aContentService;
    }

    public ILinkHelper[] getLinkHelpersFor(IStructuredSelection aSelection) {
        if (aSelection.isEmpty()) {
            return NO_LINK_HELPERS;
        }
        Set contentDescriptors = this.contentService.findContentExtensionsWithPossibleChild(aSelection.getFirstElement());
        if (contentDescriptors.isEmpty()) {
            return NO_LINK_HELPERS;
        }
        INavigatorContentExtension contentExtension = (INavigatorContentExtension)contentDescriptors.iterator().next();
        ArrayList<ILinkHelper> helpersList = new ArrayList<ILinkHelper>();
        ILinkHelper[] helpers = NO_LINK_HELPERS;
        LinkHelperDescriptor descriptor = null;
        Iterator itr = this.getDescriptors().iterator();
        while (itr.hasNext()) {
            descriptor = (LinkHelperDescriptor)itr.next();
            if (descriptor.isEnabledFor(contentExtension.getId())) {
                helpersList.add(descriptor.getLinkHelper());
                continue;
            }
            if (!descriptor.isEnabledFor(aSelection)) continue;
            helpersList.add(descriptor.getLinkHelper());
        }
        if (helpersList.size() > 0) {
            helpers = new ILinkHelper[helpersList.size()];
            helpersList.toArray(helpers);
        }
        return helpers;
    }

    public ILinkHelper[] getLinkHelpersFor(IEditorInput input) {
        ArrayList<ILinkHelper> helpersList = new ArrayList<ILinkHelper>();
        ILinkHelper[] helpers = new ILinkHelper[]{};
        LinkHelperDescriptor descriptor = null;
        Iterator itr = this.getDescriptors().iterator();
        while (itr.hasNext()) {
            descriptor = (LinkHelperDescriptor)itr.next();
            if (!descriptor.isEnabledFor(input)) continue;
            helpersList.add(descriptor.getLinkHelper());
        }
        if (helpersList.size() > 0) {
            helpers = new ILinkHelper[helpersList.size()];
            helpersList.toArray(helpers);
        }
        return helpers;
    }

    public boolean readElement(IConfigurationElement element) {
        if ("linkHelper".equals(element.getName())) {
            this.getDescriptors().add(new LinkHelperDescriptor(element));
            return true;
        }
        return false;
    }

    protected List getDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new ArrayList();
        }
        return this.descriptors;
    }
}

