/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import java.util.Set;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreePathViewerSorter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorSorterService;

public final class CommonViewerSorter
extends TreePathViewerSorter {
    private NavigatorContentService contentService;
    private INavigatorSorterService sorterService;

    protected void setContentService(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.sorterService = this.contentService.getSorterService();
    }

    public int category(Object element) {
        if (this.contentService == null) {
            return 0;
        }
        NavigatorContentDescriptor source = this.contentService.getSourceOfContribution(element);
        return source != null ? source.getPriority() : 3;
    }

    public int compare(Viewer viewer, TreePath parentPath, Object e1, Object e2) {
        Object parent;
        ViewerSorter sorter;
        if (this.contentService == null) {
            return -1;
        }
        INavigatorContentDescriptor sourceOfLvalue = this.getSource(e1);
        INavigatorContentDescriptor sourceOfRvalue = this.getSource(e2);
        if (sourceOfLvalue != null && sourceOfLvalue == sourceOfRvalue && (sorter = this.sorterService.findSorter(sourceOfLvalue, parent = parentPath == null ? viewer.getInput() : parentPath.getLastSegment(), e1, e2)) != null) {
            return sorter.compare(viewer, e1, e2);
        }
        int categoryDelta = this.category(e1) - this.category(e2);
        if (categoryDelta == 0) {
            return super.compare(viewer, e1, e2);
        }
        return categoryDelta;
    }

    private INavigatorContentDescriptor getSource(Object o) {
        Set descriptors = this.contentService.findDescriptorsWithPossibleChild(o);
        if (descriptors != null && descriptors.size() > 0) {
            return (INavigatorContentDescriptor)descriptors.iterator().next();
        }
        return null;
    }
}

