/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.filehistory;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileHistory;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileHistoryProvider;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.core.LocalFileRevision;

public class CVSFileHistory
extends FileHistory {
    protected ICVSFile cvsFile;
    protected IFileRevision[] revisions;
    protected IFileRevision[] remoteRevisions;
    protected IFileRevision[] localRevisions;
    protected boolean includeLocalRevisions;
    protected boolean includeRemoteRevisions;
    protected boolean includesExists;
    protected boolean refetchRevisions;
    private int flag;

    public CVSFileHistory(ICVSFile file) {
        this.cvsFile = file;
        this.includeLocalRevisions = false;
        this.includeRemoteRevisions = true;
        this.refetchRevisions = true;
        this.flag = 0;
    }

    public CVSFileHistory(ICVSFile file, int flag) {
        this.cvsFile = file;
        this.includeLocalRevisions = false;
        this.includeRemoteRevisions = true;
        this.refetchRevisions = true;
        this.flag = flag;
    }

    public IFileRevision[] getFileRevisions() {
        if (this.revisions == null) {
            return new IFileRevision[0];
        }
        return this.revisions;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refresh(IProgressMonitor monitor) throws TeamException {
        if (!this.refetchRevisions) {
            this.arrangeRevisions();
            return;
        }
        monitor.beginTask(NLS.bind((String)CVSMessages.CVSFileHistory_0, (Object)this.cvsFile.getRepositoryRelativePath()), 300);
        try {
            try {
                block17: {
                    block15: {
                        entries = this.cvsFile.getLogEntries((IProgressMonitor)new SubProgressMonitor(monitor, 200));
                        if (this.flag != 1) break block15;
                        revisionNumber = this.cvsFile.getSyncInfo().getRevision();
                        i = 0;
                        while (i < entries.length) {
                            block16: {
                                if (!entries[i].getRevision().equals(revisionNumber)) break block16;
                                this.remoteRevisions = new IFileRevision[]{new CVSFileRevision(entries[i])};
                                this.revisions = new IFileRevision[1];
                                System.arraycopy(this.remoteRevisions, 0, this.revisions, 0, this.remoteRevisions.length);
                                ** GOTO lbl-1000
                            }
                            ++i;
                        }
                        ** GOTO lbl-1000
                    }
                    if (this.flag != 2) break block17;
                    tempTag = this.cvsFile.getSyncInfo().getTag();
                    entriesOfInterest = new ArrayList<ILogEntry>();
                    i = 0;
                    while (true) {
                        if (i >= entries.length) break;
                        tags = entries[i].getTags();
                        j = 0;
                        while (j < tags.length) {
                            if (tags[j].getType() == tempTag.getType()) {
                                if (tempTag.getType() == 1 && tempTag.getName().equals(tags[j].getName())) {
                                    entriesOfInterest.add(entries[i]);
                                    break;
                                }
                                entriesOfInterest.add(entries[i]);
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    this.remoteRevisions = new IFileRevision[entriesOfInterest.size()];
                    iter = entriesOfInterest.iterator();
                    i = 0;
                    while (true) {
                        block18: {
                            if (iter.hasNext()) break block18;
                            this.revisions = new IFileRevision[this.remoteRevisions.length];
                            System.arraycopy(this.remoteRevisions, 0, this.revisions, 0, this.remoteRevisions.length);
                            ** GOTO lbl-1000
                        }
                        this.remoteRevisions[i++] = new CVSFileRevision((ILogEntry)iter.next());
                    }
                }
                this.localRevisions = new IFileRevision[0];
                localResource = this.cvsFile.getIResource();
                this.includesExists = false;
                if (localResource != null && localResource instanceof IFile) {
                    localHistoryState = ((IFile)localResource).getHistory((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    this.localRevisions = this.convertToFileRevision(localHistoryState, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    this.includesExists = this.localRevisions.length > 0;
                }
                this.remoteRevisions = new IFileRevision[entries.length];
                i = 0;
                while (true) {
                    if (i >= entries.length) {
                        this.revisions = new IFileRevision[0];
                        this.arrangeRevisions();
                    }
                    this.remoteRevisions[i] = new CVSFileRevision(entries[i]);
                    ++i;
                }
            }
            catch (CoreException v0) {}
        }
        catch (Throwable var9_15) {
            var8_16 = null;
            monitor.done();
            throw var9_15;
        }
lbl-1000:
        // 5 sources

        {
            var8_17 = null;
            monitor.done();
            return;
        }
    }

    private void arrangeRevisions() {
        if (this.revisions != null) {
            if (this.includeLocalRevisions && this.includeRemoteRevisions) {
                this.revisions = new IFileRevision[this.remoteRevisions.length + this.localRevisions.length];
                System.arraycopy(this.remoteRevisions, 0, this.revisions, 0, this.remoteRevisions.length);
                System.arraycopy(this.localRevisions, 0, this.revisions, this.remoteRevisions.length, this.localRevisions.length);
            } else if (this.includeLocalRevisions) {
                this.revisions = new IFileRevision[this.localRevisions.length];
                System.arraycopy(this.localRevisions, 0, this.revisions, 0, this.localRevisions.length);
            } else if (this.includeRemoteRevisions) {
                this.revisions = new IFileRevision[this.remoteRevisions.length];
                System.arraycopy(this.remoteRevisions, 0, this.revisions, 0, this.remoteRevisions.length);
            }
        }
    }

    public IFileRevision getFileRevision(String id) {
        IFileRevision[] revisions = this.getFileRevisions();
        int i = 0;
        while (i < revisions.length) {
            if (revisions[i].getContentIdentifier().equals(id)) {
                return revisions[i];
            }
            ++i;
        }
        return null;
    }

    public IFileRevision[] getContributors(IFileRevision revision) {
        IFileRevision[] revisions = this.getFileRevisions();
        IFileRevision fileRevision = null;
        int i = 0;
        while (i < revisions.length) {
            if (((CVSFileRevision)revisions[i]).isPredecessorOf(revision)) {
                if (fileRevision == null) {
                    fileRevision = revisions[i];
                }
                if (revisions[i].getTimestamp() > fileRevision.getTimestamp()) {
                    fileRevision = revisions[i];
                }
            }
            ++i;
        }
        if (fileRevision == null) {
            return new IFileRevision[0];
        }
        return new IFileRevision[]{fileRevision};
    }

    public IFileRevision[] getTargets(IFileRevision revision) {
        IFileRevision[] revisions = this.getFileRevisions();
        ArrayList<IFileRevision> directDescendents = new ArrayList<IFileRevision>();
        int i = 0;
        while (i < revisions.length) {
            if (((CVSFileRevision)revisions[i]).isDescendentOf(revision)) {
                directDescendents.add(revisions[i]);
            }
            ++i;
        }
        return directDescendents.toArray(new IFileRevision[directDescendents.size()]);
    }

    private IFileRevision[] convertToFileRevision(IFileState[] localRevisions, IProgressMonitor monitor) {
        boolean modified = false;
        try {
            modified = this.cvsFile.isModified(monitor);
        }
        catch (CVSException cVSException) {}
        int arrayLength = 0;
        if (modified) {
            ++arrayLength;
        }
        IFileRevision[] fileRevisions = new IFileRevision[arrayLength += localRevisions.length];
        int i = 0;
        while (i < localRevisions.length) {
            IFileState localFileState = localRevisions[i];
            LocalFileRevision localRevision = new LocalFileRevision(localFileState);
            fileRevisions[i] = localRevision;
            ++i;
        }
        if (modified) {
            IFile localFile = (IFile)this.cvsFile.getIResource();
            LocalFileRevision currentFile = new LocalFileRevision(localFile);
            CVSFileHistoryProvider provider = new CVSFileHistoryProvider();
            currentFile.setBaseRevision(provider.getWorkspaceFileRevision((IResource)localFile));
            fileRevisions[localRevisions.length] = currentFile;
        }
        return fileRevisions;
    }

    public void includeLocalRevisions(boolean flag) {
        this.includeLocalRevisions = flag;
    }

    public boolean getIncludesExists() {
        return this.includesExists;
    }

    public void setRefetchRevisions(boolean refetch) {
        this.refetchRevisions = refetch;
    }

    public void includeRemoteRevisions(boolean flag) {
        this.includeRemoteRevisions = flag;
    }
}

