/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.filesystem;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;

public class CVSURI {
    private static final String SCHEME = "cvs";
    private final ICVSRepositoryLocation repository;
    private final IPath path;
    private final CVSTag tag;

    public static CVSURI fromUri(URI uri) {
        try {
            ICVSRepositoryLocation repository = CVSURI.getRepository(uri);
            IPath path = CVSURI.getPath(uri);
            CVSTag tag = CVSURI.getTag(uri);
            return new CVSURI(repository, path, tag);
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
            throw new IllegalArgumentException(NLS.bind((String)CVSMessages.CVSURI_InvalidURI, (Object[])new String[]{uri.toString(), e.getMessage()}));
        }
    }

    private static CVSTag getTag(URI uri) {
        String f = uri.getFragment();
        int i = f.indexOf(44);
        if (i == -1) {
            return CVSTag.DEFAULT;
        }
        f.substring(i + 1);
        return new CVSTag();
    }

    private static IPath getPath(URI uri) {
        String path = uri.getFragment();
        int i = path.indexOf(44);
        if (i != -1) {
            path = path.substring(0, i);
        }
        return new Path(path);
    }

    private static ICVSRepositoryLocation getRepository(URI uri) throws CVSException {
        String ssp = uri.getSchemeSpecificPart();
        if (!ssp.startsWith(":")) {
            ssp = ":" + ssp;
        }
        return CVSRepositoryLocation.fromString(ssp);
    }

    public CVSURI(ICVSRepositoryLocation repository, IPath path, CVSTag tag) {
        this.repository = repository;
        this.path = path;
        this.tag = tag;
    }

    public CVSURI append(String name) {
        return new CVSURI(this.repository, this.path.append(name), this.tag);
    }

    public CVSURI append(IPath childPath) {
        return new CVSURI(this.repository, this.path.append(childPath), this.tag);
    }

    public String getLastSegment() {
        return this.path.lastSegment();
    }

    public URI toURI() {
        try {
            String fragment = this.path.toString();
            if (this.tag != null && this.tag.getType() != 0) {
                fragment = String.valueOf(fragment) + "," + this.tag.getName();
            }
            return new URI(SCHEME, this.repository.getLocation(false), fragment);
        }
        catch (URISyntaxException e) {
            throw new Error(e.getMessage());
        }
    }

    public boolean isRepositoryRoot() {
        return this.path.segmentCount() == 0;
    }

    public CVSURI removeLastSegment() {
        return new CVSURI(this.repository, this.path.removeLastSegments(1), this.tag);
    }

    public ICVSRemoteFolder getParentFolder() {
        return this.removeLastSegment().toFolder();
    }

    public String getRepositoryName() {
        return this.repository.toString();
    }

    public CVSURI getProjectURI() {
        return new CVSURI(this.repository, this.path.uptoSegment(1), this.tag);
    }

    public ICVSRemoteFolder toFolder() {
        return new RemoteFolder(null, this.repository, this.path.toString(), this.tag);
    }

    public ICVSRemoteFile toFile() {
        return RemoteFile.create(this.path.toString(), this.repository);
    }

    public String toString() {
        return "[Path: " + this.path.toString() + " Tag: " + this.tag.getName() + " Repo: " + this.repository.getRootDirectory() + "]";
    }

    public IPath getPath() {
        return this.path;
    }

    public IPath getProjectStrippedPath() {
        if (this.path.segmentCount() > 1) {
            return this.path.removeFirstSegments(1);
        }
        return this.path;
    }
}

