/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.internal.content.Activator;
import org.eclipse.core.internal.content.ContentMessages;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ContentOSGiUtils {
    private ServiceTracker parserTracker = null;
    private ServiceTracker debugTracker = null;
    private static final ContentOSGiUtils singleton = new ContentOSGiUtils();
    static /* synthetic */ Class class$0;

    public static ContentOSGiUtils getDefault() {
        return singleton;
    }

    private ContentOSGiUtils() {
        this.initServices();
    }

    private void initServices() {
        BundleContext context = Activator.getContext();
        if (context == null) {
            ContentMessages.message("ContentOSGiUtils called before plugin started");
            return;
        }
        this.parserTracker = new ServiceTracker(context, "javax.xml.parsers.SAXParserFactory", null);
        this.parserTracker.open();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.debugTracker = new ServiceTracker(context, clazz.getName(), null);
        this.debugTracker.open();
    }

    void closeServices() {
        if (this.parserTracker != null) {
            this.parserTracker.close();
            this.parserTracker = null;
        }
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
    }

    public SAXParserFactory getFactory() {
        if (this.parserTracker == null) {
            ContentMessages.message("SAX tracker is not set");
            return null;
        }
        SAXParserFactory theFactory = (SAXParserFactory)this.parserTracker.getService();
        if (theFactory != null) {
            theFactory.setNamespaceAware(true);
        }
        return theFactory;
    }

    public boolean getBooleanDebugOption(String option, boolean defaultValue) {
        String value;
        if (this.debugTracker == null) {
            ContentMessages.message("Debug tracker is not set");
            return defaultValue;
        }
        DebugOptions options = (DebugOptions)this.debugTracker.getService();
        if (options != null && (value = options.getOption(option)) != null) {
            return value.equalsIgnoreCase("true");
        }
        return defaultValue;
    }
}

