/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JNLPGenerator
extends DefaultHandler {
    private SAXParser parser;
    private File featureRoot;
    private String codebase;
    private String j2se;
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private PrintWriter out;
    private String destination;
    private String provider;
    private String label;
    private String version;
    private String id;
    private String description;
    private boolean resourceWritten = false;
    private String currentOS = null;

    public static void main(String[] args) throws MalformedURLException {
        JNLPGenerator generator = new JNLPGenerator(args[0], args[1], args[2], args[3]);
        generator.process();
    }

    public JNLPGenerator(String feature, String destination, String codebase, String j2se) {
        this.featureRoot = new File(feature);
        this.destination = destination;
        this.codebase = codebase;
        this.j2se = j2se;
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            System.out.println(e);
        }
        catch (SAXException e) {
            System.out.println(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process() {
        InputStream in = null;
        try {
            Object var3_3;
            ZipFile featureArchive = null;
            if (this.featureRoot.isFile()) {
                featureArchive = new ZipFile(this.featureRoot);
                ZipEntry featureXML = featureArchive.getEntry("feature.xml");
                in = featureArchive.getInputStream(featureXML);
            } else {
                in = new FileInputStream(new File(this.featureRoot, "feature.xml"));
            }
            try {
                try {
                    this.parser.parse(new InputSource(in), (DefaultHandler)this);
                    this.writeResourceEpilogue();
                    this.writeEpilogue();
                }
                catch (SAXException sAXException) {}
            }
            catch (Throwable throwable) {
                var3_3 = null;
                in.close();
                if (this.out != null) {
                    this.out.close();
                }
                if (featureArchive == null) throw throwable;
                featureArchive.close();
                throw throwable;
            }
            {
                var3_3 = null;
                in.close();
                if (this.out != null) {
                    this.out.close();
                }
                if (featureArchive == null) return;
                featureArchive.close();
                return;
            }
        }
        catch (IOException iOException) {}
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if ("feature".equals(localName)) {
                this.processFeature(attributes);
            } else if ("includes".equals(localName)) {
                this.processIncludes(attributes);
            } else if ("description".equals(localName)) {
                this.processDescription(attributes);
            } else if ("plugin".equals(localName)) {
                this.processPlugin(attributes);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void processPlugin(Attributes attributes) throws IOException {
        this.writePrologue();
        String id = attributes.getValue("id");
        String version = attributes.getValue("version");
        String os = attributes.getValue("os");
        String ws = attributes.getValue("ws");
        this.writeResourcePrologue(os, ws);
        this.out.println("\t\t<jar href=\"plugins/" + id + "_" + version + ".jar\"/>");
    }

    private void writeResourceEpilogue() {
        if (!this.resourceWritten) {
            return;
        }
        this.out.println("\t</resources>");
        this.resourceWritten = false;
        this.currentOS = null;
    }

    private void writeResourcePrologue(String os, String ws) {
        if (os == null) {
            os = ws;
        }
        os = this.convertOS(os);
        if (this.resourceWritten && this.osMatch(os)) {
            return;
        }
        if (this.resourceWritten) {
            this.writeResourceEpilogue();
        }
        this.out.println("\t<resources" + (os == null ? "" : " os=\"" + os + "\"") + ">");
        this.resourceWritten = true;
        this.currentOS = os;
    }

    private String convertOS(String os) {
        if (os == null) {
            return null;
        }
        if ("win32".equalsIgnoreCase(os)) {
            return "Windows";
        }
        if ("macosx".equalsIgnoreCase(os)) {
            return "Mac";
        }
        if ("linux".equalsIgnoreCase(os)) {
            return "Linux";
        }
        if ("solaris".equalsIgnoreCase(os)) {
            return "Solaris";
        }
        if ("hpux".equalsIgnoreCase(os)) {
            return "HP-UX";
        }
        if ("aix".equalsIgnoreCase(os)) {
            return "AIX";
        }
        return os;
    }

    private boolean osMatch(String os) {
        if (os == this.currentOS) {
            return true;
        }
        if (os == null) {
            return false;
        }
        return os.equals(this.currentOS);
    }

    private void processDescription(Attributes attributes) {
    }

    private void processIncludes(Attributes attributes) throws IOException {
        this.writePrologue();
        String inclusionId = attributes.getValue("id");
        String inclusionVersion = attributes.getValue("version");
        String name = attributes.getValue("name");
        String os = attributes.getValue("os");
        String ws = attributes.getValue("ws");
        this.writeResourcePrologue(os, ws);
        this.out.print("\t\t<extension ");
        if (name != null) {
            this.out.print("name=\"" + name + "\" ");
        }
        if (inclusionId != null) {
            this.out.print("href=\"features/" + inclusionId);
            if (inclusionVersion != null) {
                this.out.print("_" + inclusionVersion);
            }
            this.out.print(".jnlp\" ");
        }
        this.out.println("/>");
    }

    private void processFeature(Attributes attributes) throws IOException {
        this.id = attributes.getValue("id");
        this.version = attributes.getValue("version");
        this.label = attributes.getValue("label");
        this.provider = attributes.getValue("provider-name");
    }

    private void writePrologue() throws IOException {
        if (this.out != null) {
            return;
        }
        if (this.destination == null) {
            this.featureRoot.getParentFile();
            this.destination = String.valueOf(this.featureRoot.getParent()) + '/';
        }
        if (this.destination.endsWith("/") || this.destination.endsWith("\\")) {
            this.destination = new File(this.featureRoot.getParentFile(), String.valueOf(this.id) + "_" + this.version + ".jnlp").getAbsolutePath();
        }
        this.out = new PrintWriter(new FileOutputStream(this.destination));
        this.writePrologue();
        this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.out.print("<jnlp spec=\"1.0+\" ");
        if (this.codebase != null) {
            this.out.print("codebase=\"" + this.codebase);
        }
        this.out.println("\">");
        this.out.println("\t<information>");
        if (this.label != null) {
            this.out.println("\t\t<title>" + this.label + "</title>");
        }
        if (this.provider != null) {
            this.out.println("\t\t<vendor>" + this.provider + "</vendor>");
        }
        if (this.description != null) {
            this.out.println("\t\t<description>" + this.description + "</description>");
        }
        this.out.println("\t\t<offline-allowed/>");
        this.out.println("\t</information>");
        this.out.println("\t<security>");
        this.out.println("\t\t<all-permissions/>");
        this.out.println("\t</security>");
        this.out.println("\t<component-desc/>");
        this.out.println("\t<resources>");
        this.out.println("\t\t<j2se version=\"" + this.j2se + "\" />");
        this.out.println("\t</resources>");
    }

    private void writeEpilogue() {
        this.out.println("</jnlp>");
    }
}

