/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.internal.preferences.InitLegacyPreferences;
import org.eclipse.core.internal.preferences.ProductPreferencesService;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.AdapterManagerListener;
import org.eclipse.core.internal.runtime.AuthorizationHandler;
import org.eclipse.core.internal.runtime.DataArea;
import org.eclipse.core.internal.runtime.Log;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.MetaDataKeeper;
import org.eclipse.core.internal.runtime.PlatformLogWriter;
import org.eclipse.core.internal.runtime.Product;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProductProvider;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public final class InternalPlatform {
    private static String[] allArgs = new String[0];
    private static String[] appArgs = new String[0];
    private static final String APPLICATION = "-application";
    private static final String[] ARCH_LIST = new String[]{"PA_RISC", "ppc", "sparc", "x86", "x86_64", "ia64", "ia64_32"};
    private static final String BOOT = "-boot";
    private static final String CLASSLOADER_PROPERTIES = "-classloaderProperties";
    public static boolean DEBUG = false;
    public static boolean DEBUG_PLUGIN_PREFERENCES = false;
    private static Runnable splashHandler = null;
    private static final String FEATURE = "-feature";
    private static final String FIRST_USE = "-firstUse";
    private static String[] frameworkArgs = new String[0];
    private static boolean initialized;
    private static final String KEY_DOUBLE_PREFIX = "%%";
    private static final String KEY_PREFIX = "%";
    private static final String KEYRING = "-keyring";
    private static String keyringFile;
    private static Map logs;
    private static final String NEW_UPDATES = "-newUpdates";
    private static final String NO_PACKAGE_PREFIXES = "-noPackagePrefixes";
    private static final String NO_UPDATE = "-noUpdate";
    private static final String[] OS_LIST;
    private static String password;
    private static final String PASSWORD = "-password";
    private static PlatformLogWriter platformLog;
    private static final String PLUGIN_PATH = ".plugin-path";
    private static final String PLUGINS = "-plugins";
    private static final String PRODUCT = "-product";
    public static final String PROP_ADAPTOR = "osgi.adaptor";
    public static final String PROP_APPLICATION = "eclipse.application";
    public static final String PROP_ARCH = "osgi.arch";
    public static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    public static final String PROP_CONSOLE = "osgi.console";
    public static final String PROP_CONSOLE_CLASS = "osgi.consoleClass";
    public static final String PROP_CONSOLE_LOG = "eclipse.consoleLog";
    public static final String PROP_DEBUG = "osgi.debug";
    public static final String PROP_DEV = "osgi.dev";
    public static final String PROP_EXITCODE = "eclipse.exitcode";
    public static final String PROP_INSTALL_AREA = "osgi.install.area";
    public static final String PROP_INSTANCE_AREA = "osgi.instance.area";
    public static final String PROP_MANIFEST_CACHE = "osgi.manifest.cache";
    public static final String PROP_NL = "osgi.nl";
    public static final String PROP_OS = "osgi.os";
    public static final String PROP_PRODUCT = "eclipse.product";
    public static final String PROP_SYSPATH = "osgi.syspath";
    public static final String PROP_USER_AREA = "osgi.user.area";
    public static final String PROP_WS = "osgi.ws";
    private static final InternalPlatform singleton;
    private static final String UPDATE = "-update";
    private static final String[] WS_LIST;
    private Path cachedInstanceLocation;
    private ServiceTracker configurationLocation = null;
    private BundleContext context;
    private Map groupProviders = new IdentityHashMap(3);
    private ServiceTracker installLocation = null;
    private ServiceTracker instanceLocation = null;
    private boolean missingProductReported = false;
    private IProduct product;
    private AdapterManagerListener adapterManagerListener = null;
    private String applicationId;
    private Properties commandLineProperties = new Properties();
    private Plugin runtimeInstance;
    private ServiceRegistration legacyPreferencesService = null;
    private ServiceRegistration customPreferencesService = null;
    private ServiceTracker environmentTracker = null;
    private ServiceTracker logTracker = null;
    private ServiceTracker bundleTracker = null;
    private ServiceTracker debugTracker = null;
    private ServiceTracker contentTracker = null;
    private ServiceTracker preferencesTracker = null;
    private ServiceTracker productTracker = null;
    private ServiceTracker userLocation = null;
    private ServiceTracker groupProviderTracker = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    static {
        logs = new HashMap(5);
        OS_LIST = new String[]{"aix", "hpux", "linux", "macosx", "qnx", "solaris", "win32"};
        password = "";
        platformLog = null;
        singleton = new InternalPlatform();
        WS_LIST = new String[]{"carbon", "gtk", "motif", "photon", "win32"};
    }

    public static InternalPlatform getDefault() {
        return singleton;
    }

    private InternalPlatform() {
    }

    public void addAuthorizationInfo(URL serverUrl, String realm, String authScheme, Map info) throws CoreException {
        AuthorizationHandler.addAuthorizationInfo(serverUrl, realm, authScheme, info);
    }

    public void addLogListener(ILogListener listener) {
        this.assertInitialized();
        RuntimeLog.addLogListener((ILogListener)listener);
    }

    public void addProtectionSpace(URL resourceUrl, String realm) throws CoreException {
        AuthorizationHandler.addProtectionSpace(resourceUrl, realm);
    }

    private void assertInitialized() {
        if (!initialized) {
            Assert.isTrue((boolean)false, (String)Messages.meta_appNotInit);
        }
    }

    public void endSplash() {
        final Runnable handler = splashHandler;
        if (handler == null) {
            return;
        }
        splashHandler = null;
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable e) {
            }

            public void run() throws Exception {
                handler.run();
            }
        });
    }

    public void flushAuthorizationInfo(URL serverUrl, String realm, String authScheme) throws CoreException {
        AuthorizationHandler.flushAuthorizationInfo(serverUrl, realm, authScheme);
    }

    public IAdapterManager getAdapterManager() {
        this.assertInitialized();
        return AdapterManager.getDefault();
    }

    public String[] getApplicationArgs() {
        return appArgs;
    }

    public String getApplicationId() {
        if (this.applicationId != null) {
            return this.applicationId;
        }
        this.applicationId = this.commandLineProperties.getProperty(PROP_APPLICATION);
        if (this.applicationId != null) {
            return this.applicationId;
        }
        this.applicationId = this.context.getProperty(PROP_APPLICATION);
        if (this.applicationId != null) {
            return this.applicationId;
        }
        IProduct eclipseProduct = this.getProduct();
        if (eclipseProduct != null) {
            this.applicationId = eclipseProduct.getApplication();
        }
        return this.applicationId;
    }

    public Map getAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        return AuthorizationHandler.getAuthorizationInfo(serverUrl, realm, authScheme);
    }

    public boolean getBooleanOption(String option, boolean defaultValue) {
        String value = this.getOption(option);
        if (value == null) {
            return defaultValue;
        }
        return value.equalsIgnoreCase("true");
    }

    public Bundle getBundle(String symbolicName) {
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public String getBundleId(Object object) {
        if (object == null) {
            return null;
        }
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        Bundle source = packageAdmin.getBundle(object.getClass());
        if (source != null && source.getSymbolicName() != null) {
            return source.getSymbolicName();
        }
        return null;
    }

    public IBundleGroupProvider[] getBundleGroupProviders() {
        Object[] objectArray;
        if (this.groupProviderTracker == null) {
            Filter filter = null;
            try {
                BundleContext bundleContext = this.getBundleContext();
                StringBuffer stringBuffer = new StringBuffer("(objectClass=");
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.runtime.IBundleGroupProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                filter = bundleContext.createFilter(stringBuffer.append(clazz.getName()).append(")").toString());
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.groupProviderTracker = new ServiceTracker(this.getBundleContext(), filter, null);
            this.groupProviderTracker.open();
        }
        if ((objectArray = this.groupProviderTracker.getServices()) == null) {
            return new IBundleGroupProvider[0];
        }
        IBundleGroupProvider[] result = new IBundleGroupProvider[objectArray.length];
        System.arraycopy(objectArray, 0, result, 0, objectArray.length);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBundleGroupProvider(IBundleGroupProvider provider) {
        BundleContext bundleContext = this.getBundleContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.IBundleGroupProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceRegistration registration = bundleContext.registerService(clazz.getName(), (Object)provider, null);
        Map map = this.groupProviders;
        synchronized (map) {
            this.groupProviders.put(provider, registration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBundleGroupProvider(IBundleGroupProvider provider) {
        ServiceRegistration registration;
        Map map = this.groupProviders;
        synchronized (map) {
            registration = (ServiceRegistration)this.groupProviders.remove(provider);
        }
        if (registration == null) {
            return;
        }
        registration.unregister();
    }

    public Bundle[] getBundles(String symbolicName, String version) {
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, version);
        if (bundles == null) {
            return null;
        }
        if (bundles.length == 1 && (bundles[0].getState() & 3) == 0) {
            return bundles;
        }
        Bundle[] selectedBundles = new Bundle[bundles.length];
        int added = 0;
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                selectedBundles[added++] = bundles[i];
            }
            ++i;
        }
        if (added == 0) {
            return null;
        }
        Bundle[] results = new Bundle[added];
        System.arraycopy(selectedBundles, 0, results, 0, added);
        return results;
    }

    public String[] getCommandLineArgs() {
        return allArgs;
    }

    public Location getConfigurationLocation() {
        this.assertInitialized();
        return (Location)this.configurationLocation.getService();
    }

    public IContentTypeManager getContentTypeManager() {
        if (this.contentTracker == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.runtime.content.IContentTypeManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.contentTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.contentTracker.open();
        }
        return (IContentTypeManager)this.contentTracker.getService();
    }

    public EnvironmentInfo getEnvironmentInfoService() {
        if (this.environmentTracker == null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.environmentTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.environmentTracker.open();
        }
        return (EnvironmentInfo)this.environmentTracker.getService();
    }

    public Bundle[] getFragments(Bundle bundle) {
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        return packageAdmin.getFragments(bundle);
    }

    public FrameworkLog getFrameworkLog() {
        if (this.logTracker == null) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.logTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.logTracker.open();
        }
        return (FrameworkLog)this.logTracker.getService();
    }

    public Bundle[] getHosts(Bundle bundle) {
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        return packageAdmin.getHosts(bundle);
    }

    public Location getInstallLocation() {
        this.assertInitialized();
        return (Location)this.installLocation.getService();
    }

    public URL getInstallURL() {
        Location location = this.getInstallLocation();
        if (location == null) {
            throw new IllegalStateException("The installation location must not be null");
        }
        return location.getURL();
    }

    public Location getInstanceLocation() {
        this.assertInitialized();
        return (Location)this.instanceLocation.getService();
    }

    public int getIntegerOption(String option, int defaultValue) {
        String value = this.getOption(option);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public IPath getLocation() throws IllegalStateException {
        if (this.cachedInstanceLocation == null) {
            Location location = this.getInstanceLocation();
            if (location == null) {
                return null;
            }
            File file = new File(location.getURL().getFile());
            this.cachedInstanceLocation = new Path(file.toString());
        }
        return this.cachedInstanceLocation;
    }

    public ILog getLog(Bundle bundle) {
        ILog result = (ILog)logs.get(bundle);
        if (result != null) {
            return result;
        }
        result = new Log(bundle);
        logs.put(bundle, result);
        return result;
    }

    public IPath getLogFileLocation() {
        return this.getMetaArea().getLogLocation();
    }

    public DataArea getMetaArea() {
        return MetaDataKeeper.getMetaArea();
    }

    public String getNL() {
        return this.getBundleContext().getProperty(PROP_NL);
    }

    public String getOption(String option) {
        DebugOptions options = this.getDebugOptions();
        if (options != null) {
            return options.getOption(option);
        }
        return null;
    }

    public String getOS() {
        return this.getBundleContext().getProperty(PROP_OS);
    }

    public String getOSArch() {
        return this.getBundleContext().getProperty(PROP_ARCH);
    }

    public PlatformAdmin getPlatformAdmin() {
        ServiceReference platformAdminReference;
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((platformAdminReference = this.context.getServiceReference(clazz.getName())) == null) {
            return null;
        }
        return (PlatformAdmin)this.context.getService(platformAdminReference);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL[] getPluginPath(URL pluginPathLocation) {
        InputStream input = null;
        if (pluginPathLocation == null) {
            return null;
        }
        try {
            input = pluginPathLocation.openStream();
        }
        catch (IOException iOException) {}
        if (input == null) {
            try {
                URL url = new URL("platform:/base/.plugin-path");
                input = url.openStream();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        if (input == null) {
            return null;
        }
        URL[] result = null;
        try {
            try {
                result = this.readPluginPath(input);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                input.close();
                throw throwable;
            }
            {
                Object var4_6 = null;
                input.close();
                return result;
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public IPreferencesService getPreferencesService() {
        if (this.preferencesTracker == null) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("org.eclipse.core.runtime.preferences.IPreferencesService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.preferencesTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.preferencesTracker.open();
        }
        return (IPreferencesService)this.preferencesTracker.getService();
    }

    public Properties getPreferenceTranslator(String uniqueIdentifier, String basePrefFileName) {
        return new Properties();
    }

    public IProduct getProduct() {
        if (this.product != null) {
            return this.product;
        }
        String productId = this.commandLineProperties.getProperty(PROP_PRODUCT);
        if (productId == null && (productId = this.context.getProperty(PROP_PRODUCT)) == null) {
            return null;
        }
        IConfigurationElement[] entries = InternalPlatform.getDefault().getRegistry().getConfigurationElementsFor("org.eclipse.core.runtime", "products", productId);
        if (entries.length > 0) {
            this.product = new Product(productId, entries[0]);
            return this.product;
        }
        IConfigurationElement[] elements = InternalPlatform.getDefault().getRegistry().getConfigurationElementsFor("org.eclipse.core.runtime", "products");
        ArrayList<FrameworkLogEntry> logEntries = null;
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equalsIgnoreCase("provider")) {
                try {
                    IProductProvider provider = (IProductProvider)element.createExecutableExtension("run");
                    IProduct[] products = provider.getProducts();
                    int j = 0;
                    while (j < products.length) {
                        IProduct provided = products[j];
                        if (provided.getId().equalsIgnoreCase(productId)) {
                            this.product = provided;
                            return this.product;
                        }
                        ++j;
                    }
                }
                catch (CoreException e) {
                    if (logEntries == null) {
                        logEntries = new ArrayList<FrameworkLogEntry>(3);
                    }
                    logEntries.add(new FrameworkLogEntry("org.eclipse.core.runtime", NLS.bind((String)Messages.provider_invalid, (Object)element.getParent().toString()), 0, (Throwable)e, null));
                }
            }
            ++i;
        }
        if (logEntries != null) {
            InternalPlatform.getDefault().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.core.runtime", Messages.provider_invalid_general, 0, null, (FrameworkLogEntry[])logEntries.toArray()));
        }
        if (!this.missingProductReported) {
            InternalPlatform.getDefault().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.core.runtime", NLS.bind((String)Messages.product_notFound, (Object)productId), 0, null, null));
            this.missingProductReported = true;
        }
        return null;
    }

    public String getProtectionSpace(URL resourceUrl) {
        return AuthorizationHandler.getProtectionSpace(resourceUrl);
    }

    public IExtensionRegistry getRegistry() {
        return RegistryFactory.getRegistry();
    }

    public ResourceBundle getResourceBundle(Bundle bundle) {
        return ResourceTranslator.getResourceBundle((Bundle)bundle);
    }

    public String getResourceString(Bundle bundle, String value) {
        return ResourceTranslator.getResourceString((Bundle)bundle, (String)value);
    }

    public String getResourceString(Bundle bundle, String value, ResourceBundle resourceBundle) {
        return ResourceTranslator.getResourceString((Bundle)bundle, (String)value, (ResourceBundle)resourceBundle);
    }

    public Plugin getRuntimeInstance() {
        return this.runtimeInstance;
    }

    private Runnable getSplashHandler() {
        ServiceReference[] ref;
        try {
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("java.lang.Runnable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ref = this.context.getServiceReferences(clazz.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
        int i = 0;
        while (i < ref.length) {
            String name = (String)ref[i].getProperty("name");
            if (name != null && name.equals("splashscreen")) {
                Runnable result = (Runnable)this.context.getService(ref[i]);
                this.context.ungetService(ref[i]);
                return result;
            }
            ++i;
        }
        return null;
    }

    public IPath getStateLocation(Bundle bundle) {
        return this.getStateLocation(bundle, true);
    }

    public IPath getStateLocation(Bundle bundle, boolean create) throws IllegalStateException {
        this.assertInitialized();
        IPath result = this.getMetaArea().getStateLocation(bundle);
        if (create) {
            result.toFile().mkdirs();
        }
        return result;
    }

    public long getStateTimeStamp() {
        PlatformAdmin admin = this.getPlatformAdmin();
        return admin == null ? -1L : admin.getState(false).getTimeStamp();
    }

    public Location getUserLocation() {
        this.assertInitialized();
        return (Location)this.userLocation.getService();
    }

    public String getWS() {
        return this.getBundleContext().getProperty(PROP_WS);
    }

    public boolean hasLogWriter() {
        return platformLog != null && RuntimeLog.contains((ILogListener)platformLog);
    }

    private void initializeAuthorizationHandler() {
        AuthorizationHandler.setKeyringFile(keyringFile);
        AuthorizationHandler.setPassword(password);
    }

    void initializeDebugFlags() {
        DEBUG = this.getBooleanOption("org.eclipse.core.runtime/debug", false);
        if (DEBUG) {
            DEBUG_PLUGIN_PREFERENCES = this.getBooleanOption("org.eclipse.core.runtime/preferences/plugin", false);
        }
    }

    private void initializeLocationTrackers() {
        Filter filter = null;
        try {
            filter = this.context.createFilter(Location.CONFIGURATION_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.configurationLocation = new ServiceTracker(this.context, filter, null);
        this.configurationLocation.open();
        try {
            filter = this.context.createFilter(Location.USER_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.userLocation = new ServiceTracker(this.context, filter, null);
        this.userLocation.open();
        try {
            filter = this.context.createFilter(Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.instanceLocation = new ServiceTracker(this.context, filter, null);
        this.instanceLocation.open();
        try {
            filter = this.context.createFilter(Location.INSTALL_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.installLocation = new ServiceTracker(this.context, filter, null);
        this.installLocation.open();
    }

    public boolean isFragment(Bundle bundle) {
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return false;
        }
        return (packageAdmin.getBundleType(bundle) & 1) > 0;
    }

    public boolean isRunning() {
        try {
            return initialized && this.context.getBundle().getState() == 32;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    public String[] knownOSArchValues() {
        return ARCH_LIST;
    }

    public String[] knownOSValues() {
        return OS_LIST;
    }

    public String[] knownWSValues() {
        return WS_LIST;
    }

    public void log(IStatus status) {
        RuntimeLog.log((IStatus)status);
    }

    private String[] processCommandLine(String[] args) {
        if (args == null) {
            return args;
        }
        allArgs = args;
        if (args.length == 0) {
            return args;
        }
        int[] configArgs = new int[args.length];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args.length) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(CLASSLOADER_PROPERTIES)) {
                found = true;
            }
            if (args[i].equalsIgnoreCase(NO_PACKAGE_PREFIXES)) {
                found = true;
            }
            if (args[i].equalsIgnoreCase(PLUGINS)) {
                found = true;
            }
            if (args[i].equalsIgnoreCase(FIRST_USE)) {
                found = true;
            }
            if (args[i].equalsIgnoreCase(NO_UPDATE)) {
                found = true;
            }
            if (args[i].equalsIgnoreCase(NEW_UPDATES)) {
                found = true;
            }
            if (args[i].equalsIgnoreCase(UPDATE)) {
                found = true;
            }
            if (found) {
                configArgs[configArgIndex++] = i;
            } else if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(KEYRING)) {
                    keyringFile = arg;
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(PASSWORD)) {
                    password = arg;
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(PRODUCT) || args[i - 1].equalsIgnoreCase(FEATURE)) {
                    this.commandLineProperties.setProperty(PROP_PRODUCT, arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(APPLICATION)) {
                    this.commandLineProperties.setProperty(PROP_APPLICATION, arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(CLASSLOADER_PROPERTIES)) {
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(BOOT)) {
                    found = true;
                }
                if (found) {
                    configArgs[configArgIndex++] = i - 1;
                    configArgs[configArgIndex++] = i;
                }
            }
            ++i;
        }
        if (configArgIndex == 0) {
            appArgs = args;
            return args;
        }
        appArgs = new String[args.length - configArgIndex];
        frameworkArgs = new String[configArgIndex];
        configArgIndex = 0;
        int j = 0;
        int k = 0;
        int i2 = 0;
        while (i2 < args.length) {
            if (i2 == configArgs[configArgIndex]) {
                InternalPlatform.frameworkArgs[k++] = args[i2];
                ++configArgIndex;
            } else {
                InternalPlatform.appArgs[j++] = args[i2];
            }
            ++i2;
        }
        return appArgs;
    }

    private URL[] readPluginPath(InputStream input) {
        Properties ini = new Properties();
        try {
            ini.load(input);
        }
        catch (IOException iOException) {
            return null;
        }
        Vector<URL> result = new Vector<URL>(5);
        Enumeration<?> groups = ini.propertyNames();
        while (groups.hasMoreElements()) {
            String group = (String)groups.nextElement();
            StringTokenizer entries = new StringTokenizer(ini.getProperty(group), ";");
            while (entries.hasMoreElements()) {
                String entry = (String)entries.nextElement();
                if (entry.equals("")) continue;
                try {
                    result.addElement(new URL(entry));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("Ignoring plugin: " + entry);
                }
            }
        }
        return result.toArray(new URL[result.size()]);
    }

    public void removeLogListener(ILogListener listener) {
        this.assertInitialized();
        RuntimeLog.removeLogListener((ILogListener)listener);
    }

    public void setOption(String option, String value) {
        DebugOptions options = this.getDebugOptions();
        if (options != null) {
            options.setOption(option, value);
        }
    }

    public void setRuntimeInstance(Plugin runtime) {
        this.runtimeInstance = runtime;
    }

    public void start(BundleContext runtimeContext) {
        this.context = runtimeContext;
        this.initializeLocationTrackers();
        splashHandler = this.getSplashHandler();
        this.processCommandLine(this.getEnvironmentInfoService().getNonFrameworkArgs());
        this.initializeDebugFlags();
        initialized = true;
        this.getMetaArea();
        this.initializeAuthorizationHandler();
        platformLog = new PlatformLogWriter(this.getFrameworkLog());
        this.addLogListener(platformLog);
        this.adapterManagerListener = new AdapterManagerListener();
        this.startServices();
    }

    public void stop(BundleContext bundleContext) {
        this.assertInitialized();
        this.stopServices();
        if (this.adapterManagerListener != null) {
            this.adapterManagerListener.stop();
        }
        RuntimeLog.removeLogListener((ILogListener)platformLog);
        initialized = false;
        this.closeOSGITrackers();
        this.context = null;
    }

    public String translatePreference(String value, Properties props) {
        value = value.trim();
        if (props == null || value.startsWith(KEY_DOUBLE_PREFIX)) {
            return value;
        }
        if (value.startsWith(KEY_PREFIX)) {
            int ix = value.indexOf(" ");
            String key = ix == -1 ? value : value.substring(0, ix);
            String dflt = ix == -1 ? value : value.substring(ix + 1);
            return props.getProperty(key.substring(1), dflt);
        }
        return value;
    }

    private void startServices() {
        BundleContext bundleContext = this.getBundleContext();
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("org.eclipse.core.runtime.preferences.IProductPreferencesService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.customPreferencesService = bundleContext.registerService(clazz.getName(), (Object)new ProductPreferencesService(), new Hashtable());
        BundleContext bundleContext2 = this.getBundleContext();
        Class<?> clazz2 = class$8;
        if (clazz2 == null) {
            try {
                clazz2 = class$8 = Class.forName("org.eclipse.core.internal.preferences.ILegacyPreferences");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.legacyPreferencesService = bundleContext2.registerService(clazz2.getName(), (Object)new InitLegacyPreferences(), new Hashtable());
    }

    private void stopServices() {
        if (this.legacyPreferencesService != null) {
            this.legacyPreferencesService.unregister();
            this.legacyPreferencesService = null;
        }
        if (this.customPreferencesService != null) {
            this.customPreferencesService.unregister();
            this.customPreferencesService = null;
        }
    }

    private PackageAdmin getBundleAdmin() {
        if (this.bundleTracker == null) {
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.bundleTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.bundleTracker.open();
        }
        return (PackageAdmin)this.bundleTracker.getService();
    }

    private DebugOptions getDebugOptions() {
        if (this.debugTracker == null) {
            if (this.context == null) {
                return null;
            }
            Class<?> clazz = class$10;
            if (clazz == null) {
                try {
                    clazz = class$10 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.debugTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.debugTracker.open();
        }
        return (DebugOptions)this.debugTracker.getService();
    }

    private void closeOSGITrackers() {
        if (this.productTracker != null) {
            this.productTracker.close();
            this.productTracker = null;
        }
        if (this.preferencesTracker != null) {
            this.preferencesTracker.close();
            this.preferencesTracker = null;
        }
        if (this.contentTracker != null) {
            this.contentTracker.close();
            this.contentTracker = null;
        }
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        if (this.groupProviderTracker != null) {
            this.groupProviderTracker.close();
            this.groupProviderTracker = null;
        }
        if (this.environmentTracker != null) {
            this.environmentTracker.close();
            this.environmentTracker = null;
        }
    }

    public static void message(String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(new Date(System.currentTimeMillis()));
        buffer.append(" - [");
        buffer.append(Thread.currentThread().getName());
        buffer.append("] ");
        buffer.append(message);
        System.out.println(buffer.toString());
    }
}

