/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.index.IIndexTopic;
import org.eclipse.help.internal.index.Index;
import org.eclipse.help.internal.index.IndexEntry;
import org.eclipse.help.internal.webapp.data.ActivitiesData;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class IndexData
extends ActivitiesData {
    private Index index;
    private String imagesDirectory;
    private String plusMinusImage;
    private String expandedCollapsed;
    private boolean usePlusMinus;
    private boolean expandAll;
    private Writer out;

    public IndexData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        this.imagesDirectory = this.preferences.getImagesDirectory();
        this.usePlusMinus = this.preferences.isIndexPlusMinus();
        this.expandAll = this.preferences.isIndexExpandAll();
        this.plusMinusImage = this.expandAll ? "/minus.gif" : "/plus.gif";
        this.expandedCollapsed = this.expandAll ? "expanded" : "collapsed";
        this.loadIndex();
    }

    private void loadIndex() {
        this.index = this.extractEnabled(HelpPlugin.getIndexManager().getIndex(this.getLocale()));
    }

    public IndexEntry getIndexEntry(String[] path) {
        Map entries = this.index.getEntryMap();
        IndexEntry result = null;
        int i = 0;
        while (i < path.length) {
            result = (IndexEntry)entries.get(path[i]);
            if (result == null) {
                return null;
            }
            entries = result.getEntryMap();
            ++i;
        }
        return result;
    }

    public void generateIds(Writer out) throws IOException {
        boolean first = true;
        Iterator iter = this.index.getEntryMap().values().iterator();
        while (iter.hasNext()) {
            IndexEntry entry = (IndexEntry)iter.next();
            if (entry == null) continue;
            if (first) {
                first = false;
            } else {
                out.write(",\n");
            }
            out.write("\"");
            out.write(entry.getKeyword());
            out.write("\"");
        }
    }

    public void generateIndex(Writer out) throws IOException {
        this.out = out;
        Iterator iter = this.index.getEntryMap().values().iterator();
        while (iter.hasNext()) {
            IndexEntry entry = (IndexEntry)iter.next();
            this.generateEntry(entry, 0);
        }
    }

    private void generateEntry(IndexEntry entry, int level) throws IOException {
        List topics = entry.getTopicList();
        int topicCount = topics.size();
        boolean multipleTopics = topicCount > 1;
        boolean singleTopic = topicCount == 1;
        this.out.write("<li>");
        if (this.usePlusMinus) {
            this.generatePlusImage(multipleTopics);
        }
        this.generateAnchor(singleTopic, entry, level);
        if (multipleTopics) {
            this.generateTopicList(entry);
        }
        this.generateSubentries(entry, level + 1);
        this.out.write("</li>\n");
    }

    private void generatePlusImage(boolean multipleTopics) throws IOException {
        this.out.write("<img src=\"");
        this.out.write(this.imagesDirectory);
        this.out.write(this.plusMinusImage);
        this.out.write("\" class=\"");
        if (multipleTopics) {
            this.out.write(this.expandedCollapsed);
        } else {
            this.out.write("h");
        }
        this.out.write("\" alt=\"");
        if (multipleTopics) {
            if (this.expandAll) {
                this.out.write(ServletResources.getString("collapseTopicTitles", this.request));
            } else {
                this.out.write(ServletResources.getString("expandTopicTitles", this.request));
            }
        }
        this.out.write("\">");
    }

    private void generateAnchor(boolean singleTopic, IndexEntry entry, int level) throws IOException {
        this.out.write("<a ");
        if (level == 0) {
            this.out.write("id=\"");
            this.out.write(entry.getKeyword());
            this.out.write("\" ");
        }
        if (singleTopic) {
            this.out.write("href=\"");
            this.out.write(UrlUtil.getHelpURL(((IIndexTopic)entry.getTopicList().get(0)).getHref()));
            this.out.write("\">");
        } else {
            this.out.write("class=\"nolink\" href=\"about:blank\">");
        }
        this.out.write(UrlUtil.htmlEncode(entry.getKeyword()));
        this.out.write("</a>");
    }

    private void generateTopicList(IndexEntry entry) throws IOException {
        List topics = entry.getTopicList();
        int size = topics.size();
        this.out.write("\n<ul class=\"");
        this.out.write(this.expandedCollapsed);
        this.out.write("\">\n");
        int i = 0;
        while (i < size) {
            IIndexTopic topic = (IIndexTopic)topics.get(i);
            this.out.write("<li>");
            if (this.usePlusMinus) {
                this.out.write("<img class=\"h\" src=\"");
                this.out.write(this.imagesDirectory);
                this.out.write(this.plusMinusImage);
                this.out.write("\" alt=\"\">");
            }
            this.out.write("<a href=\"");
            this.out.write(UrlUtil.getHelpURL(topic.getHref()));
            this.out.write("\"><img src=\"");
            this.out.write(this.imagesDirectory);
            this.out.write("/topic.gif\" alt=\"\">");
            this.out.write(UrlUtil.htmlEncode(topic.getLabel()));
            this.out.write("</a></li>\n");
            ++i;
        }
        this.out.write("</ul>\n");
    }

    private void generateSubentries(IndexEntry entry, int level) throws IOException {
        Iterator iter = entry.getEntryMap().values().iterator();
        if (iter.hasNext()) {
            this.out.write("<ul class=\"expanded\">\n");
            do {
                IndexEntry childEntry = (IndexEntry)iter.next();
                this.generateEntry(childEntry, level);
            } while (iter.hasNext());
            this.out.write("</ul>\n");
        }
    }

    private Index extractEnabled(Index index) {
        ArrayList<IndexEntry> enabledEntries = new ArrayList<IndexEntry>();
        Iterator iter = index.getEntryMap().values().iterator();
        while (iter.hasNext()) {
            IndexEntry entry = this.extractEnabled((IndexEntry)iter.next());
            if (entry == null) continue;
            enabledEntries.add(entry);
        }
        return new Index(enabledEntries);
    }

    private IndexEntry extractEnabled(IndexEntry entry) {
        Map subentries;
        ArrayList<IIndexTopic> enabledTopics = new ArrayList<IIndexTopic>();
        ArrayList<IndexEntry> enabledSubentries = new ArrayList<IndexEntry>();
        List topics = entry.getTopicList();
        if (topics != null) {
            Iterator iter = topics.iterator();
            while (iter.hasNext()) {
                IIndexTopic topic = (IIndexTopic)iter.next();
                if (!this.isEnabled(topic)) continue;
                enabledTopics.add(topic);
            }
        }
        if ((subentries = entry.getEntryMap()) != null) {
            Iterator iter = subentries.values().iterator();
            while (iter.hasNext()) {
                IndexEntry subentry = this.extractEnabled((IndexEntry)iter.next());
                if (subentry == null) continue;
                enabledSubentries.add(subentry);
            }
        }
        if (enabledTopics.isEmpty() && enabledSubentries.isEmpty()) {
            return null;
        }
        return new IndexEntry(entry.getKeyword(), enabledTopics, enabledSubentries);
    }

    private boolean isEnabled(IIndexTopic topic) {
        if (!this.isAdvancedUI()) {
            return true;
        }
        return HelpBasePlugin.getActivitySupport().isEnabled(topic.getHref());
    }
}

