/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.text.NumberFormat;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchProgressMonitor;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.search.SearchResults;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.data.ActivitiesData;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.TocData;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.WebappWorkingSetManager;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.WorkingSet;

public class SearchData
extends ActivitiesData {
    private WebappWorkingSetManager wsmgr;
    private String topicHref;
    private String selectedTopicId = "";
    private String searchWord;
    private String workingSetName;
    SearchHit[] hits;
    private int indexCompletion = 100;
    private QueryTooComplexException queryException = null;

    public SearchData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        this.wsmgr = new WebappWorkingSetManager(request, response, this.getLocale());
        this.topicHref = request.getParameter("topic");
        if (this.topicHref != null && this.topicHref.length() == 0) {
            this.topicHref = null;
        }
        this.searchWord = request.getParameter("searchWord");
        if (this.isSearchRequest() && !this.isScopeRequest()) {
            this.loadSearchResults();
            if (this.queryException != null) {
                return;
            }
            if (!this.isProgressRequest()) {
                int i = 0;
                while (i < this.hits.length) {
                    if (this.hits[i].getHref().equals(this.topicHref)) {
                        this.selectedTopicId = "a" + i;
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public boolean isSearchRequest() {
        return this.request.getParameter("searchWord") != null;
    }

    public boolean isProgressRequest() {
        return this.hits == null && this.indexCompletion != 100;
    }

    public boolean isScopeRequest() {
        return this.request.getParameter("workingSet") != null;
    }

    public int getResultsCount() {
        return this.hits.length;
    }

    public String getSelectedTopicId() {
        return this.selectedTopicId;
    }

    public String getTopicHref(int i) {
        return UrlUtil.getHelpURL(this.hits[i].getHref());
    }

    public String getTopicLabel(int i) {
        return UrlUtil.htmlEncode(this.hits[i].getLabel());
    }

    public String getTopicScore(int i) {
        try {
            float score = this.hits[i].getScore();
            NumberFormat percentFormat = NumberFormat.getPercentInstance(UrlUtil.getLocaleObj(this.request, this.response));
            return percentFormat.format(score);
        }
        catch (NumberFormatException numberFormatException) {
            return String.valueOf(this.hits[i].getScore());
        }
    }

    public String getTopicTocLabel(int i) {
        if (this.hits[i].getToc() != null) {
            return UrlUtil.htmlEncode(this.hits[i].getToc().getLabel());
        }
        return "";
    }

    public String getTopicDescription(int i) {
        return UrlUtil.htmlEncode(this.hits[i].getDescription());
    }

    public boolean isEnabled(int i) {
        String href = this.hits[i].getHref();
        return HelpBasePlugin.getActivitySupport().isEnabledTopic(href, this.getLocale());
    }

    public String getIndexedPercentage() {
        return String.valueOf(this.indexCompletion);
    }

    public String getSearchWord() {
        if (this.searchWord == null) {
            return "";
        }
        return this.searchWord;
    }

    public String[] getSelectedTocs() {
        String[] books = this.request.getParameterValues("scope");
        if (books == null) {
            TocData tocData = new TocData(this.context, this.request, this.response);
            books = new String[tocData.getTocCount()];
            int i = 0;
            while (i < books.length) {
                books[i] = tocData.getTocHref(i);
                ++i;
            }
        }
        return books;
    }

    public boolean isTocSelected(int toc) {
        TocData tocData = new TocData(this.context, this.request, this.response);
        String href = tocData.getTocHref(toc);
        String[] books = this.request.getParameterValues("scope");
        if (books == null) {
            return false;
        }
        int i = 0;
        while (i < books.length) {
            if (books[i].equals(href)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getScope() {
        if (this.workingSetName != null) {
            return this.workingSetName;
        }
        if (this.isScopeRequest()) {
            this.workingSetName = this.request.getParameter("workingSet");
        } else if (this.isSearchRequest()) {
            this.workingSetName = this.request.getParameter("scope");
            if (this.workingSetName == null) {
                this.workingSetName = this.request.getParameter("workingSet");
            }
        } else {
            this.workingSetName = this.wsmgr.getCurrentWorkingSet();
        }
        if (this.workingSetName == null || this.workingSetName.length() == 0 || this.getMode() == 1 && this.wsmgr.getWorkingSet(this.workingSetName) == null) {
            this.workingSetName = ServletResources.getString("All", this.request);
        }
        return this.workingSetName;
    }

    public void saveScope() {
        String workingSet = this.request.getParameter("scope");
        String lastWS = this.wsmgr.getCurrentWorkingSet();
        if (workingSet != null && !workingSet.equals(lastWS)) {
            this.wsmgr.setCurrentWorkingSet(workingSet);
        } else if (workingSet == null && lastWS != null && lastWS.length() > 0) {
            this.wsmgr.setCurrentWorkingSet("");
        }
    }

    private void loadSearchResults() {
        try {
            SearchProgressMonitor pm = SearchProgressMonitor.getProgressMonitor((String)this.getLocale());
            if (pm.isDone()) {
                this.indexCompletion = 100;
                SearchResults results = this.createHitCollector();
                BaseHelpSystem.getSearchManager().search(this.createSearchQuery(), (ISearchHitCollector)results, (IProgressMonitor)pm);
                this.hits = results.getSearchHits();
                if (this.hits == null) {
                    HelpWebappPlugin.logWarning((String)"No search results returned.  Help index is in use.");
                }
                return;
            }
            this.indexCompletion = pm.getPercentage();
            if (this.indexCompletion >= 100) {
                this.indexCompletion = 99;
            }
            return;
        }
        catch (QueryTooComplexException qe) {
            this.queryException = qe;
        }
        catch (Exception exception) {
            this.indexCompletion = 0;
        }
    }

    private ISearchQuery createSearchQuery() {
        String fieldSearchStr = this.request.getParameter("fieldSearch");
        boolean fieldSearch = fieldSearchStr != null ? new Boolean(fieldSearchStr) : false;
        return new SearchQuery(this.searchWord, fieldSearch, new ArrayList(), this.getLocale());
    }

    private SearchResults createHitCollector() {
        WorkingSet[] workingSets = this.request.getParameterValues("scopedSearch") == null ? this.getWorkingSets() : this.createTempWorkingSets();
        int maxHits = 500;
        String maxHitsStr = this.request.getParameter("maxHits");
        if (maxHitsStr != null) {
            try {
                int clientmaxHits = Integer.parseInt(maxHitsStr);
                if (clientmaxHits > 0 && clientmaxHits < 500) {
                    maxHits = clientmaxHits;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new SearchResults(workingSets, maxHits, this.getLocale());
    }

    private WorkingSet[] getWorkingSets() {
        String[] scopes = this.request.getParameterValues("scope");
        if (scopes == null) {
            return null;
        }
        ArrayList<WorkingSet> workingSetCol = new ArrayList<WorkingSet>(scopes.length);
        int s = 0;
        while (s < scopes.length) {
            WorkingSet ws = this.wsmgr.getWorkingSet(scopes[s]);
            if (ws != null) {
                workingSetCol.add(ws);
            }
            ++s;
        }
        if (workingSetCol.size() == 0) {
            return null;
        }
        return workingSetCol.toArray(new WorkingSet[workingSetCol.size()]);
    }

    private WorkingSet[] createTempWorkingSets() {
        String[] scopes = this.request.getParameterValues("scope");
        if (scopes == null) {
            return new WorkingSet[0];
        }
        if (scopes.length == HelpPlugin.getTocManager().getTocs(this.getLocale()).length) {
            return null;
        }
        ArrayList<AdaptableToc> tocs = new ArrayList<AdaptableToc>(scopes.length);
        int s = 0;
        while (s < scopes.length) {
            AdaptableToc toc = this.wsmgr.getAdaptableToc(scopes[s]);
            if (toc != null) {
                tocs.add(toc);
            }
            ++s;
        }
        AdaptableToc[] adaptableTocs = tocs.toArray(new AdaptableToc[tocs.size()]);
        WorkingSet[] workingSets = new WorkingSet[]{this.wsmgr.createWorkingSet("temp", (AdaptableHelpResource[])adaptableTocs)};
        return workingSets;
    }

    public String getQueryExceptionMessage() {
        if (this.queryException == null) {
            return null;
        }
        return ServletResources.getString("searchTooComplex", this.request);
    }
}

