/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.datatransfer;

import java.io.File;
import java.text.MessageFormat;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javac;
import org.eclipse.ant.internal.ui.datatransfer.DataTransferMessages;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ProjectCreator {
    public IJavaProject createJavaProjectFromJavacNode(String projectName, Javac javacTask, IProgressMonitor monitor) throws CoreException {
        try {
            IJavaProject javaProject = this.createJavaProject(projectName, monitor);
            File destDir = javacTask.getDestdir();
            String destDirName = destDir == null ? null : destDir.getName();
            org.apache.tools.ant.types.Path sourceDirs = javacTask.getSrcdir();
            this.createSourceDirectories(destDir, destDirName, sourceDirs, javaProject, monitor);
            this.addVariableEntry(javaProject, (IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"), monitor);
            this.setClasspath(javacTask, javaProject, monitor);
            javaProject.getProject().refreshLocal(2, monitor);
            return javaProject;
        }
        catch (BuildException be) {
            Status status = new Status(4, "org.eclipse.ant.ui", 0, be.getLocalizedMessage(), (Throwable)be);
            throw new CoreException((IStatus)status);
        }
    }

    private void setClasspath(Javac javacTask, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        try {
            org.apache.tools.ant.types.Path classpath = javacTask.getClasspath();
            if (classpath == null) {
                return;
            }
            String[] classpaths = classpath.list();
            int i = 0;
            while (i < classpaths.length) {
                String cp = classpaths[i];
                File classpathEntry = new File(cp);
                if (classpathEntry.isFile()) {
                    this.addLibrary(javaProject, (IPath)new Path(classpathEntry.getAbsolutePath()), monitor);
                } else {
                    this.addContainer(javaProject, (IPath)new Path(classpathEntry.getAbsolutePath()), monitor);
                }
                ++i;
            }
        }
        catch (BuildException be) {
            Status status = new Status(4, "org.eclipse.ant.ui", 0, MessageFormat.format(DataTransferMessages.ProjectCreator_0, be.getLocalizedMessage()), null);
            throw new CoreException((IStatus)status);
        }
    }

    private void createSourceDirectories(File destDir, String destDirName, org.apache.tools.ant.types.Path sourceDirs, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        String[] sourceDirectories = sourceDirs.list();
        int i = 0;
        while (i < sourceDirectories.length) {
            String destDirPath;
            String srcDir = sourceDirectories[i];
            File srcDirectory = new File(srcDir);
            String srcDirectoryName = srcDirectory.getName();
            String string = destDirPath = destDir == null ? srcDir : destDir.getAbsolutePath();
            if (destDirName == null) {
                destDirName = srcDirectoryName;
            }
            this.addSourceContainer(javaProject, srcDirectoryName, srcDir, destDirName, destDirPath, monitor);
            ++i;
        }
    }

    private IJavaProject createJavaProject(String projectName, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            project.create(monitor);
        } else {
            project.refreshLocal(2, monitor);
        }
        if (!project.isOpen()) {
            project.open(monitor);
        }
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            this.addNatureToProject(project, "org.eclipse.jdt.core.javanature", monitor);
        }
        IJavaProject jproject = JavaCore.create((IProject)project);
        jproject.setRawClasspath(new IClasspathEntry[0], monitor);
        return jproject;
    }

    private void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    private void addSourceContainer(IJavaProject jproject, String srcName, String srcPath, String outputName, String outputPath, IProgressMonitor monitor) throws CoreException {
        IProject project = jproject.getProject();
        IProject container = null;
        if (srcName == null || srcName.length() == 0) {
            container = project;
        } else {
            IFolder folder = project.getFolder(srcName);
            if (!folder.exists()) {
                folder.createLink((IPath)new Path(srcPath), 16, monitor);
            }
            container = folder;
        }
        IPackageFragmentRoot root = jproject.getPackageFragmentRoot((IResource)container);
        IPath output = null;
        if (outputName != null) {
            IFolder outputFolder = project.getFolder(outputName);
            if (!outputFolder.exists()) {
                outputFolder.createLink((IPath)new Path(outputPath), 16, monitor);
            }
            output = outputFolder.getFullPath();
        }
        IClasspathEntry cpe = JavaCore.newSourceEntry((IPath)root.getPath(), (IPath[])new IPath[0], output);
        this.addToClasspath(jproject, cpe, monitor);
    }

    private void addToClasspath(IJavaProject jproject, IClasspathEntry cpe, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] oldEntries = jproject.getRawClasspath();
        int i = 0;
        while (i < oldEntries.length) {
            if (oldEntries[i].equals(cpe)) {
                return;
            }
            ++i;
        }
        int nEntries = oldEntries.length;
        IClasspathEntry[] newEntries = new IClasspathEntry[nEntries + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, nEntries);
        newEntries[nEntries] = cpe;
        jproject.setRawClasspath(newEntries, monitor);
    }

    private void addVariableEntry(IJavaProject jproject, IPath path, IPath sourceAttachPath, IPath sourceAttachRoot, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry cpe = JavaCore.newVariableEntry((IPath)path, (IPath)sourceAttachPath, (IPath)sourceAttachRoot);
        this.addToClasspath(jproject, cpe, monitor);
    }

    private void addLibrary(IJavaProject jproject, IPath path, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry cpe = JavaCore.newLibraryEntry((IPath)path, null, null);
        this.addToClasspath(jproject, cpe, monitor);
    }

    private void addContainer(IJavaProject jproject, IPath path, IProgressMonitor monitor) throws CoreException {
        IClasspathEntry cpe = JavaCore.newContainerEntry((IPath)path);
        this.addToClasspath(jproject, cpe, monitor);
        IProject project = jproject.getProject();
        IFolder folder = project.getFolder(path.lastSegment());
        if (!folder.exists()) {
            folder.createLink(path, 16, monitor);
        }
    }
}

