/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.ant.internal.ui.preferences.StatusInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class AbstractAntEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private OverlayPreferenceStore fOverlayStore;
    protected List fStatusList;
    private boolean fInitialized = false;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            AbstractAntEditorPreferencePage.this.fOverlayStore.setValue((String)AbstractAntEditorPreferencePage.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private Map fTextFields = new HashMap();
    private ModifyListener fTextFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (AbstractAntEditorPreferencePage.this.fInitialized) {
                Text text = (Text)e.widget;
                AbstractAntEditorPreferencePage.this.fOverlayStore.setValue((String)AbstractAntEditorPreferencePage.this.fTextFields.get(text), text.getText());
            }
        }
    };
    private Map fNumberFields = new HashMap();
    private ModifyListener fNumberFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (AbstractAntEditorPreferencePage.this.fInitialized) {
                AbstractAntEditorPreferencePage.this.numberFieldChanged((Text)e.widget);
            }
        }
    };

    public AbstractAntEditorPreferencePage() {
        this.setPreferenceStore(AntUIPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = this.createOverlayStore();
    }

    protected abstract OverlayPreferenceStore createOverlayStore();

    public void init(IWorkbench workbench) {
    }

    protected void initializeFields() {
        String key;
        Map checkBoxes = this.getCheckBoxes();
        Map textFields = this.getTextFields();
        Iterator e = checkBoxes.keySet().iterator();
        while (e.hasNext()) {
            Button b = (Button)e.next();
            key = (String)checkBoxes.get(b);
            b.setSelection(this.getOverlayStore().getBoolean(key));
        }
        e = textFields.keySet().iterator();
        while (e.hasNext()) {
            Text t = (Text)e.next();
            key = (String)textFields.get(t);
            t.setText(this.getOverlayStore().getString(key));
        }
        this.fInitialized = true;
    }

    public boolean performOk() {
        this.getOverlayStore().propagate();
        AntUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected OverlayPreferenceStore getOverlayStore() {
        return this.fOverlayStore;
    }

    protected OverlayPreferenceStore setOverlayStore() {
        return this.fOverlayStore;
    }

    protected Map getCheckBoxes() {
        return this.fCheckBoxes;
    }

    protected Map getTextFields() {
        return this.fTextFields;
    }

    protected Map getNumberFields() {
        return this.fNumberFields;
    }

    protected void performDefaults() {
        this.getOverlayStore().loadDefaults();
        this.initializeFields();
        this.handleDefaults();
        super.performDefaults();
    }

    protected abstract void handleDefaults();

    public void dispose() {
        if (this.getOverlayStore() != null) {
            this.getOverlayStore().stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    protected Button addCheckBox(Composite parent, String labelText, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(labelText);
        checkBox.setFont(parent.getFont());
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.getCheckBoxes().put(checkBox, key);
        return checkBox;
    }

    protected Text addTextField(Composite composite, String labelText, String key, int textLimit, int indentation, String[] errorMessages) {
        Font font = composite.getFont();
        Label label = new Label(composite, 0);
        label.setText(labelText);
        label.setFont(font);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        label.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        textControl.setFont(font);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        this.getTextFields().put(textControl, key);
        if (errorMessages != null) {
            this.getNumberFields().put(textControl, errorMessages);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return textControl;
    }

    private void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number, (String[])this.getNumberFields().get(textControl));
        if (!status.matches(4)) {
            this.getOverlayStore().setValue((String)this.getTextFields().get(textControl), number);
        }
        this.updateStatus(status);
    }

    private IStatus validatePositiveNumber(String number, String[] errorMessages) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(errorMessages[0]);
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(MessageFormat.format(errorMessages[1], number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(MessageFormat.format(errorMessages[1], number));
            }
        }
        return status;
    }

    protected void updateStatus(IStatus status) {
        List statusList;
        if (!status.matches(4)) {
            Set keys = this.getNumberFields().keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Text text = (Text)iter.next();
                IStatus s = this.validatePositiveNumber(text.getText(), (String[])this.getNumberFields().get(text));
                IStatus iStatus = status = s.getSeverity() > status.getSeverity() ? s : status;
            }
        }
        if ((statusList = this.getStatusList()) != null) {
            ArrayList<IStatus> temp = new ArrayList<IStatus>(statusList.size() + 1);
            temp.add(status);
            temp.addAll(statusList);
            status = this.getMostSevere(temp);
        }
        this.setValid(!status.matches(4));
        this.applyToStatusLine((DialogPage)this, status);
    }

    protected List getStatusList() {
        return this.fStatusList;
    }

    private IStatus getMostSevere(List statusList) {
        IStatus max = null;
        int i = 0;
        while (i < statusList.size()) {
            IStatus curr = (IStatus)statusList.get(i);
            if (curr.matches(4)) {
                return curr;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++i;
        }
        return max;
    }

    private void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }

    protected Control[] addLabelledTextField(Composite composite, String label, String key, int textLimit, int indentation, String[] errorMessages) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        labelControl.setFont(composite.getFont());
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        if (textLimit > -1) {
            gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
            textControl.setTextLimit(textLimit);
        } else {
            gd.widthHint = this.convertWidthInCharsToPixels(50);
        }
        textControl.setLayoutData((Object)gd);
        textControl.setFont(composite.getFont());
        this.fTextFields.put(textControl, key);
        if (errorMessages != null) {
            this.fNumberFields.put(textControl, errorMessages);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return new Control[]{labelControl, textControl};
    }

    /*
     * Exception decompiling
     */
    protected String loadPreviewContentFromFile(String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 112->115)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Label getLabelControl(Control[] labelledTextField) {
        return (Label)labelledTextField[0];
    }

    protected Text getTextControl(Control[] labelledTextField) {
        return (Text)labelledTextField[1];
    }
}

