/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.internal.databinding.CollectionBinding;
import org.eclipse.jface.internal.databinding.Pair;
import org.eclipse.jface.internal.databinding.TableBinding;
import org.eclipse.jface.internal.databinding.TreeBinding;
import org.eclipse.jface.internal.databinding.ValueBinding;
import org.eclipse.jface.internal.provisional.databinding.BindSpec;
import org.eclipse.jface.internal.provisional.databinding.BindingEvent;
import org.eclipse.jface.internal.provisional.databinding.BindingException;
import org.eclipse.jface.internal.provisional.databinding.IBindSpec;
import org.eclipse.jface.internal.provisional.databinding.IBindSupportFactory;
import org.eclipse.jface.internal.provisional.databinding.IBinding;
import org.eclipse.jface.internal.provisional.databinding.IBindingListener;
import org.eclipse.jface.internal.provisional.databinding.IChangeListener;
import org.eclipse.jface.internal.provisional.databinding.IDataBindingContext;
import org.eclipse.jface.internal.provisional.databinding.IUpdatable;
import org.eclipse.jface.internal.provisional.databinding.IUpdatableCellProvider;
import org.eclipse.jface.internal.provisional.databinding.IUpdatableCollection;
import org.eclipse.jface.internal.provisional.databinding.IUpdatableFactory;
import org.eclipse.jface.internal.provisional.databinding.IUpdatableTable;
import org.eclipse.jface.internal.provisional.databinding.IUpdatableTree;
import org.eclipse.jface.internal.provisional.databinding.IUpdatableValue;
import org.eclipse.jface.internal.provisional.databinding.converter.IConverter;
import org.eclipse.jface.internal.provisional.databinding.converterfunction.ConversionFunctionRegistry;
import org.eclipse.jface.internal.provisional.databinding.converters.FunctionalConverter;
import org.eclipse.jface.internal.provisional.databinding.converters.IdentityConverter;
import org.eclipse.jface.internal.provisional.databinding.updatables.SettableValue;
import org.eclipse.jface.internal.provisional.databinding.validator.IDomainValidator;
import org.eclipse.jface.internal.provisional.databinding.validator.IValidator;
import org.eclipse.jface.internal.provisional.databinding.validator.ValidatorRegistry;
import org.eclipse.jface.util.Assert;

public class DataBindingContext
implements IDataBindingContext {
    private List createdUpdatables = new ArrayList();
    private DataBindingContext parent;
    private List partialValidationMessages = new ArrayList();
    private List validationMessages = new ArrayList();
    private SettableValue partialValidationMessage;
    private SettableValue validationMessage;
    private SettableValue combinedValidationMessage;
    private List factories;
    private List bindSupportFactories;
    protected int validationTime;
    protected int updateTime;
    private List bindingEventListeners;
    static /* synthetic */ Class class$0;

    public void addBindSupportFactory(IBindSupportFactory factory) {
        this.bindSupportFactories.add(factory);
    }

    public DataBindingContext() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.partialValidationMessage = new SettableValue(clazz, "");
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.validationMessage = new SettableValue(clazz2, "");
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.combinedValidationMessage = new SettableValue(clazz3, "");
        this.factories = new ArrayList();
        this.bindSupportFactories = new ArrayList();
        this.bindingEventListeners = new ArrayList();
        this.registerDefaultBindSupportFactory();
    }

    public void dispose() {
        Iterator it = this.createdUpdatables.iterator();
        while (it.hasNext()) {
            IUpdatable updatable = (IUpdatable)it.next();
            updatable.dispose();
        }
    }

    public IUpdatableValue getCombinedValidationMessage() {
        return this.combinedValidationMessage;
    }

    public IUpdatableValue getPartialValidationMessage() {
        return this.partialValidationMessage;
    }

    public IUpdatableValue getValidationMessage() {
        return this.validationMessage;
    }

    protected void registerDefaultBindSupportFactory() {
        this.addBindSupportFactory(new IBindSupportFactory(){

            public IValidator createValidator(Class fromType, Class toType, Object modelDescription) {
                if (fromType == null || toType == null) {
                    return new IValidator(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public String isPartiallyValid(Object value) {
                            return null;
                        }

                        public String isValid(Object value) {
                            return null;
                        }
                    };
                }
                IValidator dataTypeValidator = ValidatorRegistry.getDefault().get(fromType, toType);
                if (dataTypeValidator == null) {
                    throw new BindingException("No IValidator is registered for conversions from " + fromType.getName() + " to " + toType.getName());
                }
                return dataTypeValidator;
            }

            public IConverter createConverter(Class fromType, Class toType, Object modelDescription) {
                if (toType == null) {
                    return null;
                }
                if (fromType == toType) {
                    return new IdentityConverter(fromType, toType);
                }
                if (ConversionFunctionRegistry.canConvertPair(fromType, toType)) {
                    return new FunctionalConverter(fromType, toType);
                }
                if (toType.isAssignableFrom(fromType) || fromType.isAssignableFrom(toType)) {
                    return new IdentityConverter(fromType, toType);
                }
                return null;
            }

            public IDomainValidator createDomainValidator(Class modelType, Object modelDescription) {
                return new IDomainValidator(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public String isValid(Object value) {
                        return null;
                    }
                };
            }
        });
    }

    private void removeValidationListenerAndMessage(List listOfPairs, Object first) {
        int i = listOfPairs.size() - 1;
        while (i >= 0) {
            Pair pair = (Pair)listOfPairs.get(i);
            if (pair.a.equals(first)) {
                listOfPairs.remove(i);
                return;
            }
            --i;
        }
    }

    public void updatePartialValidationError(IChangeListener listener, String partialValidationErrorOrNull) {
        this.removeValidationListenerAndMessage(this.partialValidationMessages, listener);
        if (partialValidationErrorOrNull != null) {
            this.partialValidationMessages.add(new Pair(listener, partialValidationErrorOrNull));
        }
        this.updateValidationMessage(this.combinedValidationMessage, this.partialValidationMessages.size() > 0 ? this.partialValidationMessages : this.validationMessages);
        this.updateValidationMessage(this.partialValidationMessage, this.partialValidationMessages);
    }

    public void updateValidationError(IChangeListener listener, String validationErrorOrNull) {
        this.removeValidationListenerAndMessage(this.validationMessages, listener);
        if (validationErrorOrNull != null) {
            this.validationMessages.add(new Pair(listener, validationErrorOrNull));
        }
        this.updateValidationMessage(this.combinedValidationMessage, this.partialValidationMessages.size() > 0 ? this.partialValidationMessages : this.validationMessages);
        this.updateValidationMessage(this.validationMessage, this.validationMessages);
    }

    private void updateValidationMessage(SettableValue validationSettableMessage, List listOfPairs) {
        if (listOfPairs.size() == 0) {
            validationSettableMessage.setValue("");
        } else {
            validationSettableMessage.setValue(((Pair)listOfPairs.get((int)(listOfPairs.size() - 1))).b);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IBinding bind(IUpdatable targetUpdatable, IUpdatable modelUpdatable, IBindSpec bindSpec) {
        void var4_14;
        if (bindSpec == null) {
            bindSpec = new BindSpec(null, null);
        }
        if (targetUpdatable instanceof IUpdatableValue) {
            if (!(modelUpdatable instanceof IUpdatableValue)) throw new BindingException("incompatible updatables: target is value, model is " + modelUpdatable.getClass().getName());
            IUpdatableValue target = (IUpdatableValue)targetUpdatable;
            IUpdatableValue model = (IUpdatableValue)modelUpdatable;
            this.fillBindSpecDefaults(bindSpec, target.getValueType(), model.getValueType(), null);
            ValueBinding valueBinding = new ValueBinding(this, target, model, bindSpec);
        } else if (targetUpdatable instanceof IUpdatableCollection) {
            if (!(modelUpdatable instanceof IUpdatableCollection)) throw new BindingException("incompatible updatables: target is collection, model is " + modelUpdatable.getClass().getName());
            IUpdatableCollection target = (IUpdatableCollection)targetUpdatable;
            IUpdatableCollection model = (IUpdatableCollection)modelUpdatable;
            this.fillBindSpecDefaults(bindSpec, target.getElementType(), model.getElementType(), null);
            CollectionBinding collectionBinding = new CollectionBinding(this, target, model, bindSpec);
        } else if (targetUpdatable instanceof IUpdatableTree) {
            if (!(modelUpdatable instanceof IUpdatableTree)) throw new BindingException("incompatible updatables: target is collection, model is " + modelUpdatable.getClass().getName());
            IUpdatableTree target = (IUpdatableTree)targetUpdatable;
            IUpdatableTree model = (IUpdatableTree)modelUpdatable;
            TreeBinding treeBinding = new TreeBinding(this, target, model);
        } else {
            if (!(targetUpdatable instanceof IUpdatableTable)) throw new BindingException("not yet implemented");
            if (!(modelUpdatable instanceof IUpdatableCellProvider)) throw new BindingException("incompatible updatables: target is IUpdatableTable, model is " + modelUpdatable.getClass().getName());
            TableBinding tableBinding = new TableBinding(this, (IUpdatableTable)targetUpdatable, (IUpdatableCellProvider)modelUpdatable, bindSpec);
        }
        var4_14.updateTargetFromModel(null);
        return var4_14;
    }

    public IBinding bind(Object targetDescription, IUpdatable modelUpdatable, IBindSpec bindSpec) {
        return this.bind(this.createUpdatable(targetDescription), modelUpdatable, bindSpec);
    }

    public IBinding bind(IUpdatable targetUpdatable, Object modelDescription, IBindSpec bindSpec) {
        if (bindSpec == null) {
            bindSpec = new BindSpec(null, null);
        }
        Class fromType = null;
        if (targetUpdatable instanceof IUpdatableValue) {
            fromType = ((IUpdatableValue)targetUpdatable).getValueType();
        } else if (targetUpdatable instanceof IUpdatableCollection) {
            fromType = ((IUpdatableCollection)targetUpdatable).getElementType();
        }
        this.fillBindSpecDefaults(bindSpec, fromType, null, modelDescription);
        return this.bind(targetUpdatable, this.createUpdatable(modelDescription), bindSpec);
    }

    protected void fillBindSpecDefaults(IBindSpec bindSpec, Class fromType, Class toType, Object modelDescriptionOrNull) {
        if (bindSpec.getValidator() == null) {
            ((BindSpec)bindSpec).setValidator(this.createValidator(fromType, toType, modelDescriptionOrNull));
        }
        if (bindSpec.getConverter() == null) {
            ((BindSpec)bindSpec).setConverter(this.createConverter(fromType, toType, modelDescriptionOrNull));
        }
    }

    public IValidator createValidator(Class fromType, Class toType, Object modelDescription) {
        int i = this.bindSupportFactories.size() - 1;
        while (i >= 0) {
            IBindSupportFactory bindSupportFactory = (IBindSupportFactory)this.bindSupportFactories.get(i);
            IValidator validator = bindSupportFactory.createValidator(fromType, toType, modelDescription);
            if (validator != null) {
                return validator;
            }
            --i;
        }
        if (this.parent != null) {
            return this.parent.createValidator(fromType, toType, modelDescription);
        }
        return null;
    }

    public IConverter createConverter(Class fromType, Class toType, Object modelDescription) {
        int i = this.bindSupportFactories.size() - 1;
        while (i >= 0) {
            IBindSupportFactory bindSupportFactory = (IBindSupportFactory)this.bindSupportFactories.get(i);
            IConverter converter = bindSupportFactory.createConverter(fromType, toType, modelDescription);
            if (converter != null) {
                return converter;
            }
            --i;
        }
        if (this.parent != null) {
            return this.parent.createConverter(fromType, toType, modelDescription);
        }
        return null;
    }

    public IBinding bind(Object targetDescription, Object modelDescription, IBindSpec bindSpec) {
        return this.bind(this.createUpdatable(targetDescription), modelDescription, bindSpec);
    }

    public IUpdatable createUpdatable(Object description) {
        IUpdatable updatable = this.doCreateUpdatable(description, this);
        if (updatable != null) {
            this.createdUpdatables.add(updatable);
        }
        return updatable;
    }

    public void registerForDispose(IUpdatable updatable) {
        this.createdUpdatables.add(updatable);
    }

    protected IUpdatable doCreateUpdatable(Object description, DataBindingContext thisDatabindingContext) {
        int i = this.factories.size() - 1;
        while (i >= 0) {
            IUpdatableFactory factory = (IUpdatableFactory)this.factories.get(i);
            IUpdatable result = factory.createUpdatable(null, description, thisDatabindingContext);
            if (result != null) {
                return result;
            }
            --i;
        }
        if (this.parent != null) {
            return this.parent.doCreateUpdatable(description, thisDatabindingContext);
        }
        throw new BindingException("could not find updatable for " + description);
    }

    public void addUpdatableFactory(IUpdatableFactory updatableFactory) {
        this.factories.add(updatableFactory);
    }

    public void updateTargets() {
        Assert.isTrue((boolean)false, (String)"updateTargets is not yet implemented");
    }

    public void updateModels() {
        Assert.isTrue((boolean)false, (String)"updateModels is not yet implemented");
    }

    public void addBindingEventListener(IBindingListener listener) {
        this.bindingEventListeners.add(listener);
    }

    public void removeBindingEventListener(IBindingListener listener) {
        this.bindingEventListeners.remove(listener);
    }

    protected String fireBindingEvent(BindingEvent event) {
        String result = null;
        Iterator bindingEventIter = this.bindingEventListeners.iterator();
        while (bindingEventIter.hasNext()) {
            IBindingListener listener = (IBindingListener)bindingEventIter.next();
            result = listener.bindingEvent(event);
            if (result != null) break;
        }
        return result;
    }
}

