/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding;

import java.util.Collection;
import org.eclipse.jface.internal.databinding.Binding;
import org.eclipse.jface.internal.databinding.DataBindingContext;
import org.eclipse.jface.internal.provisional.databinding.BindingEvent;
import org.eclipse.jface.internal.provisional.databinding.ChangeEvent;
import org.eclipse.jface.internal.provisional.databinding.IBindSpec;
import org.eclipse.jface.internal.provisional.databinding.ICellProvider;
import org.eclipse.jface.internal.provisional.databinding.IChangeListener;
import org.eclipse.jface.internal.provisional.databinding.IReadableSet;
import org.eclipse.jface.internal.provisional.databinding.IUpdatableCellProvider;
import org.eclipse.jface.internal.provisional.databinding.IUpdatableTable;

public class TableBinding
extends Binding {
    private final IUpdatableTable target;
    private final IUpdatableCellProvider model;
    private boolean updating = false;
    private IReadableSet modelSet;
    private final IChangeListener targetChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
        }
    };
    private IChangeListener cellsChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            if (changeEvent.getChangeType() == 1024) {
                Collection changedElements = (Collection)changeEvent.getNewValue();
                TableBinding.this.target.updateElements(changedElements.toArray());
            }
        }
    };
    private IChangeListener modelChangeListener = new IChangeListener(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleChange(ChangeEvent changeEvent) {
            block9: {
                if (TableBinding.this.updating) {
                    return;
                }
                if ((changeEvent.getChangeType() & 0x340) == 0) return;
                BindingEvent e = new BindingEvent(changeEvent, 0, 0);
                e.originalValue = changeEvent.getNewValue();
                if (TableBinding.this.failure(TableBinding.this.errMsg(TableBinding.this.fireBindingEvent(e)))) {
                    return;
                }
                try {
                    if (changeEvent.getChangeType() == 256) {
                        TableBinding.this.target.addAll((Collection)e.originalValue);
                    } else if (changeEvent.getChangeType() == 512) {
                        TableBinding.this.target.removeAll((Collection)e.originalValue);
                    } else {
                        changeEvent.getChangeType();
                    }
                    e.pipelinePosition = 4;
                    if (!TableBinding.this.failure(TableBinding.this.errMsg(TableBinding.this.fireBindingEvent(e)))) break block9;
                    Object var3_3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    TableBinding.this.updating = false;
                    throw throwable;
                }
                TableBinding.this.updating = false;
                return;
            }
            Object var3_5 = null;
            TableBinding.this.updating = false;
        }
    };

    public TableBinding(DataBindingContext context, IUpdatableTable target, IUpdatableCellProvider model, IBindSpec bindSpec) {
        super(context);
        this.target = target;
        this.model = model;
        this.modelSet = model.getReadableSet();
        target.addChangeListener(this.targetChangeListener);
        model.addChangeListener(this.cellsChangeListener);
        this.modelSet.addChangeListener(this.modelChangeListener);
    }

    private String errMsg(String validationError) {
        this.context.updatePartialValidationError(this.targetChangeListener, null);
        this.context.updateValidationError(this.targetChangeListener, validationError);
        return validationError;
    }

    private boolean failure(String errorMessage) {
        return errorMessage != null;
    }

    public void updateTargetFromModel(ChangeEvent changeEvent) {
        this.target.clear();
        this.target.addAll(this.modelSet.toCollection());
        this.target.setCellProvider(new ICellProvider(){

            public Object getCellValue(Object element, int index) {
                Object cellValue = TableBinding.this.model.getCellValue(element, index);
                return cellValue == null ? "" : cellValue;
            }

            public void setCellValue(Object element, int index, Object value) {
                TableBinding.this.model.setCellValue(element, index, value);
            }
        });
    }
}

