/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.internal.databinding.beans.ListenerSupport;
import org.eclipse.jface.internal.databinding.beans.PropertyHelper;
import org.eclipse.jface.internal.provisional.databinding.BindingException;
import org.eclipse.jface.internal.provisional.databinding.IChangeListener;
import org.eclipse.jface.internal.provisional.databinding.ITree;
import org.eclipse.jface.internal.provisional.databinding.TreeModelDescription;

public class JavaBeanTree
implements ITree {
    private static final int READ = 0;
    private static final int WRITE = 1;
    private TreeModelDescription modelDescription;
    private Object[] rootElements;
    private HashMap descriptors = new HashMap();
    private ITree.ChangeSupport changeSupport = null;
    private HashMap nodes = new HashMap();
    private boolean updating = false;
    private PropertyChangeListener elementListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (!JavaBeanTree.this.updating && JavaBeanTree.this.changeSupport != null) {
                String[] properties = JavaBeanTree.this.modelDescription.getChildrenProperties(event.getSource().getClass());
                if (properties != null && event.getPropertyName() != null && Arrays.asList(properties).contains(event.getPropertyName())) {
                    JavaBeanTree.this.changeSupport.fireTreeChange(16, null, JavaBeanTree.this.getChildren(event.getSource()), event.getSource(), -1);
                } else {
                    TreeNode node = (TreeNode)JavaBeanTree.this.nodes.get(event.getSource());
                    if (node != null) {
                        int index = -1;
                        Object[] children = JavaBeanTree.this.getChildren(node.getParent());
                        if (children != null) {
                            index = Arrays.asList(children).indexOf(event.getSource());
                        }
                        if (index < 0) {
                            index = -1;
                        }
                        JavaBeanTree.this.changeSupport.fireTreeChange(1, null, event.getSource(), node.getParent(), index);
                    }
                }
            }
        }
    };
    HashMap listenerSupport = new HashMap();

    public JavaBeanTree(TreeModelDescription modelDescripton) {
        this.modelDescription = modelDescripton;
        if (modelDescripton.getRoot() == null) {
            this.rootElements = Collections.EMPTY_LIST.toArray();
        } else {
            Object[] objectArray;
            if (modelDescripton.getRoot().getClass().isArray()) {
                objectArray = (Object[])modelDescripton.getRoot();
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = modelDescripton.getRoot();
            }
            this.rootElements = objectArray;
        }
        TreeNode root = new TreeNode(null);
        this.nodes.put(this, root);
        this.hookup(null, this.rootElements);
    }

    private Class getRelevantClass(Object o) {
        if (o == null) {
            return null;
        }
        Class leafClass = null;
        Class<?> current = o.getClass();
        Class[] list = this.modelDescription.getTypes();
        int i = 0;
        while (i < list.length) {
            if (list[i].isAssignableFrom(current)) {
                if (leafClass == null) {
                    leafClass = list[i];
                } else if (leafClass.isAssignableFrom(list[i])) {
                    leafClass = list[i];
                }
            }
            ++i;
        }
        return leafClass;
    }

    private Method[] getInvocationMethods(Class clazz, int methodType) {
        int i;
        if (clazz == null) {
            return null;
        }
        String[] childrenProperties = this.modelDescription.getChildrenProperties(clazz);
        if (childrenProperties == null || childrenProperties.length == 0) {
            return null;
        }
        PropertyHelper[] properties = (PropertyHelper[])this.descriptors.get(clazz);
        if (properties == null) {
            ArrayList<PropertyHelper> newpProperties = new ArrayList<PropertyHelper>();
            i = 0;
            while (i < childrenProperties.length) {
                PropertyHelper property = new PropertyHelper(childrenProperties[i], clazz);
                if (property.getGetter() != null || property.getSetter() != null) {
                    newpProperties.add(property);
                }
                ++i;
            }
            properties = newpProperties.toArray(new PropertyHelper[newpProperties.size()]);
            this.descriptors.put(clazz, properties);
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        i = 0;
        while (i < properties.length) {
            if (methodType == 0) {
                methods.add(properties[i].getGetter());
            } else {
                methods.add(properties[i].getSetter());
            }
            ++i;
        }
        return methods.toArray(new Method[methods.size()]);
    }

    private Method[] getReadMethods(Object element) {
        Class clazz = this.getRelevantClass(element);
        if (clazz == null) {
            return null;
        }
        Method[] methods = this.getInvocationMethods(clazz, 0);
        return methods;
    }

    private Method[] getWriteMethods(Object element) {
        Class clazz = this.getRelevantClass(element);
        if (clazz == null) {
            return null;
        }
        Method[] methods = this.getInvocationMethods(clazz, 1);
        return methods;
    }

    private void hookup(Object parent, Object[] children) {
        Object key = parent == null ? this : parent;
        ListenerSupport support = (ListenerSupport)this.listenerSupport.get(key);
        if (support == null) {
            support = new ListenerSupport(this.elementListener);
            this.listenerSupport.put(key, support);
        }
        support.setHookTargets(children);
        this.trackChildren(parent, children);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement == null) {
            return this.rootElements;
        }
        Method[] getters = this.getReadMethods(parentElement);
        if (getters == null) {
            return Collections.EMPTY_LIST.toArray();
        }
        ArrayList<Object> children = new ArrayList<Object>();
        try {
            int i = 0;
            while (i < getters.length) {
                Object list = getters[i].invoke(parentElement, new Object[0]);
                if (list != null) {
                    if (getters[i].getReturnType().isArray()) {
                        children.addAll(Arrays.asList((Object[])list));
                    } else {
                        children.addAll((Collection)getters[i].invoke(parentElement, new Object[0]));
                    }
                }
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e.getLocalizedMessage());
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e.getLocalizedMessage());
        }
        catch (InvocationTargetException e) {
            throw new BindingException(e.getLocalizedMessage());
        }
        Object[] result = children.toArray();
        this.hookup(parentElement, result);
        this.trackChildren(parentElement, result);
        return result;
    }

    private void trackChildren(Object parentElement, Object[] children) {
        List<Object> newList;
        Object key = parentElement == null ? this : parentElement;
        TreeNode node = (TreeNode)this.nodes.get(key);
        HashSet removed = new HashSet(node.getChildren());
        List<Object> list = newList = children == null ? new ArrayList() : Arrays.asList(children);
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                if (!removed.remove(children[i])) {
                    TreeNode child = new TreeNode(parentElement);
                    this.nodes.put(children[i], child);
                }
                ++i;
            }
        }
        Iterator itr = removed.iterator();
        while (itr.hasNext()) {
            this.nodes.remove(itr.next());
        }
        node.setChildren(newList);
    }

    public void setChildren(Object parentElement, Object[] children) {
        if (parentElement == null) {
            throw new BindingException("Changing root element/s is not supported");
        }
        Method[] setters = this.getWriteMethods(parentElement);
        if (setters == null || setters.length != 1) {
            throw new BindingException("Can not determine children set method for: " + parentElement.getClass().getName());
        }
        Method setter = setters[0];
        Class<?>[] parameters = setter.getParameterTypes();
        Object arg = parameters[0].isArray() ? children : Arrays.asList(children);
        try {
            setter.invoke(parentElement, arg);
        }
        catch (IllegalArgumentException e) {
            throw new BindingException(e.getLocalizedMessage());
        }
        catch (IllegalAccessException e) {
            throw new BindingException(e.getLocalizedMessage());
        }
        catch (InvocationTargetException e) {
            throw new BindingException(e.getLocalizedMessage());
        }
        this.hookup(parentElement, children);
        if (this.changeSupport != null) {
            this.changeSupport.fireTreeChange(16, null, children, parentElement, -1);
        }
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public Class[] getTypes() {
        return this.modelDescription.getTypes();
    }

    public void addTreeChangeListener(IChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new ITree.ChangeSupport(this);
        }
        this.changeSupport.addTreeChangeListener(listener);
    }

    public void removeTreeChangeListener(IChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removeTreeChangeListener(listener);
    }

    public void dispose() {
        if (this.listenerSupport != null) {
            Iterator itr = this.listenerSupport.values().iterator();
            while (itr.hasNext()) {
                ((ListenerSupport)itr.next()).dispose();
            }
            this.listenerSupport = null;
            this.descriptors = null;
            this.changeSupport = null;
            this.modelDescription = null;
        }
    }

    private class TreeNode {
        private Object parent;
        private List children;

        public TreeNode(Object parent) {
            this.parent = parent;
        }

        public List getChildren() {
            return this.children == null ? Collections.EMPTY_LIST : this.children;
        }

        public void setChildren(List children) {
            this.children = children;
        }

        public Object getParent() {
            return this.parent;
        }
    }
}

