/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.beans;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.jface.internal.provisional.databinding.BindingException;

public class PropertyHelper {
    public static final String PROPERTY_NESTING_SEPERATOR = ".";
    private final String propertyString;
    private final Class rootClass;
    private final String[] propertyList;
    private Method[] getterList = null;
    private Method setter = null;

    public PropertyHelper(String property, Class rootClass) {
        this.propertyString = property;
        StringTokenizer stk = new StringTokenizer(property, PROPERTY_NESTING_SEPERATOR);
        this.propertyList = new String[stk.countTokens()];
        int i = 0;
        while (stk.hasMoreElements()) {
            this.propertyList[i] = (String)stk.nextElement();
            ++i;
        }
        this.rootClass = rootClass;
    }

    private Method getGetterMethod(Class c, String property) throws SecurityException, NoSuchMethodException {
        if (c == null || property == null) {
            return null;
        }
        AccessibleObject getter = null;
        try {
            getter = c.getMethod("get" + property.substring(0, 1).toUpperCase(Locale.ENGLISH) + property.substring(1), new Class[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (getter == null) {
            try {
                getter = c.getMethod("is" + property.substring(0, 1).toUpperCase(Locale.ENGLISH) + property.substring(1), new Class[0]);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (getter == null) {
                getter = c.getMethod(property, new Class[0]);
            }
        }
        if (getter != null && !getter.isAccessible()) {
            ((Method)getter).setAccessible(true);
        }
        return getter;
    }

    private Method getSetterMethod(Class c, String property, Class argType) throws SecurityException, NoSuchMethodException {
        if (c == null || property == null) {
            return null;
        }
        AccessibleObject setter = null;
        try {
            setter = c.getMethod("set" + property.substring(0, 1).toUpperCase(Locale.ENGLISH) + property.substring(1), argType);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (setter == null) {
            setter = c.getMethod(property, argType);
        }
        if (setter != null && !setter.isAccessible()) {
            ((Method)setter).setAccessible(true);
        }
        return setter;
    }

    private Method[] getGetters(Class root) {
        if (this.getterList != null) {
            return this.getterList;
        }
        this.getterList = new Method[this.propertyList.length];
        Method getter = null;
        int i = 0;
        while (i < this.propertyList.length) {
            try {
                getter = this.getGetterMethod(root, this.propertyList[i]);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new BindingException("Invalid property: " + this.propertyString);
            }
            root = getter.getReturnType();
            this.getterList[i] = getter;
            ++i;
        }
        return this.getterList;
    }

    public Method getSetter() {
        if (this.setter != null) {
            return this.setter;
        }
        Method[] list = this.getGetters(this.rootClass);
        Class<?> target = list.length > 1 ? list[list.length - 2].getReturnType() : this.rootClass;
        try {
            this.setter = this.getSetterMethod(target, this.propertyList[this.propertyList.length - 1], list[list.length - 1].getReturnType());
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return this.setter;
    }

    public Object get(Object root) {
        return this.get(root, this.propertyList.length - 1);
    }

    private Object get(Object root, int length) {
        if (root == null) {
            return null;
        }
        Object result = root;
        Method[] list = this.getGetters(this.rootClass);
        try {
            int i = 0;
            while (i <= length) {
                if ((result = list[i].invoke(result, new Object[0])) != null) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return result;
    }

    public Method getGetter() {
        Method[] getters = this.getGetters(this.rootClass);
        return getters[getters.length - 1];
    }

    public void set(Object root, Object singleArg) {
        Method setter = this.getSetter();
        Object target = this.getLeafTarget(root);
        if (setter != null && target != null) {
            try {
                setter.invoke(target, singleArg);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    public boolean canSet(Object root) {
        return this.getSetter() != null && this.get(root, this.propertyList.length - 2) != null;
    }

    public boolean canGet(Object root) {
        return this.getGetter() != null && this.get(root, this.propertyList.length - 2) != null;
    }

    public String getLeafProperty() {
        return this.propertyList[this.propertyList.length - 1];
    }

    public Object getLeafTarget(Object root) {
        int index = this.propertyList.length - 2;
        if (index < 0) {
            return root;
        }
        return this.get(root, index);
    }
}

