/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.jface.internal.databinding.swt.AsyncRunnable;
import org.eclipse.jface.internal.databinding.swt.SyncRunnable;
import org.eclipse.jface.internal.provisional.databinding.UpdatableValue;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;

public class ComboUpdatableValue
extends UpdatableValue {
    private final Combo combo;
    private final String attribute;
    private boolean updating = false;
    static /* synthetic */ Class class$0;

    public ComboUpdatableValue(Combo combo, String attribute) {
        this.combo = combo;
        this.attribute = attribute;
        if (attribute.equals("content")) {
            attribute = "text";
        }
        if (!attribute.equals("text") && !attribute.equals("selection")) {
            throw new IllegalArgumentException();
        }
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ComboUpdatableValue.this.updating) {
                    ComboUpdatableValue.this.fireChangeEvent(1, null, null);
                }
            }
        });
    }

    public void setValue(final Object value) {
        AsyncRunnable runnable = new AsyncRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                String oldValue = ComboUpdatableValue.this.combo.getText();
                try {
                    ComboUpdatableValue.this.updating = true;
                    if (ComboUpdatableValue.this.attribute.equals("text")) {
                        String stringValue = value != null ? value.toString() : "";
                        ComboUpdatableValue.this.combo.setText(stringValue);
                    } else if (ComboUpdatableValue.this.attribute.equals("selection")) {
                        String[] items = ComboUpdatableValue.this.combo.getItems();
                        int index = -1;
                        if (items != null && value != null) {
                            int i = 0;
                            while (i < items.length) {
                                if (value.equals(items[i])) {
                                    index = i;
                                    break;
                                }
                                ++i;
                            }
                            ComboUpdatableValue.this.combo.select(index);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    ComboUpdatableValue.this.updating = false;
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                }
                ComboUpdatableValue.this.updating = false;
                ComboUpdatableValue.this.fireChangeEvent(1, oldValue, ComboUpdatableValue.this.combo.getText());
            }
        };
        runnable.runOn(this.combo.getDisplay());
    }

    public Object computeValue() {
        SyncRunnable runnable = new SyncRunnable(){

            public Object run() {
                if (ComboUpdatableValue.this.attribute.equals("text")) {
                    return ComboUpdatableValue.this.combo.getText();
                }
                Assert.isTrue((boolean)ComboUpdatableValue.this.attribute.equals("selection"), (String)("unexpected attribute" + ComboUpdatableValue.this.attribute));
                int index = ComboUpdatableValue.this.combo.getSelectionIndex();
                if (index >= 0) {
                    return ComboUpdatableValue.this.combo.getItem(index);
                }
                return null;
            }
        };
        return runnable.run();
    }

    public Class getValueType() {
        Assert.isTrue((this.attribute.equals("text") || this.attribute.equals("selection") ? 1 : 0) != 0, (String)("unexpected attribute" + this.attribute));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

