/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.jface.internal.provisional.databinding.SelectionAwareUpdatableCollection;
import org.eclipse.swt.widgets.List;

public class ListUpdatableCollection
extends SelectionAwareUpdatableCollection {
    private final List list;
    private final String attribute;
    static /* synthetic */ Class class$0;

    public ListUpdatableCollection(List list, String attribute) {
        this.list = list;
        this.attribute = attribute.equals("content") ? "items" : attribute;
        if (!this.attribute.equals("items")) {
            throw new IllegalArgumentException();
        }
    }

    public int computeSize() {
        return this.list.getItemCount();
    }

    public int addElement(Object value, int index) {
        if (index < 0 || index > this.computeSize()) {
            index = this.computeSize();
        }
        String[] newItems = new String[this.computeSize() + 1];
        System.arraycopy(this.list.getItems(), 0, newItems, 0, index);
        newItems[index] = (String)value;
        System.arraycopy(this.list.getItems(), index, newItems, index + 1, this.computeSize() - index);
        this.list.setItems(newItems);
        this.fireChangeEvent(2, null, value, index);
        return index;
    }

    public void removeElement(int index) {
        if (index < 0 || index > this.computeSize()) {
            index = this.computeSize();
        }
        String[] newItems = new String[this.computeSize() - 1];
        String old = this.list.getItem(index);
        System.arraycopy(this.list.getItems(), 0, newItems, 0, index);
        System.arraycopy(this.list.getItems(), index, newItems, index - 1, this.computeSize() - index);
        this.list.setItems(newItems);
        this.fireChangeEvent(4, old, null, index);
    }

    public void setElement(int index, Object value) {
        String old = this.list.getItem(index);
        this.list.setItem(index, (String)value);
        this.fireChangeEvent(1, old, value, index);
    }

    public Object computeElement(int index) {
        return this.list.getItem(index);
    }

    public Class getElementType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Object getSelectedObject() {
        if (this.list.getSelectionCount() > 0) {
            return this.list.getSelection()[0];
        }
        return null;
    }

    public void setSelectedObject(Object object) {
        if (object == null) {
            this.list.setSelection(-1);
        } else {
            int index = this.list.indexOf((String)object);
            if (index > -1) {
                this.list.setSelection(index);
            }
        }
    }
}

