/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.jface.internal.databinding.swt.AsyncRunnable;
import org.eclipse.jface.internal.databinding.swt.SyncRunnable;
import org.eclipse.jface.internal.provisional.databinding.UpdatableValue;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Spinner;

public class SpinnerUpdatableValue
extends UpdatableValue {
    private final Spinner spinner;
    private final String attribute;
    private boolean updating = false;
    static /* synthetic */ Class class$0;

    public SpinnerUpdatableValue(Spinner spinner, String attribute) {
        this.spinner = spinner;
        this.attribute = attribute;
        if (attribute.equals("selection")) {
            spinner.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!SpinnerUpdatableValue.this.updating) {
                        SpinnerUpdatableValue.this.fireChangeEvent(1, null, null);
                    }
                }
            });
        } else if (!attribute.equals("min") && !attribute.equals("max")) {
            throw new IllegalArgumentException("Attribute name not valid: " + attribute);
        }
    }

    public void setValue(final Object value) {
        AsyncRunnable runnable = new AsyncRunnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block9: {
                    block8: {
                        try {
                            int oldValue;
                            SpinnerUpdatableValue.this.updating = true;
                            int newValue = (Integer)value;
                            if (SpinnerUpdatableValue.this.attribute.equals("selection")) {
                                oldValue = SpinnerUpdatableValue.this.spinner.getSelection();
                                SpinnerUpdatableValue.this.spinner.setSelection(newValue);
                            } else if (SpinnerUpdatableValue.this.attribute.equals("min")) {
                                oldValue = SpinnerUpdatableValue.this.spinner.getMinimum();
                                SpinnerUpdatableValue.this.spinner.setMinimum(newValue);
                            } else {
                                if (!SpinnerUpdatableValue.this.attribute.equals("max")) {
                                    Assert.isTrue((boolean)false, (String)("invalid attribute name:" + SpinnerUpdatableValue.this.attribute));
                                    Object var3_3 = null;
                                    break block8;
                                }
                                oldValue = SpinnerUpdatableValue.this.spinner.getMaximum();
                                SpinnerUpdatableValue.this.spinner.setMaximum(newValue);
                            }
                            SpinnerUpdatableValue.this.fireChangeEvent(1, new Integer(oldValue), new Integer(newValue));
                            break block9;
                        }
                        catch (Throwable throwable) {
                            Object var3_4 = null;
                            SpinnerUpdatableValue.this.updating = false;
                            throw throwable;
                        }
                    }
                    SpinnerUpdatableValue.this.updating = false;
                    return;
                }
                Object var3_5 = null;
                SpinnerUpdatableValue.this.updating = false;
            }
        };
        runnable.runOn(this.spinner.getDisplay());
    }

    public Object computeValue() {
        SyncRunnable runnable = new SyncRunnable(){

            public Object run() {
                int value = 0;
                if (SpinnerUpdatableValue.this.attribute.equals("selection")) {
                    value = SpinnerUpdatableValue.this.spinner.getSelection();
                } else if (SpinnerUpdatableValue.this.attribute.equals("min")) {
                    value = SpinnerUpdatableValue.this.spinner.getMinimum();
                } else if (SpinnerUpdatableValue.this.attribute.equals("max")) {
                    value = SpinnerUpdatableValue.this.spinner.getMaximum();
                }
                return new Integer(value);
            }
        };
        return runnable.runOn(this.spinner.getDisplay());
    }

    public Class getValueType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

