/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.jface.internal.databinding.beans.PropertyHelper;
import org.eclipse.jface.internal.databinding.viewers.TableViewerUpdatableCollection;
import org.eclipse.jface.internal.provisional.databinding.ChangeEvent;
import org.eclipse.jface.internal.provisional.databinding.IChangeListener;
import org.eclipse.jface.internal.provisional.databinding.IDataBindingContext;
import org.eclipse.jface.internal.provisional.databinding.converter.IConverter;
import org.eclipse.jface.internal.provisional.databinding.converters.IdentityConverter;
import org.eclipse.jface.internal.provisional.databinding.validator.IValidator;
import org.eclipse.jface.internal.provisional.databinding.viewers.TableViewerDescription;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Text;

public class TableViewerUpdatableCollectionExtended
extends TableViewerUpdatableCollection {
    private final TableViewerDescription tableViewerDescription;
    private ITableLabelProvider tableLabelProvider = new TableLabelProvider();
    private IDataBindingContext dataBindingContext;
    private int updateTime;
    private final IChangeListener dummyListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
        }
    };
    private ColumnInfo[] columnInfos;
    static /* synthetic */ Class class$0;

    public TableViewerUpdatableCollectionExtended(TableViewerDescription tableViewerDescription, IDataBindingContext dataBindingContext, int updateTime) {
        super(tableViewerDescription.getTableViewer());
        this.updateTime = updateTime;
        this.tableViewerDescription = tableViewerDescription;
        this.fillDescriptionDefaults(dataBindingContext);
        TableViewer tableViewer = tableViewerDescription.getTableViewer();
        tableViewer.setLabelProvider((IBaseLabelProvider)this.tableLabelProvider);
        tableViewer.setCellModifier(tableViewerDescription.getCellModifier());
        int columnCount = tableViewerDescription.getColumnCount();
        String[] columnProperties = new String[columnCount];
        CellEditor[] cellEditors = new CellEditor[columnCount];
        int i = 0;
        while (i < columnCount) {
            TableViewerDescription.Column column = tableViewerDescription.getColumn(i);
            columnProperties[i] = column.getPropertyName();
            if (column.isEditable()) {
                cellEditors[i] = column.getCellEditor();
            }
            ++i;
        }
        tableViewer.setColumnProperties(columnProperties);
        tableViewer.setCellEditors(cellEditors);
    }

    protected CellEditor createCellEditor(final TableViewerDescription.Column column) {
        return new TextCellEditor((Composite)this.tableViewerDescription.getTableViewer().getTable()){

            protected void doSetValue(Object value) {
                super.doSetValue(column.getConverter().convertModelToTarget(value));
            }

            protected Object doGetValue() {
                String textValue = (String)super.doGetValue();
                return column.getConverter().convertTargetToModel(textValue);
            }
        };
    }

    protected ICellModifier createCellModifier(final IDataBindingContext dataBindingContext) {
        return new ICellModifier(){

            private TableViewerDescription.Column findColumn(String property) {
                int i = 0;
                while (i < TableViewerUpdatableCollectionExtended.this.tableViewerDescription.getColumnCount()) {
                    TableViewerDescription.Column column = TableViewerUpdatableCollectionExtended.this.tableViewerDescription.getColumn(i);
                    if (column.getPropertyName() != null && column.getPropertyName().equals(property)) {
                        return column;
                    }
                    ++i;
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                TableViewerDescription.Column column = this.findColumn(property);
                return column != null && column.isEditable();
            }

            private List getNestedProperties(String properties) {
                StringTokenizer stk = new StringTokenizer(properties, ".");
                ArrayList<Object> list = new ArrayList<Object>(stk.countTokens());
                while (stk.hasMoreTokens()) {
                    list.add(stk.nextElement());
                }
                return list;
            }

            private Object getGetterValue(Object root, List properties) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                Object result = root;
                int i = 0;
                while (i < properties.size()) {
                    if (result == null) {
                        return null;
                    }
                    String prop = (String)properties.get(i);
                    Method getter = result.getClass().getMethod("get" + prop.substring(0, 1).toUpperCase(Locale.ENGLISH) + prop.substring(1), new Class[0]);
                    result = getter.invoke(result, new Object[0]);
                    ++i;
                }
                return result;
            }

            public Object getValue(Object element, String property) {
                TableViewerDescription.Column column = this.findColumn(property);
                if (column == null) {
                    return null;
                }
                try {
                    return this.getGetterValue(element, this.getNestedProperties(property));
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
                return null;
            }

            public void modify(Object element, String property, Object value) {
                String errorMessage;
                IValidator columnValidator;
                TableViewerDescription.Column column = this.findColumn(property);
                if (column == null) {
                    return;
                }
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                if ((columnValidator = column.getValidator()) != null && (errorMessage = columnValidator.isValid(value)) != null) {
                    dataBindingContext.updateValidationError(TableViewerUpdatableCollectionExtended.this.dummyListener, errorMessage);
                    return;
                }
                try {
                    Object target;
                    String setterSig;
                    List getters = this.getNestedProperties(property);
                    if (getters.size() > 1) {
                        setterSig = (String)getters.get(getters.size() - 1);
                        getters.remove(getters.size() - 1);
                        target = this.getGetterValue(element, getters);
                    } else {
                        setterSig = property;
                        target = element;
                    }
                    Method setter = target.getClass().getMethod("set" + setterSig.substring(0, 1).toUpperCase(Locale.ENGLISH) + setterSig.substring(1), column.getConverter().getModelType());
                    setter.invoke(target, value);
                    TableViewerUpdatableCollectionExtended.this.tableViewerDescription.getTableViewer().refresh(element);
                    return;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private void fillDescriptionDefaults(IDataBindingContext dataBindingContext) {
        this.columnInfos = new ColumnInfo[this.tableViewerDescription.getColumnCount()];
        this.dataBindingContext = dataBindingContext;
        int i = 0;
        while (i < this.tableViewerDescription.getColumnCount()) {
            TableViewerDescription.Column column = this.tableViewerDescription.getColumn(i);
            this.columnInfos[i] = new ColumnInfo();
            if (column.getConverter() == null) {
                this.columnInfos[i].converterDefaulted = true;
                if (column.getPropertyType() != null) {
                    this.initializeColumnConverter(column, column.getPropertyType());
                } else {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    column.setConverter(new IdentityConverter(clazz));
                }
            }
            if (column.getValidator() == null && column.isEditable()) {
                this.columnInfos[i].validatorDefaulted = true;
                this.initializeColumnValidator(column, column.getPropertyType());
            }
            if (column.isEditable()) {
                if (column.getCellEditor() == null) {
                    this.columnInfos[i].cellEditorDefaulted = true;
                    column.setCellEditor(this.createCellEditor(column));
                }
                if (this.updateTime == 0 && column.getCellEditor() != null && column.getCellEditor().getControl() instanceof Text) {
                    Text cfr_ignored_0 = (Text)column.getCellEditor().getControl();
                }
            }
            ++i;
        }
        if (this.tableViewerDescription.getCellModifier() == null) {
            this.tableViewerDescription.setCellModifier(this.createCellModifier(dataBindingContext));
        }
    }

    private void initializeColumnConverter(TableViewerDescription.Column column, Class propertyType) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        column.setConverter(this.dataBindingContext.createConverter(clazz, propertyType, this.tableViewerDescription));
    }

    private void initializeColumnValidator(TableViewerDescription.Column column, Class propertyType) {
        column.setValidator(new IValidator(){

            public String isPartiallyValid(Object value) {
                return null;
            }

            public String isValid(Object value) {
                return null;
            }
        });
    }

    public int addElement(Object element, int index) {
        if (this.columnInfos != null) {
            int i = 0;
            while (i < this.tableViewerDescription.getColumnCount()) {
                PropertyHelper helper;
                Class<?> columnType;
                TableViewerDescription.Column column = this.tableViewerDescription.getColumn(i);
                ColumnInfo columnInfo = this.columnInfos[i];
                if (column.getPropertyType() == null && (columnInfo.cellEditorDefaulted || columnInfo.converterDefaulted || columnInfo.validatorDefaulted) && (columnType = (helper = new PropertyHelper(column.getPropertyName(), element.getClass())).getGetter().getReturnType()) != null) {
                    if (columnInfo.converterDefaulted) {
                        this.initializeColumnConverter(column, columnType);
                    }
                    if (columnInfo.validatorDefaulted) {
                        this.initializeColumnValidator(column, columnType);
                    }
                    if (columnInfo.cellEditorDefaulted) {
                        this.createCellEditor(column);
                    }
                }
                ++i;
            }
            this.columnInfos = null;
        }
        return super.addElement(element, index);
    }

    protected TableViewerDescription.Column getColumn(int columnIndex) {
        return this.tableViewerDescription.getColumn(columnIndex);
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        static /* synthetic */ Class class$0;

        TableLabelProvider() {
        }

        private Object getValue(Object element, TableViewerDescription.Column column) {
            String propertyName = column.getPropertyName();
            if (propertyName == null) {
                return element;
            }
            Object value = TableViewerUpdatableCollectionExtended.this.tableViewerDescription.getCellModifier().getValue(element, propertyName);
            return value;
        }

        private Object getConvertedValue(Object element, TableViewerDescription.Column column) {
            IConverter converter = column.getConverter();
            if (converter != null) {
                Object convertedValue = column.getConverter().convertModelToTarget(this.getValue(element, column));
                return convertedValue;
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            TableViewerDescription.Column column;
            IConverter converter;
            if (columnIndex < TableViewerUpdatableCollectionExtended.this.tableViewerDescription.getColumnCount() && columnIndex >= 0 && (converter = (column = TableViewerUpdatableCollectionExtended.this.getColumn(columnIndex)).getConverter()) != null) {
                ViewerLabel viewerLabel;
                Class clazz = converter.getTargetType();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.jface.viewers.ViewerLabel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(clazz2) && (viewerLabel = (ViewerLabel)this.getConvertedValue(element, column)) != null) {
                    return viewerLabel.getImage();
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Object value = null;
            if (columnIndex < TableViewerUpdatableCollectionExtended.this.tableViewerDescription.getColumnCount() && columnIndex >= 0) {
                TableViewerDescription.Column column = TableViewerUpdatableCollectionExtended.this.getColumn(columnIndex);
                value = this.getConvertedValue(element, column);
                if (value != null) {
                    IConverter converter = column.getConverter();
                    Class clazz = converter.getTargetType();
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.eclipse.jface.viewers.ViewerLabel");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.equals(clazz2)) {
                        ViewerLabel viewerLabel = (ViewerLabel)value;
                        return viewerLabel.getText();
                    }
                }
                if (value == null) {
                    value = this.getValue(element, column);
                }
            }
            if (value == null) {
                return "";
            }
            if (value instanceof String) {
                return (String)value;
            }
            return value.toString();
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }

    class ColumnInfo {
        boolean converterDefaulted;
        boolean validatorDefaulted;
        boolean cellEditorDefaulted;

        ColumnInfo() {
        }
    }
}

