/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.provisional.databinding;

import java.util.Collection;
import org.eclipse.jface.internal.provisional.databinding.ChangeEvent;
import org.eclipse.jface.internal.provisional.databinding.IReadableSet;
import org.eclipse.jface.internal.provisional.databinding.Updatable;
import org.eclipse.jface.internal.provisional.databinding.UpdatableTracker;

public abstract class AbstractUpdatableSet
extends Updatable
implements IReadableSet {
    private ChangeEvent cachedAddEvent = null;
    private ChangeEvent cachedRemoveEvent = null;

    protected final void fireAdded(Collection added) {
        if (added.size() > 0) {
            ChangeEvent event;
            if (this.cachedAddEvent != null) {
                event = this.cachedAddEvent;
                event.newValue = added;
                this.cachedAddEvent = null;
            } else {
                event = new ChangeEvent(this, 256, null, added);
            }
            this.fireChangeEvent(event);
            this.cachedAddEvent = event;
        }
    }

    protected final void fireRemoved(Collection removed) {
        if (removed.size() > 0) {
            ChangeEvent event;
            if (this.cachedRemoveEvent != null) {
                event = this.cachedRemoveEvent;
                event.newValue = removed;
                this.cachedRemoveEvent = null;
            } else {
                event = new ChangeEvent(this, 512, null, removed);
            }
            this.fireChangeEvent(event);
            this.cachedRemoveEvent = event;
        }
    }

    public void dispose() {
    }

    protected final void fireStale(boolean isStale) {
        this.fireChangeEvent(this.createStaleEvent(isStale));
    }

    public final Collection toCollection() {
        UpdatableTracker.getterCalled(this);
        return this.computeElements();
    }

    protected abstract Collection computeElements();
}

