/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.provisional.databinding.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Map;
import org.eclipse.jface.internal.databinding.beans.JavaBeanUpdatableValue;
import org.eclipse.jface.internal.provisional.databinding.IDataBindingContext;
import org.eclipse.jface.internal.provisional.databinding.IUpdatable;
import org.eclipse.jface.internal.provisional.databinding.IUpdatableFactory;
import org.eclipse.jface.internal.provisional.databinding.Property;

public class JavaBeansScalarUpdatableValueFactory
implements IUpdatableFactory {
    public IUpdatable createUpdatable(Map properties, Object description, IDataBindingContext bindingContext) {
        if (!(description instanceof Property)) {
            return null;
        }
        Property property = (Property)description;
        Object collectionContainer = property.getObject();
        String propertyName = (String)property.getPropertyID();
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(collectionContainer.getClass());
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
        boolean found = false;
        int position = 0;
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        while (!found && position < pds.length) {
            if (pds[position].getName().equals(propertyName)) {
                found = true;
                break;
            }
            ++position;
        }
        if (!found) {
            return null;
        }
        JavaBeanUpdatableValue updatable = new JavaBeanUpdatableValue(collectionContainer, pds[position]);
        return updatable;
    }
}

