/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.provisional.databinding.swt;

import java.util.Map;
import org.eclipse.jface.internal.databinding.swt.ButtonUpdatableValue;
import org.eclipse.jface.internal.databinding.swt.CComboUpdatableCollection;
import org.eclipse.jface.internal.databinding.swt.CComboUpdatableValue;
import org.eclipse.jface.internal.databinding.swt.ComboUpdatableCollection;
import org.eclipse.jface.internal.databinding.swt.ComboUpdatableValue;
import org.eclipse.jface.internal.databinding.swt.ControlUpdatableValue;
import org.eclipse.jface.internal.databinding.swt.LabelUpdatableValue;
import org.eclipse.jface.internal.databinding.swt.ListUpdatableCollection;
import org.eclipse.jface.internal.databinding.swt.ListUpdatableValue;
import org.eclipse.jface.internal.databinding.swt.SpinnerUpdatableValue;
import org.eclipse.jface.internal.databinding.swt.TableUpdatableValue;
import org.eclipse.jface.internal.databinding.swt.TextUpdatableValue;
import org.eclipse.jface.internal.databinding.viewers.StructuredViewerUpdatableValue;
import org.eclipse.jface.internal.databinding.viewers.TableViewerUpdatableCollection;
import org.eclipse.jface.internal.databinding.viewers.UpdatableCollectionViewer;
import org.eclipse.jface.internal.provisional.databinding.IDataBindingContext;
import org.eclipse.jface.internal.provisional.databinding.IUpdatable;
import org.eclipse.jface.internal.provisional.databinding.IUpdatableFactory;
import org.eclipse.jface.internal.provisional.databinding.Property;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public final class SWTUpdatableFactory
implements IUpdatableFactory {
    private int updateTime = 1;

    public SWTUpdatableFactory() {
    }

    public SWTUpdatableFactory(int updateTime) {
        this.updateTime = updateTime;
    }

    public IUpdatable createUpdatable(Map properties, Object description, IDataBindingContext bindingContext) {
        if (description instanceof Property) {
            Object object = ((Property)description).getObject();
            Object attribute = ((Property)description).getPropertyID();
            if (object instanceof Control && "enabled".equals(attribute)) {
                return new ControlUpdatableValue((Control)object, (String)attribute);
            }
            if (object instanceof Control && "visible".equals(attribute)) {
                return new ControlUpdatableValue((Control)object, (String)attribute);
            }
            if (object instanceof Spinner && ("selection".equals(attribute) || "min".equals(attribute) || "max".equals(attribute))) {
                return new SpinnerUpdatableValue((Spinner)object, (String)attribute);
            }
            if (object instanceof Text && "text".equals(attribute)) {
                return new TextUpdatableValue((Text)object, 24);
            }
            if (object instanceof Label && "text".equals(attribute)) {
                return new LabelUpdatableValue((Label)object);
            }
            if (object instanceof Button && "selection".equals(attribute)) {
                return new ButtonUpdatableValue((Button)object, 13);
            }
            if (object instanceof Combo && ("text".equals(attribute) || "selection".equals(attribute))) {
                return new ComboUpdatableValue((Combo)object, (String)attribute);
            }
            if (object instanceof Combo && "items".equals(attribute)) {
                return new ComboUpdatableCollection((Combo)object, (String)attribute);
            }
            if (object instanceof CCombo && ("text".equals(attribute) || "selection".equals(attribute))) {
                return new CComboUpdatableValue((CCombo)object, (String)attribute);
            }
            if (object instanceof CCombo && "items".equals(attribute)) {
                return new CComboUpdatableCollection((CCombo)object, (String)attribute);
            }
            if (object instanceof List && "selection".equals(attribute)) {
                return new ListUpdatableValue((List)object, (String)attribute);
            }
            if (object instanceof List && "items".equals(attribute)) {
                return new ListUpdatableCollection((List)object, (String)attribute);
            }
            if (object instanceof StructuredViewer && "selection".equals(attribute)) {
                return new StructuredViewerUpdatableValue((StructuredViewer)object, (String)attribute);
            }
            if (object instanceof AbstractListViewer && "selection".equals(attribute)) {
                return new StructuredViewerUpdatableValue((StructuredViewer)((AbstractListViewer)object), (String)attribute);
            }
            if (object instanceof AbstractListViewer && "content".equals(attribute)) {
                return new UpdatableCollectionViewer((AbstractListViewer)object);
            }
            if (object instanceof TableViewer && "content".equals(attribute)) {
                return new TableViewerUpdatableCollection((TableViewer)object);
            }
            if (object instanceof Table) {
                return new TableUpdatableValue((Table)object, (String)attribute);
            }
        }
        if (description instanceof AbstractListViewer) {
            return new UpdatableCollectionViewer((AbstractListViewer)description);
        }
        if (description instanceof Text) {
            int[] nArray = new int[3];
            nArray[0] = 24;
            nArray[1] = 16;
            int updatePolicy = nArray[this.updateTime];
            return new TextUpdatableValue((Text)description, updatePolicy);
        }
        if (description instanceof Button) {
            int[] nArray = new int[3];
            nArray[0] = 24;
            nArray[1] = 16;
            int updatePolicy = nArray[this.updateTime];
            return new ButtonUpdatableValue((Button)description, updatePolicy);
        }
        if (description instanceof Label) {
            return new LabelUpdatableValue((Label)description);
        }
        if (description instanceof Combo) {
            return new ComboUpdatableCollection((Combo)description, "content");
        }
        if (description instanceof Spinner) {
            return new SpinnerUpdatableValue((Spinner)description, "selection");
        }
        if (description instanceof CCombo) {
            return new CComboUpdatableCollection((CCombo)description, "content");
        }
        if (description instanceof List) {
            return new ListUpdatableCollection((List)description, "content");
        }
        return null;
    }

    public void setUpdateTime(int time) {
        this.updateTime = time;
    }
}

