/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.provisional.databinding.updatables;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.jface.internal.provisional.databinding.AbstractUpdatableSet;
import org.eclipse.jface.internal.provisional.databinding.ChangeEvent;
import org.eclipse.jface.internal.provisional.databinding.IChangeListener;
import org.eclipse.jface.internal.provisional.databinding.IReadableList;
import org.eclipse.jface.util.Assert;

public class ListToSetAdapter
extends AbstractUpdatableSet {
    private IReadableList input;
    private HashSet elements;
    private IChangeListener listener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            switch (changeEvent.getChangeType()) {
                case 1: {
                    if (changeEvent.getPosition() != -1) break;
                    HashSet oldElements = ListToSetAdapter.this.elements;
                    ListToSetAdapter.this.doComputeElements();
                    HashSet addedElements = new HashSet(ListToSetAdapter.this.elements);
                    HashSet removedElements = new HashSet(oldElements);
                    addedElements.removeAll(oldElements);
                    removedElements.removeAll(ListToSetAdapter.this.elements);
                    ListToSetAdapter.this.fireRemoved(removedElements);
                    ListToSetAdapter.this.fireAdded(addedElements);
                    break;
                }
                case 2: {
                    Object added = changeEvent.getNewValue();
                    if (ListToSetAdapter.this.elements.contains(added)) break;
                    ListToSetAdapter.this.elements.add(added);
                    ListToSetAdapter.this.fireAdded(Collections.singleton(added));
                    break;
                }
                case 4: {
                    Object removed = changeEvent.getNewValue();
                    if (!ListToSetAdapter.this.elements.contains(removed)) break;
                    ListToSetAdapter.this.elements.remove(removed);
                    ListToSetAdapter.this.fireRemoved(Collections.singleton(removed));
                    break;
                }
                case 64: {
                    ListToSetAdapter.this.fireStale(ListToSetAdapter.this.input.isStale());
                }
            }
        }
    };

    public ListToSetAdapter(IReadableList input) {
        Assert.isNotNull((Object)input);
        this.input = input;
    }

    public boolean isStale() {
        return this.input.isStale();
    }

    protected Collection computeElements() {
        if (this.elements != null) {
            return this.elements;
        }
        return this.doComputeElements();
    }

    protected void firstListenerAdded() {
        this.input.addChangeListener(this.listener);
        this.elements = this.doComputeElements();
        super.firstListenerAdded();
    }

    protected void lastListenerRemoved() {
        this.input.removeChangeListener(this.listener);
        this.elements = null;
        super.lastListenerRemoved();
    }

    private HashSet doComputeElements() {
        this.elements = new HashSet();
        int idx = 0;
        while (idx < this.input.getSize()) {
            this.elements.add(this.input.getElement(idx));
            ++idx;
        }
        return this.elements;
    }
}

