/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.provisional.databinding.updatables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.internal.provisional.databinding.AbstractUpdatableSet;
import org.eclipse.jface.internal.provisional.databinding.ChangeEvent;
import org.eclipse.jface.internal.provisional.databinding.IChangeListener;
import org.eclipse.jface.internal.provisional.databinding.IReadableSet;
import org.eclipse.jface.util.Assert;

public final class UnionSet
extends AbstractUpdatableSet {
    private HashSet childSets = new HashSet();
    private HashMap refCounts = null;
    private IChangeListener childListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            switch (changeEvent.getChangeType()) {
                case 256: {
                    UnionSet.this.processAdds((Collection)changeEvent.getNewValue());
                    break;
                }
                case 512: {
                    UnionSet.this.processRemoves((Collection)changeEvent.getNewValue());
                    break;
                }
                case 64: {
                    UnionSet.this.processStale((Boolean)changeEvent.getNewValue());
                }
            }
        }
    };
    private int staleCount = 0;

    protected void processStale(boolean isStale) {
        if (isStale) {
            ++this.staleCount;
            if (this.staleCount == 1) {
                this.fireStale(true);
            }
        } else {
            --this.staleCount;
            if (this.staleCount == 0) {
                this.fireStale(false);
            }
        }
    }

    public boolean isStale() {
        if (this.refCounts != null) {
            return this.staleCount > 0;
        }
        IReadableSet[] children = this.childSets.toArray(new IReadableSet[this.childSets.size()]);
        int i = 0;
        while (i < children.length) {
            IReadableSet readableSet = children[i];
            if (readableSet.isStale()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void add(IReadableSet s) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        Assert.isNotNull((Object)s);
        this.childSets.add(s);
        if (this.refCounts != null) {
            this.initChild(s);
        }
    }

    public void remove(IReadableSet s) {
        Assert.isTrue((!this.isDisposed() ? 1 : 0) != 0);
        Assert.isNotNull((Object)s);
        this.childSets.remove(s);
        if (this.refCounts != null) {
            this.deinitChild(s);
        }
    }

    private void processRemoves(Collection added) {
        ArrayList removes = new ArrayList();
        Iterator iter = added.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            Integer refCount = (Integer)this.refCounts.get(next);
            if (refCount == null) continue;
            int refs = refCount;
            if (refs <= 1) {
                removes.add(next);
                this.refCounts.remove(next);
                continue;
            }
            refCount = new Integer(refCount - 1);
            this.refCounts.put(next, refCount);
        }
        this.fireRemoved(removes);
    }

    protected void firstListenerAdded() {
        super.firstListenerAdded();
        this.refCounts = new HashMap();
        this.staleCount = 0;
        IReadableSet[] children = this.childSets.toArray(new IReadableSet[this.childSets.size()]);
        int i = 0;
        while (i < children.length) {
            IReadableSet next = children[i];
            next.addChangeListener(this.childListener);
            if (next.isStale()) {
                ++this.staleCount;
            }
            this.incrementRefCounts(next.toCollection());
            ++i;
        }
    }

    protected void lastListenerRemoved() {
        super.lastListenerRemoved();
        IReadableSet[] children = this.childSets.toArray(new IReadableSet[this.childSets.size()]);
        int i = 0;
        while (i < children.length) {
            IReadableSet next = children[i];
            next.removeChangeListener(this.childListener);
            ++i;
        }
        this.refCounts = null;
    }

    private void initChild(IReadableSet child) {
        Collection added = child.toCollection();
        child.addChangeListener(this.childListener);
        if (child.isStale()) {
            this.processStale(true);
        }
        this.processAdds(added);
    }

    private void deinitChild(IReadableSet child) {
        Collection removed = child.toCollection();
        child.removeChangeListener(this.childListener);
        if (child.isStale()) {
            this.processStale(false);
        }
        this.processRemoves(removed);
    }

    private void processAdds(Collection added) {
        ArrayList adds = this.incrementRefCounts(added);
        this.fireAdded(adds);
    }

    private ArrayList incrementRefCounts(Collection added) {
        ArrayList adds = new ArrayList();
        Iterator iter = added.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            Integer refCount = (Integer)this.refCounts.get(next);
            if (refCount == null) {
                adds.add(next);
                refCount = new Integer(1);
                this.refCounts.put(next, refCount);
                continue;
            }
            refCount = new Integer(refCount + 1);
            this.refCounts.put(next, refCount);
        }
        return adds;
    }

    protected Collection computeElements() {
        if (this.refCounts == null) {
            HashSet result = new HashSet();
            Iterator iter = this.childSets.iterator();
            while (iter.hasNext()) {
                IReadableSet next = (IReadableSet)iter.next();
                result.addAll(next.toCollection());
            }
            return result;
        }
        return this.refCounts.keySet();
    }
}

