/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.provisional.databinding.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.internal.provisional.databinding.validator.IValidator;

public class RegexStringValidator
implements IValidator {
    private Pattern fragmentRegex;
    private Pattern fullValueRegex;
    private String hint;

    public RegexStringValidator(String partiallyValidRegex, String fullyValidRegex, String hint) {
        this.fragmentRegex = Pattern.compile(partiallyValidRegex);
        this.fullValueRegex = Pattern.compile(fullyValidRegex);
        this.hint = hint;
    }

    public String isPartiallyValid(Object fragment) {
        Matcher matcher = this.fragmentRegex.matcher((String)fragment);
        if (matcher.find()) {
            return null;
        }
        return this.hint;
    }

    public String isValid(Object value) {
        String stringValue = (String)value;
        Matcher matcher = this.fullValueRegex.matcher(stringValue);
        if (matcher.find()) {
            return null;
        }
        return this.hint;
    }
}

