/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.provisional.databinding.validators;

import org.eclipse.jface.internal.databinding.BindingMessages;
import org.eclipse.jface.internal.provisional.databinding.validator.IValidator;

public class String2DoubleValidator
implements IValidator {
    public String isPartiallyValid(Object fragment) {
        if (((String)fragment).matches("\\-?[0-9]*\\.?[0-9]*([0-9]+[e|E]\\-?([0-9]+\\.)?[0-9]*)?")) {
            return null;
        }
        return this.getHint();
    }

    public String isValid(Object value) {
        try {
            Double.parseDouble((String)value);
            return null;
        }
        catch (Throwable throwable) {
            return this.getHint();
        }
    }

    private String getHint() {
        return String.valueOf(BindingMessages.getString("Validate_Like")) + BindingMessages.getString("Validate_Number_Examples") + Double.MIN_VALUE + ", " + Double.MAX_VALUE + ".";
    }
}

