/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.provisional.databinding.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.internal.provisional.databinding.converter.IConverter;
import org.eclipse.jface.internal.provisional.databinding.validator.IValidator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;

public class TableViewerDescription {
    public static final String COLUMN_PROPERTY_NESTING_SEPERATOR = ".";
    private TableViewer tableViewer;
    private List columns = new ArrayList();
    private ICellModifier cellModifier = null;

    public TableViewerDescription(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    public void addEditableColumn(int columnIndex, String propertyName, CellEditor cellEditor, IValidator validator, IConverter converter) {
        Column column = new Column(propertyName, cellEditor, validator, converter);
        if (columnIndex == -1) {
            this.columns.add(column);
        } else {
            this.columns.add(columnIndex, column);
        }
    }

    private void addReadOnlyColumn(int columnIndex, String propertyName, IConverter converter) {
        Column column = new Column(propertyName, converter);
        if (columnIndex == -1) {
            this.columns.add(column);
        } else {
            this.columns.add(columnIndex, column);
        }
    }

    public void addEditableColumn(String propertyName, CellEditor cellEditor, IValidator validator, IConverter converter) {
        this.addEditableColumn(-1, propertyName, cellEditor, validator, converter);
    }

    public void addColumn(int columnIndex, String propertyName, IConverter converter) {
        this.addReadOnlyColumn(columnIndex, propertyName, converter);
    }

    public void addColumn(String propertyName, IConverter converter) {
        this.addReadOnlyColumn(-1, propertyName, converter);
    }

    public void addColumn(String propertyName) {
        this.addReadOnlyColumn(-1, propertyName, null);
    }

    public void addEditableColumn(String propertyName) {
        this.addEditableColumn(-1, propertyName);
    }

    public void addEditableColumn(int index, String propertyName) {
        this.addEditableColumn(index, propertyName, null, null, null);
    }

    public void addColumn(int columnIndex, String propertyName) {
        this.addReadOnlyColumn(columnIndex, propertyName, null);
    }

    public ICellModifier getCellModifier() {
        return this.cellModifier;
    }

    public void setCellModifier(ICellModifier cellModifier) {
        this.cellModifier = cellModifier;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Column getColumn(int columnIndex) {
        return (Column)this.columns.get(columnIndex);
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public static class Column {
        private String propertyName;
        private Class propertyType;
        private IValidator validator;
        private IConverter converter;
        private CellEditor cellEditor;
        private boolean readOnly = true;

        public Column(String propertyName, CellEditor cellEditor, IValidator validator, IConverter converter) {
            this.propertyName = propertyName;
            this.cellEditor = cellEditor;
            this.validator = validator;
            this.converter = converter;
            this.readOnly = false;
        }

        Column(String propertyName, IConverter converter) {
            this.propertyName = propertyName;
            this.converter = converter;
            this.readOnly = true;
        }

        public IConverter getConverter() {
            return this.converter;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public IValidator getValidator() {
            return this.validator;
        }

        public void setConverter(IConverter converter) {
            this.converter = converter;
        }

        public void setValidator(IValidator validator) {
            this.validator = validator;
        }

        public CellEditor getCellEditor() {
            return this.cellEditor;
        }

        public void setCellEditor(CellEditor cellEditor) {
            this.cellEditor = cellEditor;
        }

        public Class getPropertyType() {
            return this.propertyType;
        }

        public void setPropertyType(Class propertyType) {
            this.propertyType = propertyType;
        }

        public boolean isEditable() {
            return !this.readOnly;
        }
    }
}

