/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.provisional.databinding.viewers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.internal.provisional.databinding.AbstractUpdatableSet;
import org.eclipse.jface.internal.provisional.databinding.ChangeEvent;
import org.eclipse.jface.internal.provisional.databinding.IChangeListener;
import org.eclipse.jface.internal.provisional.databinding.IReadableSet;
import org.eclipse.jface.internal.provisional.databinding.updatables.EmptyReadableSet;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.AcceptAllFilter;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public final class UpdatableSetContentProvider
implements IStructuredContentProvider {
    private IReadableSet readableSet = EmptyReadableSet.getInstance();
    private Viewer viewer;
    private IFilter filter = AcceptAllFilter.getInstance();
    private KnownElementsSet elements = new KnownElementsSet();
    private IChangeListener listener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            if (UpdatableSetContentProvider.this.isDisposed()) {
                return;
            }
            switch (changeEvent.getChangeType()) {
                case 256: {
                    this.added((Collection)changeEvent.getNewValue());
                    break;
                }
                case 512: {
                    UpdatableSetContentProvider.this.doRemove((Collection)changeEvent.getNewValue(), !UpdatableSetContentProvider.this.viewer.getControl().isDisposed());
                    break;
                }
                case 64: {
                    UpdatableSetContentProvider.this.elements.doFireStale((Boolean)changeEvent.getNewValue());
                }
            }
        }

        private void added(Collection added) {
            ArrayList filtered = new ArrayList();
            Iterator iter = added.iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                if (!UpdatableSetContentProvider.this.filter.select(object)) continue;
                filtered.add(object);
            }
            UpdatableSetContentProvider.this.doAdd(filtered, !UpdatableSetContentProvider.this.viewer.getControl().isDisposed());
        }
    };

    public void setFilter(IFilter filter) {
        this.filter = filter;
    }

    public Object[] getElements(Object inputElement) {
        return this.readableSet.toCollection().toArray();
    }

    private void doAdd(Collection added, boolean updateViewer) {
        this.elements.doFireAdd(added);
        if (updateViewer) {
            Object[] toAdd = added.toArray();
            if (this.viewer instanceof TableViewer) {
                TableViewer tv = (TableViewer)this.viewer;
                tv.add(toAdd);
            } else if (this.viewer instanceof AbstractListViewer) {
                AbstractListViewer lv = (AbstractListViewer)this.viewer;
                lv.add(toAdd);
            }
        }
    }

    private void doRemove(Collection toRemove, boolean updateViewer) {
        if (updateViewer) {
            Object[] removed = toRemove.toArray();
            if (this.viewer instanceof TableViewer) {
                TableViewer tv = (TableViewer)this.viewer;
                tv.remove(removed);
            } else if (this.viewer instanceof AbstractListViewer) {
                AbstractListViewer lv = (AbstractListViewer)this.viewer;
                lv.remove(removed);
            }
        }
        this.elements.doFireRemove(toRemove);
    }

    public IReadableSet getKnownElements() {
        return this.elements;
    }

    public void dispose() {
        this.setInput(null);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (!(viewer instanceof TableViewer) && !(viewer instanceof AbstractListViewer)) {
            throw new IllegalArgumentException("This content provider only works with TableViewer of AbstractListViewer");
        }
        if (newInput != null && !(newInput instanceof IReadableSet)) {
            throw new IllegalArgumentException("This content provider only works with input of type IReadableSet");
        }
        this.setInput((IReadableSet)newInput);
    }

    private void setInput(IReadableSet newSet) {
        boolean isStale;
        boolean updateViewer = true;
        if (newSet == null) {
            newSet = EmptyReadableSet.getInstance();
            updateViewer = false;
        }
        boolean wasStale = false;
        if (this.readableSet != null) {
            this.readableSet.removeChangeListener(this.listener);
            wasStale = this.readableSet.isStale();
        }
        Collection oldCollection = this.readableSet.toCollection();
        Collection newCollection = newSet.toCollection();
        HashSet additions = new HashSet();
        HashSet removals = new HashSet();
        additions.addAll(newCollection);
        additions.removeAll(oldCollection);
        removals.addAll(oldCollection);
        removals.removeAll(newCollection);
        this.readableSet = newSet;
        this.doAdd(additions, updateViewer);
        this.doRemove(removals, updateViewer);
        if (this.readableSet != null) {
            this.readableSet.addChangeListener(this.listener);
        }
        boolean bl = isStale = this.readableSet != null && this.readableSet.isStale();
        if (isStale != wasStale) {
            this.elements.doFireStale(isStale);
        }
    }

    private boolean isDisposed() {
        return this.viewer.getControl() == null || this.viewer.getControl().isDisposed();
    }

    private class KnownElementsSet
    extends AbstractUpdatableSet {
        KnownElementsSet() {
        }

        protected Collection computeElements() {
            return UpdatableSetContentProvider.this.readableSet.toCollection();
        }

        void doFireAdd(Collection added) {
            this.fireAdded(added);
        }

        void doFireRemove(Collection removed) {
            this.fireRemoved(removed);
        }

        void doFireStale(boolean isStale) {
            this.fireStale(isStale);
        }
    }
}

